/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.compat.se.net.downloader.se;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.gvsig.compat.se.net.downloader.se.SEDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSEDownloaderTask
implements Runnable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSEDownloaderTask.class);
    protected final URL url;
    protected final File dstFile;
    protected final Object groupID;
    protected final String data;
    protected final ContentType contenttype;
    protected final String method;
    protected final SEDownloader downloader;
    private int maxbytes;
    private final Executor executor;
    private Exception lastException;

    public AbstractSEDownloaderTask(SEDownloader downloader, Executor executor, URL url, String data, File dstFile, Object groupID) {
        this(downloader, executor, url, null, null, data, dstFile, groupID);
    }

    public AbstractSEDownloaderTask(SEDownloader downloader, Executor executor, URL url, String method, ContentType contenttype, String data, File dstFile, Object groupID) {
        this.url = url;
        this.data = data;
        this.dstFile = dstFile;
        this.groupID = groupID;
        this.downloader = downloader;
        this.maxbytes = -1;
        this.executor = executor;
        this.method = StringUtils.isBlank((CharSequence)method) ? (StringUtils.isBlank((CharSequence)data) ? "GET" : "POST") : method;
        this.contenttype = StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)"GET") ? null : (contenttype == null ? ContentType.create((String)ContentType.TEXT_XML.getMimeType(), (Charset)StandardCharsets.UTF_8) : contenttype);
        downloader.setDownloadException(null);
    }

    public void setMaxbytes(int maxbytes) {
        this.maxbytes = maxbytes;
    }

    public int getMaxbytes() {
        return this.maxbytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(InputStream is) throws IOException {
        block5: {
            DataOutputStream dos = null;
            DataInputStream dis = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                fos = new FileOutputStream(this.dstFile);
                if (is == null) break block5;
                bos = new BufferedOutputStream(fos);
                dos = new DataOutputStream(bos);
                dis = new DataInputStream(is);
                byte[] buffer = new byte[4096];
                long readed = 0L;
                int i = dis.read(buffer);
                while (!this.isCanceled() && i > 0) {
                    dos.write(buffer, 0, i);
                    if (this.maxbytes > 0 && (readed += (long)i) > (long)this.maxbytes) {
                        break;
                    }
                    i = dis.read(buffer);
                }
            }
            finally {
                IOUtils.closeQuietly(dos);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((OutputStream)fos);
                IOUtils.closeQuietly(dis);
            }
        }
    }

    protected boolean isCanceled() {
        return this.downloader.getCanceled(this.groupID);
    }

    protected int getTimeout() {
        Preferences prefs = Preferences.userRoot().node("gvsig.downloader");
        int timeout = prefs.getInt("timeout", 60000);
        return timeout;
    }

    protected void postdownload() {
        if (this.isCanceled()) {
            LOGGER.info("[Downloader] '" + this.url + "' CANCELED.");
            this.dstFile.delete();
        } else {
            this.downloader.addDownloadedURL(this.url, this.dstFile.getAbsolutePath());
        }
    }

    protected void exception(Exception e) {
        LOGGER.info("Error downloading", (Throwable)e);
        this.lastException = e;
        this.downloader.setDownloadException(e);
    }

    public Exception getLastException() {
        return this.lastException;
    }

    protected void disableHttsValidation() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    protected Executor getExecutor() {
        return this.executor;
    }
}

