/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.colormgr;

import com.jeta.forms.colormgr.ColorManager;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DefaultColorManager
implements ColorManager {
    private LinkedList m_color_keys;

    public Collection getColorKeys() {
        if (this.m_color_keys == null) {
            this.m_color_keys = new LinkedList();
            this.m_color_keys.add("constant");
            this.m_color_keys.add("control");
            TreeSet<String> default_colors = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            try {
                UIDefaults defs = UIManager.getLookAndFeelDefaults();
                LinkedList keys = new LinkedList(defs.keySet());
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    Object value = defs.get(key);
                    if (!(value instanceof Color) || "control".equals(key)) continue;
                    default_colors.add(key.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iter = default_colors.iterator();
            while (iter.hasNext()) {
                this.m_color_keys.add(iter.next());
            }
        }
        return this.m_color_keys;
    }

    public Color getColor(String colorKey, Color defaultColor) {
        Color c = UIManager.getColor(colorKey);
        if (c != null) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }
        return c == null ? defaultColor : c;
    }
}

