/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.webbrowser.jfx;

import java.net.URL;
import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import org.gvsig.webbrowser.WebBrowserPanel;

class JFXWebBrowser
extends JFXPanel
implements WebBrowserPanel.WebBrowser {
    private static final long serialVersionUID = 3021277085276506035L;
    private WebView view;
    private WebEngine engine;
    private Scene scene;
    private final WebBrowserPanel webBrowserPanel;

    public JFXWebBrowser(WebBrowserPanel webBrowserPanel) {
        this.webBrowserPanel = webBrowserPanel;
        this.view = null;
        this.engine = null;
        this.scene = null;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JFXWebBrowser.this.createScene();
            }
        });
        Platform.setImplicitExit((boolean)false);
    }

    private void createScene() {
        this.view = new WebView();
        this.engine = this.view.getEngine();
        this.engine.setOnStatusChanged((EventHandler)new MyEventHandler());
        this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new MyChangeListener());
        this.engine.setJavaScriptEnabled(true);
        this.scene = new Scene((Parent)this.view);
        this.setScene(this.scene);
    }

    private void load(URL url) {
        this.engine.load(url.toString());
        this.revalidate();
    }

    private void loadContent(String content, String contentType) {
        this.engine.loadContent(content, contentType);
        this.revalidate();
    }

    private void goHistory(int index) {
        this.engine.getHistory().go(index);
    }

    public void setPage(final URL url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JFXWebBrowser.this.load(url);
            }
        });
    }

    public void setContent(final String content, final String contentType) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JFXWebBrowser.this.loadContent(content, contentType);
            }
        });
    }

    public void goPrevious() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JFXWebBrowser.this.goHistory(-1);
            }
        });
    }

    public void goNext() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JFXWebBrowser.this.goHistory(1);
            }
        });
    }

    public String getPage() {
        return this.engine.getLocation();
    }

    public String getTitle() {
        return this.engine.getTitle();
    }

    public Object executeScript(String js) {
        Object r = this.engine.executeScript(js);
        return r;
    }

    public void find(final String text, final boolean backwards) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String script = MessageFormat.format("window.find(\"{0}\",false,{1},true)", text, backwards ? "true" : "false");
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private class MyChangeListener
    implements ChangeListener<Worker.State> {
        private MyChangeListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
            if (newState == Worker.State.SUCCEEDED) {
                JFXWebBrowser.this.webBrowserPanel.setURLText(JFXWebBrowser.this.engine.getLocation());
            }
        }
    }

    private class MyEventHandler
    implements EventHandler<WebEvent<String>> {
        private MyEventHandler() {
        }

        public void handle(WebEvent<String> event) {
            if (event.getEventType() == WebEvent.STATUS_CHANGED) {
                String s = (String)event.getData();
                if (s == null) {
                    JFXWebBrowser.this.webBrowserPanel.setURLText("");
                } else {
                    JFXWebBrowser.this.webBrowserPanel.setURLText(s);
                }
            }
        }
    }
}

