/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.filedialogchooser.impl;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JFileChooser;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.filedialogchooser.impl.DefaultFileDialogChooserManager;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.util.ToolsUtilLocator;

public class JFileChooserBased
extends JFileChooser
implements FileDialogChooser {
    private static final long serialVersionUID = 2825200958209418322L;
    private final String fileChooserID;
    private boolean visibleCharsetPicker;
    private CharsetPickerController charsetPicker;

    public JFileChooserBased(String fileChooserID) {
        this.fileChooserID = fileChooserID;
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        int r;
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        File f = manager.getLastPath(this.fileChooserID, null);
        if (f == null) {
            f = this.getCurrentDirectory();
            if (f == null) {
                f = new File(System.getProperty("user.home"));
                this.setCurrentDirectory(f);
            }
        } else {
            this.setCurrentDirectory(f);
        }
        if (this.visibleCharsetPicker) {
            this.charsetPicker = DefaultFileDialogChooserManager.setCharsetAccesoryPanel(this);
        }
        if ((r = super.showOpenDialog(parent)) == 0) {
            manager.setLastPath(this.fileChooserID, this.getCurrentDirectory());
        }
        return r;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        return this.showSaveDialog(parent, null);
    }

    public int showSaveDialog(Component parent, File folder) throws HeadlessException {
        int r;
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        if (folder != null) {
            super.setCurrentDirectory(folder);
        } else {
            File f = manager.getLastPath(this.fileChooserID, this.getCurrentDirectory());
            super.setCurrentDirectory(f);
        }
        if (this.visibleCharsetPicker) {
            this.charsetPicker = DefaultFileDialogChooserManager.setCharsetAccesoryPanel(this);
        }
        if ((r = super.showSaveDialog(parent)) == 0) {
            manager.setLastPath(this.fileChooserID, this.getCurrentDirectory());
        }
        return r;
    }

    public void setVisibleCharsetPicker(boolean b) {
        this.visibleCharsetPicker = b;
    }

    public Charset getCharset() {
        if (this.charsetPicker == null) {
            return null;
        }
        return (Charset)this.charsetPicker.get();
    }
}

