/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.Statement;
import org.gvsig.expressionevaluator.impl.I18N;

public class DefaultStatement
implements Statement {
    private final List<Statement.Rule> rules = new ArrayList<Statement.Rule>();
    private final String name;
    private Statement.StatementBuilder stmtBuilder = null;

    public DefaultStatement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Statement.Rule require_any_token(String ... token) {
        return new RuleRequireAnyToken(token);
    }

    public Statement.Rule require_tokens(String ... token) {
        return new RuleRequireTokens(token);
    }

    public Statement.Rule require_identifier() {
        return new RuleRequireIdentifier();
    }

    public Statement.Rule require_identifiers(String sep) {
        return new RuleRequireIdentifiers(sep);
    }

    public Statement.Rule require_identifiers_as_string(String sep) {
        return new RuleRequireIdentifiersAsString(sep);
    }

    public Statement.Rule require_literal_string() {
        return new RuleRequireLiteralString();
    }

    public Statement.Rule set_expression(String id, Object value) {
        return new RuleSetExpression(id, value);
    }

    public Statement.Rule require_expression() {
        return this.require_expression(true);
    }

    public Statement.Rule require_expression(boolean allow_assignement) {
        return new RuleRequireExpression(allow_assignement);
    }

    public Statement.ConditionalRule optional_expression() {
        return new RuleOptionalExpression();
    }

    public Statement.Rule require_expressions(String separator) {
        return new RuleRequiereExpressions(separator, null);
    }

    public Statement.Rule require_expressions(String separator, String ... terminationTokens) {
        return new RuleRequiereExpressions(separator, terminationTokens);
    }

    public Statement.ConditionalRule optional_any_token(String ... id) {
        return new RuleOptionalAnyToken(id);
    }

    public Statement.ConditionalRule if_compatibility_contains(String compatid, String expected) {
        return new RuleOptionalCompatibilityContains(compatid, expected);
    }

    public Statement.ConditionalRule optional_identifiers(String separator) {
        return new RuleOptionalIdentifiers(separator);
    }

    public Statement.ConditionalRule optional_literal_string() {
        return new RuleOptionalLiteralString();
    }

    public Statement.CompoundRule repeat_until_any_tokens(String ... tokens) {
        return new RuleRepeatUntilAnyTokens(tokens);
    }

    public Statement addRule(Statement.Rule rule) {
        this.rules.add(rule);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicable(Statement.StatementContext context) {
        if (this.rules.isEmpty()) {
            return false;
        }
        context.trace(this.getName() + ".isApplicable");
        context.save_state();
        try {
            for (Statement.Rule rule : this.rules) {
                if (rule == null) continue;
                if (rule instanceof IsApplicableRule) {
                    if (((IsApplicableRule)rule).isApplicable(context)) continue;
                    context.trace(this.getName() + ".isApplicable return false");
                    boolean bl = false;
                    return bl;
                }
                rule.parse(context);
            }
            context.trace(this.getName() + ".isApplicable return true");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            context.trace(this.getName() + ".isApplicable return false (error)");
            boolean bl = false;
            return bl;
        }
        finally {
            context.restore_state();
        }
    }

    public Statement.ArgsBuilder args_names(String ... args) {
        ArgsBuilderFromNames x = new ArgsBuilderFromNames(args);
        return x;
    }

    public Statement.ArgsBuilder fixed_args_names(String ... args) {
        FixedArgsBuilderFromNames x = new FixedArgsBuilderFromNames(args);
        return x;
    }

    public Statement.ArgsBuilder args_expand(String ... args) {
        ArgsBuilderExpand x = new ArgsBuilderExpand(args);
        return x;
    }

    public void code(String id, Statement.ArgsBuilder argsBuilder) {
        this.builder(new StatementBuilderBase(id, argsBuilder));
    }

    public void builder(Statement.StatementBuilder builder) {
        this.stmtBuilder = builder;
    }

    public Code parse(Statement.StatementContext context) {
        context.trace(this.getName() + ".parse");
        for (Statement.Rule rule : this.rules) {
            rule.parse(context);
        }
        Code code = this.stmtBuilder.build(context);
        context.trace(this.getName() + ".return " + code);
        return code;
    }

    public String toString() {
        return this.getName() + " " + StringUtils.join(this.rules, (String)";");
    }

    public Statement.CompoundRule repeat() {
        return new RuleRepeat();
    }

    public Statement.Rule fail() {
        return new RuleFail();
    }

    public Statement.Rule break_loop() {
        return new RuleBreakLoop();
    }

    public Statement.SwichTokenRule switch_token() {
        return new RuleSwitchToken();
    }

    public static class StatementBuilderBase
    implements Statement.StatementBuilder {
        protected Statement.ArgsBuilder argsBuilder;
        protected String codeID;

        public StatementBuilderBase(String codeID, Statement.ArgsBuilder argsBuilder) {
            this.codeID = codeID;
            this.argsBuilder = argsBuilder;
        }

        public String getCodeID() {
            return this.codeID;
        }

        public Statement.ArgsBuilder getArgsBuilder() {
            return this.argsBuilder;
        }

        public Code build(Statement.StatementContext context) {
            Codes args = this.getArgsBuilder().build(context);
            Code code = null;
            if (this.getCodeID() == null) {
                code = (Code)args.get(0);
            } else if (args.size() == 0) {
                code = context.getCodeBuilder().function(this.getCodeID(), null);
            } else {
                Code code0;
                if (args.size() == 1 && StringUtils.equalsIgnoreCase((CharSequence)"BLOCK", (CharSequence)this.getCodeID()) && (code0 = (Code)args.get(0)).code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)"BLOCK", (CharSequence)((Code.Callable)code0).name())) {
                    code = code0;
                }
                if (code == null) {
                    code = context.getCodeBuilder().function(this.getCodeID(), args);
                }
            }
            return code;
        }
    }

    public static class ArgsBuilderExpand
    extends ArgsBuilderFromNames {
        public ArgsBuilderExpand(String ... argNames) {
            super(argNames);
        }

        @Override
        public String toString() {
            return "args_expand(" + StringUtils.join((Object[])this.argNames, (String)",") + ")";
        }

        @Override
        public Codes build(Statement.StatementContext context) {
            MutableCodes args = context.getCodeBuilder().args();
            Codes base_args = super.build(context);
            for (Code arg : base_args) {
                if (arg.code() == 2 && ((Code.Callable)arg).name().equals("BLOCK")) {
                    Codes block_args = ((Code.Callable)arg).parameters();
                    for (Code block_arg : block_args) {
                        args.add(block_arg);
                    }
                    continue;
                }
                args.add(arg);
            }
            return args;
        }
    }

    public static class FixedArgsBuilderFromNames
    implements Statement.ArgsBuilder {
        protected final String[] argNames;

        public FixedArgsBuilderFromNames(String ... argNames) {
            this.argNames = argNames;
        }

        public String toString() {
            return "fixed_args_names(" + StringUtils.join((Object[])this.argNames, (String)",") + ")";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            CodeBuilder codeBuilder = context.getCodeBuilder();
            MutableCodes args = codeBuilder.args();
            if (this.argNames != null) {
                for (String argName : this.argNames) {
                    if (argName.contains("#")) {
                        String argNameX;
                        Code code;
                        int n = 1;
                        MutableCodes argsX = codeBuilder.args();
                        while ((code = context.getCode(argNameX = StringUtils.replace((String)argName, (String)"#", (String)String.valueOf(n).trim(), (int)1))) != null) {
                            argsX.add(code);
                            ++n;
                        }
                        args.add((Code)codeBuilder.tuple((Codes)argsX));
                        continue;
                    }
                    Code code = context.getCode(argName);
                    if (code == null) {
                        code = context.getCodeBuilder().constant(null);
                    }
                    args.add(code);
                }
            }
            return args;
        }
    }

    public static class ArgsBuilderFromNames
    implements Statement.ArgsBuilder {
        protected final String[] argNames;

        public ArgsBuilderFromNames(String ... argNames) {
            this.argNames = argNames;
        }

        public String toString() {
            return "args_names(" + StringUtils.join((Object[])this.argNames, (String)",") + ")";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            MutableCodes args = context.getCodeBuilder().args();
            if (this.argNames != null) {
                for (String argName : this.argNames) {
                    Code code;
                    if (argName.contains("#")) {
                        code = context.getCode(argName);
                        if (code == null) {
                            String argNameX;
                            int n = 1;
                            while ((code = context.getCode(argNameX = StringUtils.replace((String)argName, (String)"#", (String)String.valueOf(n).trim(), (int)1))) != null) {
                                args.add(code);
                                ++n;
                            }
                            continue;
                        }
                        args.add(code);
                        continue;
                    }
                    code = context.getCode(argName);
                    args.add(code);
                }
            }
            return args;
        }
    }

    public class RuleOptionalLiteralString
    extends AbstractConditionalRule
    implements Statement.ConditionalRule {
        private String id;

        @Override
        public Statement.ConditionalRule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            if (token.getType() == 1) {
                if (this.id != null) {
                    String s = (String)token.getValue();
                    Code.Constant code = context.getCodeBuilder().constant((Object)s);
                    context.setCode(this.id, (Code)code);
                    context.next_token();
                }
                this.parseOnTrueRules(context);
            } else {
                this.parseOnFalseRules(context);
            }
        }

        public String toString() {
            return "optional_literal_string('" + this.id + "')";
        }
    }

    public class RuleRequireIdentifiersAsString
    implements Statement.Rule {
        private String id;
        private final String separator;

        public RuleRequireIdentifiersAsString(String separator) {
            this.separator = separator;
        }

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            String identifier;
            context.trace(this.toString() + ".parse");
            StringBuilder sb = new StringBuilder();
            MutableCodes args = context.getCodeBuilder().args();
            LexicalAnalyzer.Token token = context.look_token();
            while (token.getType() == 0 && !context.isReservedWord(identifier = token.getLiteral())) {
                if (sb.length() > 0) {
                    sb.append(this.separator);
                }
                sb.append(identifier);
                context.next_token();
                token = context.look_token();
                if (!token.is(new String[]{this.separator})) break;
                context.next_token();
                token = context.look_token();
            }
            if (StringUtils.isBlank((CharSequence)sb)) {
                throw new ExpressionSyntaxException(I18N.An_identifier_was_expected_and_XliteralX_was_found(token.getLiteral()), context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                Code.Constant code = context.getCodeBuilder().constant((Object)sb.toString());
                context.setCode(this.id, (Code)code);
            }
        }

        public String toString() {
            return "require_identifiers('" + this.id + "', '" + this.separator + "')";
        }
    }

    public class RuleRequireIdentifiers
    implements Statement.Rule {
        private String id;
        private final String separator;

        public RuleRequireIdentifiers(String separator) {
            this.separator = separator;
        }

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            String identifier;
            context.trace(this.toString() + ".parse");
            MutableCodes args = context.getCodeBuilder().args();
            LexicalAnalyzer.Token token = context.look_token();
            while (token.getType() == 0 && !context.isReservedWord(identifier = token.getLiteral())) {
                Code.Identifier code = context.getCodeBuilder().identifier(identifier);
                args.add((Code)code);
                context.next_token();
                token = context.look_token();
                if (!token.is(new String[]{this.separator})) break;
                context.next_token();
                token = context.look_token();
            }
            if (args.size() == 0) {
                throw new ExpressionSyntaxException(I18N.An_identifier_was_expected_and_XliteralX_was_found(token.getLiteral()), context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                Code.Callable code = context.getCodeBuilder().function("TUPLE", (Codes)args);
                context.setCode(this.id, (Code)code);
            }
        }

        public String toString() {
            return "require_identifiers('" + this.id + "', '" + this.separator + "')";
        }
    }

    public class RuleOptionalIdentifiers
    extends AbstractConditionalRule
    implements Statement.ConditionalRule {
        private String id;
        private final String separator;

        public RuleOptionalIdentifiers(String separator) {
            this.separator = separator;
        }

        @Override
        public Statement.ConditionalRule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            String identifier;
            context.trace(this.toString() + ".parse");
            MutableCodes args = context.getCodeBuilder().args();
            LexicalAnalyzer.Token token = context.look_token();
            while (token.getType() == 0 && !context.isReservedWord(identifier = token.getLiteral())) {
                Code.Constant code = context.getCodeBuilder().constant((Object)identifier);
                args.add((Code)code);
                context.next_token();
                token = context.look_token();
                if (!token.is(new String[]{this.separator})) break;
                context.next_token();
                token = context.look_token();
            }
            if (args.size() != 0) {
                if (this.id != null) {
                    Code.Callable code = context.getCodeBuilder().function("LIST", (Codes)args);
                    context.setCode(this.id, (Code)code);
                }
                this.parseOnTrueRules(context);
            } else {
                this.parseOnFalseRules(context);
            }
        }

        public String toString() {
            return "optional_identifiers('" + this.id + "', '" + this.separator + "')";
        }
    }

    public static class RuleFail
    implements Statement.Rule {
        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Operation not suppted.");
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            throw new ExpressionSyntaxException();
        }

        public String toString() {
            return "fail()";
        }
    }

    public static class RuleBreakLoop
    implements Statement.Rule {
        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Operation not suppted.");
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            throw new BreakLoopException();
        }

        public String toString() {
            return "break_loop()";
        }
    }

    public static class BreakLoopException
    extends RuntimeException {
    }

    public class RuleRepeat
    implements RepeatRule {
        private final List<Statement.Rule> rules = new ArrayList<Statement.Rule>();
        private int counter;

        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Operation not suppted.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            String saveCodeClassifier = context.getCodeClassifier();
            try {
                this.counter = 1;
                boolean breakloop = false;
                while (!breakloop) {
                    context.setCodeClassifier(String.valueOf(this.counter).trim());
                    context.setOtherValues((Object)this.counter);
                    for (Statement.Rule rule : this.rules) {
                        try {
                            rule.parse(context);
                        }
                        catch (BreakLoopException ex) {
                            breakloop = true;
                            break;
                        }
                    }
                    this.counter = (Integer)context.getOtherValues();
                    ++this.counter;
                }
            }
            finally {
                context.setCodeClassifier(saveCodeClassifier);
            }
        }

        public RuleRepeat addRule(Statement.Rule rule) {
            this.rules.add(rule);
            return this;
        }

        @Override
        public String getClassifier() {
            String s = String.valueOf(this.counter).trim();
            return s;
        }

        public String toString() {
            return "repeat() rules:" + StringUtils.join(this.rules, (String)",");
        }
    }

    public class RuleRepeatUntilAnyTokens
    implements RepeatRule {
        private final String[] exit_tokens;
        private final List<Statement.Rule> rules;
        private int counter;

        public RuleRepeatUntilAnyTokens(String[] exit_tokens) {
            this.exit_tokens = exit_tokens;
            this.rules = new ArrayList<Statement.Rule>();
        }

        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Operation not suppted.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            String save = context.getCodeClassifier();
            try {
                LexicalAnalyzer.Token token;
                this.counter = 1;
                while (!(token = context.look_token()).is(this.exit_tokens)) {
                    context.setCodeClassifier(String.valueOf(this.counter).trim());
                    context.setOtherValues((Object)this.counter);
                    for (Statement.Rule rule : this.rules) {
                        rule.parse(context);
                    }
                    this.counter = (Integer)context.getOtherValues();
                    ++this.counter;
                }
            }
            finally {
                context.setCodeClassifier(save);
            }
        }

        public RuleRepeatUntilAnyTokens addRule(Statement.Rule rule) {
            this.rules.add(rule);
            return this;
        }

        @Override
        public String getClassifier() {
            String s = String.valueOf(this.counter).trim();
            return s;
        }

        public String toString() {
            return "repeat_until_tokens('" + ArrayUtils.toString((Object)this.exit_tokens) + "') rules:" + StringUtils.join(this.rules, (String)",");
        }
    }

    public class RuleSwitchToken
    implements Statement.SwichTokenRule {
        private final List<Pair<String, Statement.Rule[]>> caseRules = new ArrayList<Pair<String, Statement.Rule[]>>();
        private Statement.Rule[] defaultRule;

        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            for (Pair<String, Statement.Rule[]> caseRule : this.caseRules) {
                if (!token.is(new String[]{(String)caseRule.getKey()})) continue;
                context.next_token();
                for (Statement.Rule rule : (Statement.Rule[])caseRule.getValue()) {
                    rule.parse(context);
                }
                return;
            }
            if (this.defaultRule != null) {
                for (Statement.Rule rule : this.defaultRule) {
                    rule.parse(context);
                }
            }
        }

        public Statement.SwichTokenRule addCase(String token, Statement.Rule ... rules) {
            this.caseRules.add((Pair<String, Statement.Rule[]>)new ImmutablePair((Object)token, (Object)rules));
            return this;
        }

        public Statement.SwichTokenRule addDefault(Statement.Rule ... rules) {
            this.defaultRule = rules;
            return this;
        }

        public String toString() {
            return "switch_token() rules:" + StringUtils.join(this.caseRules, (String)",") + " default: " + StringUtils.join((Object[])this.defaultRule, (String)",");
        }
    }

    public class RuleOptionalCompatibilityContains
    implements Statement.ConditionalRule {
        private final List<Statement.Rule> onTrueRules;
        private final List<Statement.Rule> onFalseRules;
        private final String compatid;
        private final String expected;
        private String id;

        public RuleOptionalCompatibilityContains(String compatid, String expected) {
            this.compatid = compatid;
            this.expected = expected;
            this.onTrueRules = new ArrayList<Statement.Rule>();
            this.onFalseRules = new ArrayList<Statement.Rule>();
        }

        public Statement.ConditionalRule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            Compiler compiler = context.getCompiler();
            List<Statement.Rule> theRules = this.onFalseRules;
            String[] values = StringUtils.split((String)compiler.getCompatibility(this.compatid), (char)';');
            if (values != null) {
                for (String value : values) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)this.expected)) continue;
                    if (this.id != null) {
                        Code.Constant code = context.getCodeBuilder().constant((Object)value);
                        context.setCode(this.id, (Code)code);
                    }
                    theRules = this.onTrueRules;
                    break;
                }
            }
            for (Statement.Rule rule : theRules) {
                rule.parse(context);
            }
        }

        public RuleOptionalCompatibilityContains addRuleOnTrue(Statement.Rule rule) {
            this.onTrueRules.add(rule);
            return this;
        }

        public RuleOptionalCompatibilityContains addRuleOnFalse(Statement.Rule rule) {
            this.onFalseRules.add(rule);
            return this;
        }

        public String toString() {
            return "if_compatibility_contains(" + this.compatid + ", " + this.expected + ") onTrue:" + StringUtils.join(this.onTrueRules, (String)",") + ", onFalse:" + StringUtils.join(this.onFalseRules, (String)",");
        }
    }

    public class RuleOptionalAnyToken
    implements Statement.ConditionalRule {
        private final String[] optional_token;
        private final List<Statement.Rule> onTrueRules;
        private final List<Statement.Rule> onFalseRules;
        private String id;

        public RuleOptionalAnyToken(String ... optional_token) {
            this.optional_token = optional_token;
            this.onTrueRules = new ArrayList<Statement.Rule>();
            this.onFalseRules = new ArrayList<Statement.Rule>();
        }

        public Statement.ConditionalRule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            if (token.is(this.optional_token)) {
                if (this.id != null) {
                    Code.Constant code = context.getCodeBuilder().constant(token.getValue());
                    context.setCode(this.id, (Code)code);
                }
                context.next_token();
                for (Statement.Rule rule : this.onTrueRules) {
                    rule.parse(context);
                }
            } else {
                for (Statement.Rule rule : this.onFalseRules) {
                    rule.parse(context);
                }
            }
        }

        public RuleOptionalAnyToken addRuleOnTrue(Statement.Rule rule) {
            this.onTrueRules.add(rule);
            return this;
        }

        public RuleOptionalAnyToken addRuleOnFalse(Statement.Rule rule) {
            this.onFalseRules.add(rule);
            return this;
        }

        public String toString() {
            return "optional_token(" + StringUtils.join((Object[])this.optional_token) + ") onTrue:" + StringUtils.join(this.onTrueRules, (String)",") + ", onFalse:" + StringUtils.join(this.onFalseRules, (String)",");
        }
    }

    public abstract class AbstractConditionalRule
    implements Statement.ConditionalRule {
        protected final List<Statement.Rule> onTrueRules = new ArrayList<Statement.Rule>();
        protected final List<Statement.Rule> onFalseRules = new ArrayList<Statement.Rule>();

        public Statement.ConditionalRule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Operation not suppted.");
        }

        protected void parseOnTrueRules(Statement.StatementContext context) {
            for (Statement.Rule rule : this.onTrueRules) {
                rule.parse(context);
            }
        }

        protected void parseOnFalseRules(Statement.StatementContext context) {
            for (Statement.Rule rule : this.onFalseRules) {
                rule.parse(context);
            }
        }

        public Statement.ConditionalRule addRuleOnTrue(Statement.Rule rule) {
            this.onTrueRules.add(rule);
            return this;
        }

        public Statement.ConditionalRule addRuleOnFalse(Statement.Rule rule) {
            this.onFalseRules.add(rule);
            return this;
        }
    }

    public class RuleRequiereExpressions
    implements Statement.Rule {
        private String id;
        private final String separator;
        private final String[] terminationTokens;

        public RuleRequiereExpressions(String separator, String ... terminationTokens) {
            this.separator = separator;
            this.terminationTokens = terminationTokens;
        }

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            Codes codes = context.parse_expressions(this.separator, this.terminationTokens);
            if (codes == null) {
                throw new ExpressionSyntaxException(context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                Object code = codes.size() == 1 ? (Code)codes.get(0) : context.getCodeBuilder().function("BLOCK", codes);
                context.setCode(this.id, code);
            }
        }

        public String toString() {
            return "require_expressions('" + this.id + "', '" + this.separator + "')";
        }
    }

    public class RuleSetExpression
    implements Statement.Rule {
        private final String id;
        private final Object value;

        public RuleSetExpression(String id, Object value) {
            this.id = id;
            this.value = value;
        }

        public Statement.Rule capture_as(String ... ids) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            if (this.value instanceof Code) {
                context.setCode(this.id, (Code)this.value);
            } else {
                context.setCode(this.id, (Code)context.getCodeBuilder().constant(this.value));
            }
        }

        public String toString() {
            return "set_expression('" + this.id + "', " + Objects.toString(this.value) + ")";
        }
    }

    public class RuleOptionalExpression
    extends AbstractConditionalRule
    implements Statement.ConditionalRule {
        private String id;

        @Override
        public Statement.ConditionalRule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            Code code = context.parse_expression(false);
            if (code == null) {
                context.setCode(this.id, (Code)context.getCodeBuilder().constant(null));
                this.parseOnFalseRules(context);
            } else {
                if (this.id != null) {
                    context.setCode(this.id, code);
                }
                this.parseOnTrueRules(context);
            }
        }

        public String toString() {
            return "optional_expression('" + this.id + "')";
        }
    }

    public class RuleRequireExpression
    implements Statement.Rule {
        private String id;
        boolean allow_assignement;

        public RuleRequireExpression(boolean allow_assignement) {
            this.allow_assignement = allow_assignement;
        }

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            Code code = context.parse_expression(this.allow_assignement);
            if (code == null) {
                throw new ExpressionSyntaxException(context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                context.setCode(this.id, code);
            }
        }

        public String toString() {
            return "require_expression('" + this.id + "')";
        }
    }

    public class RuleRequireLiteralString
    implements Statement.Rule {
        private String id;

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            if (token.getType() != 1) {
                throw new ExpressionSyntaxException(I18N.A_string_literal_was_expected(), context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                String identifier = (String)token.getValue();
                Code.Constant code = context.getCodeBuilder().constant((Object)identifier);
                context.setCode(this.id, (Code)code);
                context.next_token();
            }
        }

        public String toString() {
            return "require_literal_string('" + this.id + "')";
        }
    }

    public class RuleRequireIdentifier
    implements IsApplicableRule {
        private String id;

        public Statement.Rule capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            if (token.getType() != 0) {
                throw new ExpressionSyntaxException(I18N.An_identifier_was_expected_and_XliteralX_was_found(token.getLiteral()), context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                String identifier = token.getLiteral();
                Code.Constant code = context.getCodeBuilder().constant((Object)identifier);
                context.setCode(this.id, (Code)code);
            }
            context.next_token();
        }

        @Override
        public boolean isApplicable(Statement.StatementContext context) {
            LexicalAnalyzer.Token token = context.next_token();
            boolean r = token.getType() == 0;
            context.trace(this.toString() + ".isApplicable return " + r);
            return r;
        }

        public String toString() {
            return "require_identifier('" + this.id + "')";
        }
    }

    public class RuleRequireTokens
    implements Statement.Rule {
        private final String[] required_tokens;
        private String id;

        public RuleRequireTokens(String ... required_token) {
            this.required_tokens = required_token;
        }

        public RuleRequireTokens capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            MutableCodes args = context.getCodeBuilder().args();
            LexicalAnalyzer.Token token = context.look_token();
            for (String required_token : this.required_tokens) {
                String token_literal = token.getLiteral();
                if (!StringUtils.equals((CharSequence)required_token, (CharSequence)token_literal)) {
                    throw new ExpressionSyntaxException(I18N.An_identifier_was_expected_and_XliteralX_was_found(token_literal), context.getLexicalAnalyzer());
                }
                context.next_token();
                token = context.look_token();
            }
            if (this.id != null) {
                Code.Constant code = context.getCodeBuilder().constant((Object)true);
                context.setCode(this.id, (Code)code);
            }
        }

        public String toString() {
            return "require_tokens(" + StringUtils.join((Object[])this.required_tokens) + ")";
        }
    }

    public class RuleRequireAnyToken
    implements IsApplicableRule {
        private final String[] required_token;
        private String id;

        public RuleRequireAnyToken(String ... required_token) {
            this.required_token = required_token;
        }

        public RuleRequireAnyToken capture_as(String ... ids) {
            this.id = ids[0];
            return this;
        }

        public void parse(Statement.StatementContext context) {
            context.trace(this.toString() + ".parse");
            LexicalAnalyzer.Token token = context.look_token();
            if (!token.is(this.required_token)) {
                throw new ExpressionSyntaxException(I18N.A_XTokenX_was_expected_and_XliteralX_was_found(StringUtils.join((Object[])this.required_token, (String)", "), token.getLiteral()), context.getLexicalAnalyzer());
            }
            if (this.id != null) {
                Code.Constant code = context.getCodeBuilder().constant(token.getValue());
                context.setCode(this.id, (Code)code);
            }
            context.next_token();
        }

        @Override
        public boolean isApplicable(Statement.StatementContext context) {
            LexicalAnalyzer.Token token = context.next_token();
            boolean r = token.is(this.required_token);
            context.trace(this.toString() + ".isApplicable return " + r);
            return r;
        }

        public String toString() {
            return "require_token(" + StringUtils.join((Object[])this.required_token) + ")";
        }
    }

    public static interface RepeatRule
    extends Statement.CompoundRule {
        public String getClassifier();
    }

    public static interface IsApplicableRule
    extends Statement.Rule {
        public boolean isApplicable(Statement.StatementContext var1);
    }
}

