/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import java.math.BigDecimal;
import java.util.Objects;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.impl.I18N;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class AddOperator
extends AbstractBinaryOperator
implements Optimizer.FunctionOptimizer {
    public AddOperator() {
        super("Numeric", "+", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        int type = this.getType(op1, op2);
        if ((type & 0x100) == 256) {
            BigDecimal value = this.getBigDecimal(op1, 1).add(this.getBigDecimal(op2, 2));
            return value;
        }
        if ((type & 8) == 8) {
            double value = this.getDouble(op1, 1) + this.getDouble(op2, 2);
            this.checkDoubleValue(value);
            return value;
        }
        if ((type & 4) == 4) {
            double value = this.getFloat(op1, 1) + this.getFloat(op2, 2);
            this.checkDoubleValue(value);
            return value;
        }
        if ((type & 2) == 2) {
            long value = this.getLong(op1, 1) + this.getLong(op2, 2);
            return value;
        }
        if ((type & 1) == 1) {
            int value = this.getInt(op1, 1) + this.getInt(op2, 2);
            return value;
        }
        if ((type & 0x20) == 32) {
            if (interpreter.isSQLCompatible()) {
                throw new ExpressionRuntimeException(null, "The '" + this.name() + "' operator can not be used with string operands", I18N.Use_the_operator_CONCAT_to_concatenate_strings());
            }
            return Objects.toString(op1, "") + Objects.toString(op2, "");
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }

    public Code optimize(Optimizer optimizer, Code.Callable caller) {
        Code op1 = optimizer.optimize((Code)caller.parameters().get(0));
        Code op2 = optimizer.optimize((Code)caller.parameters().get(1));
        if (op1.code() == 0 && op2.code() == 0) {
            Code.Constant newCode = optimizer.getCodeBuilder().constant(this.call(optimizer.getInterpreter(), ((Code.Constant)op1).value(), ((Code.Constant)op2).value()));
            return newCode;
        }
        if (op1.code() == 0) {
            double n;
            Object value = ((Code.Constant)op1).value();
            if (value instanceof Number && (n = ((Number)value).doubleValue()) == 0.0) {
                return op2;
            }
            Code.Callable newCode = optimizer.getCodeBuilder().operator(caller.name(), op1, op2);
            return newCode;
        }
        if (op2.code() == 0) {
            double n;
            Object value = ((Code.Constant)op2).value();
            if (value instanceof Number && (n = ((Number)value).doubleValue()) == 0.0) {
                return op1;
            }
            Code.Callable newCode = optimizer.getCodeBuilder().operator(caller.name(), op1, op2);
            return newCode;
        }
        return caller;
    }
}

