/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import java.math.BigDecimal;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractUnaryOperator;

public class NegOperator
extends AbstractUnaryOperator {
    public NegOperator() {
        super("Numeric", "NEGATE", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object arg) {
        if (arg == null) {
            return null;
        }
        if (!(arg instanceof Number)) {
            throw new IllegalArgumentException("NEGATE function require a number");
        }
        return NegOperator.negate((Number)arg);
    }

    public static Number negate(Number n) {
        if (n instanceof Double) {
            return -((Double)n).doubleValue();
        }
        if (n instanceof Float) {
            return Float.valueOf(-((Float)n).floatValue());
        }
        if (n instanceof Long) {
            return -((Long)n).longValue();
        }
        if (n instanceof Integer) {
            return -((Integer)n).intValue();
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).negate();
        }
        return -n.doubleValue();
    }
}

