/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class LetFunction
extends AbstractFunction {
    public LetFunction() {
        super("Programming", "LET", Range.is((Comparable)Integer.valueOf(2)), "Assigns the value indicated in the second argument to the variable indicated in the first argument.", "SET {{identifier}} = expression", new String[]{"identifier_name - Name of the variable", "value - Value to assign to the variable"}, "Object", false);
        this.addAlias("SET");
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String name = this.getStr(args, 0);
        Object obj = this.getObject(args, 1);
        if (name == null) {
            throw new NullPointerException("A string with a variable name was expected and a null was received");
        }
        SymbolTable symbolTable = interpreter.getSymbolTable();
        if (!(symbolTable instanceof MutableSymbolTable)) {
            throw new RuntimeException("A MutableSymbolTable is required for use let function.");
        }
        ((MutableSymbolTable)symbolTable).setVar(name, obj);
        return obj;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(Objects.toString(((Code.Constant)args.get(0)).value()));
        builder.append("\" := ");
        builder.append(((Code)args.get(1)).toString(formatter));
        return builder.toString();
    }
}

