/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class URLFunction
extends AbstractFunction {
    public URLFunction() {
        super("Programming", "URL", Range.is((Comparable)Integer.valueOf(1)), null, "URL({{expression}})", null, "Object", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        URL value;
        Object obj = this.getObject(args, 0);
        if (obj == null) {
            return null;
        }
        if (obj instanceof URL) {
            return obj;
        }
        if (obj instanceof CharSequence) {
            value = new URL(((CharSequence)obj).toString());
        } else if (obj instanceof File) {
            value = ((File)obj).toURI().toURL();
        } else if (obj instanceof URI) {
            value = ((URI)obj).toURL();
        } else {
            throw new ExpressionRuntimeException("The URL function require a File, URI or a String and a received a '" + obj.getClass().getSimpleName() + "'.");
        }
        return value;
    }
}

