/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.typeconversion;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class EncodeFunction
extends AbstractFunction {
    public EncodeFunction() {
        super("Conversion", "ENCODE", Range.is((Comparable)Integer.valueOf(2)), "Encode binary data into a textual representation.\nSupported formats are: base64, hex.", "ENCODE({{data}}, 'hex')", new String[]{"data - A byte arrary value with the data to be converted", "format - A string value indicating the format of the output data. The default value is 'hex'."}, "String", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        byte[] data_s = (byte[])this.getObject(args, 0);
        String type = this.getStr(args, 1);
        if ("hex".equalsIgnoreCase(type)) {
            String data = Hex.encodeHexString((byte[])data_s);
            return data;
        }
        if ("base64".equalsIgnoreCase(type)) {
            String data = Base64.encodeBase64String((byte[])data_s);
            return data;
        }
        if ("escape".equalsIgnoreCase(type)) {
            // empty if block
        }
        throw new IllegalArgumentException("Unsupported format type '" + type + "'.");
    }
}

