/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.xml;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceRuntimeException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentIdentifier;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.persistence.xml.XMLPersistenceManager;
import org.gvsig.tools.persistence.xml.XMLPersistentConstants;
import org.gvsig.tools.persistence.xml.exception.PersistenceEndOfDocumentException;
import org.gvsig.tools.persistence.xml.exception.PersistenceInvalidValueException;
import org.gvsig.tools.persistence.xml.exception.PersistenceMissingAttributeException;
import org.gvsig.tools.persistence.xml.exception.PersistenceParserException;
import org.gvsig.tools.persistence.xml.exception.PersistenceUnknowTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLPersistentStateReader
implements XMLPersistentConstants {
    private static final Logger logger = LoggerFactory.getLogger(XMLPersistentStateReader.class);
    private XMLPersistenceManager manager;
    private XmlPullParser parser;
    private PersistentContextServices context;

    public XMLPersistentStateReader(XMLPersistenceManager persistenceManager) {
        this.manager = persistenceManager;
    }

    public void read(PersistentContextServices context, XmlPullParser parser) throws PersistenceException {
        this.parser = parser;
        this.context = context;
        try {
            parser.nextTag();
            parser.require(2, null, "XMLPersitence");
            parser.nextTag();
            this.parser.require(2, null, "persistence_xml_version");
            String persistenceVersion = this.parser.nextText();
            if (!persistenceVersion.trim().equals(this.manager.version().trim())) {
                // empty if block
            }
            parser.require(3, "", "persistence_xml_version");
            parser.nextTag();
            parser.require(2, "", "rootState");
            String rootStateIdStr = this.parser.getAttributeValue("", "id_state");
            if (rootStateIdStr == null) {
                throw new PersistenceMissingAttributeException(this.parser, "id_state");
            }
            parser.nextTag();
            this.parser.require(3, "", "rootState");
            parser.nextTag();
            this.parser.require(2, "", "states");
            parser.nextTag();
            while (parser.getEventType() != 3 || !parser.getName().equals("states")) {
                this.checkDocumentEnd();
                parser.require(2, null, null);
                String stateTagName = parser.getName();
                String namespace = parser.getNamespace();
                String curIdstr = parser.getAttributeValue(null, "id");
                if (curIdstr == null) {
                    throw new PersistenceMissingAttributeException(parser, "id");
                }
                PersistentStateServices state = this.manager.createPersistentState(context, this.context.getIdentifier(curIdstr));
                String curClassName = XMLPersistentStateReader.getClassNameFromTag(stateTagName);
                state.setFactory(this.manager.getFactories().get(curClassName));
                state.setTheClassName(curClassName);
                context.add(state, null);
                parser.nextTag();
                try {
                    parser.require(2, null, null);
                }
                catch (XmlPullParserException ex) {
                    logger.warn("Se esperaba un inicio de tag y no se ha encontrado.", (Throwable)ex);
                }
                while (parser.getEventType() != 3 || !parser.getName().equals(stateTagName)) {
                    String curTagName = parser.getName();
                    if ("    <value type=\"{1}\">\n      <name>{0}</name>\n      <data>{2}</data>\n    </value>".equals(parser.getName())) {
                        this.loadGenericTagValue(state);
                    } else {
                        this.loadTagValue(state);
                    }
                    parser.require(3, null, curTagName);
                    parser.nextTag();
                    this.checkDocumentEnd();
                }
                parser.require(3, namespace, stateTagName);
                parser.nextTag();
            }
            context.setRootId(context.getIdentifier(rootStateIdStr));
            parser.nextTag();
            this.parser.require(3, "", "XMLPersitence");
            parser.next();
            this.parser.require(1, null, null);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (PersistenceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceParserException(this.parser, (Throwable)e);
        }
    }

    public static String getClassNameFromTag(String stateTagName) {
        String className = stateTagName;
        int index = className.indexOf(":");
        if (index > -1) {
            className = className.substring(index + 1);
        }
        while ((index = className.indexOf("..")) > 0) {
            className = className.substring(0, index).concat("$").concat(className.substring(index + 2));
        }
        while ((index = className.indexOf("__")) > 0) {
            className = className.substring(0, index).concat(":").concat(className.substring(index + 2));
        }
        return className;
    }

    private void loadTagValue(PersistentStateServices state) throws XmlPullParserException, IOException, PersistenceException {
        String type = this.parser.getAttributeValue(null, "type");
        if (type == null) {
            throw new PersistenceMissingAttributeException(this.parser, "type");
        }
        String name = this.parser.getName();
        state.setValue(name, this.getValue(type));
    }

    private void loadGenericTagValue(PersistentStateServices state) throws XmlPullParserException, IOException, PersistenceException {
        String type = this.parser.getAttributeValue(null, "type");
        if (type == null) {
            throw new PersistenceMissingAttributeException(this.parser, "type");
        }
        this.parser.nextTag();
        this.parser.require(2, "", "name");
        String name = this.parser.nextText();
        this.parser.require(3, "", "name");
        this.parser.nextTag();
        this.parser.require(2, "", "data");
        state.setValue(name, this.getValue(type));
        this.parser.require(3, "", "data");
        this.parser.nextTag();
    }

    private Object getValue(String type) throws XmlPullParserException, IOException, PersistenceException {
        if (type.equals("null")) {
            this.parser.nextTag();
            return null;
        }
        if (type.equals("string")) {
            return this.parser.nextText();
        }
        if (type.equals("boolean")) {
            return this.getValueBoolean();
        }
        if (type.equals("date")) {
            return this.getValueDate();
        }
        if (type.equals("file")) {
            return this.getValueFile();
        }
        if (type.equals("url")) {
            return this.getValueURL();
        }
        if (type.equals("uri")) {
            return this.getValueURI();
        }
        if (TYPES_NUMBER.contains(type)) {
            return this.getValueNumber(type);
        }
        if (type.equals("reference")) {
            return this.getValueReference();
        }
        if (type.equals("list")) {
            return this.getValueList();
        }
        if (type.equals("set")) {
            return this.getValueSet();
        }
        if (type.equals("map")) {
            return this.getValueMap();
        }
        throw new PersistenceUnknowTypeException(this.parser, type);
    }

    private Boolean getValueBoolean() throws XmlPullParserException, IOException {
        String value = this.parser.nextText();
        return Boolean.parseBoolean(value);
    }

    private File getValueFile() throws XmlPullParserException, IOException {
        String value = this.parser.nextText();
        return new File(value);
    }

    private URL getValueURL() throws XmlPullParserException, IOException {
        String value = this.parser.nextText();
        return new URL(value);
    }

    private URI getValueURI() throws XmlPullParserException, IOException, PersistenceException {
        String value = this.parser.nextText();
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new PersistenceParserException(this.parser, (Throwable)e);
        }
    }

    private Date getValueDate() throws XmlPullParserException, IOException {
        String value = this.parser.nextText();
        try {
            long time = Long.parseLong(value);
            return new Date(time);
        }
        catch (NumberFormatException e) {
            throw new PersistenceInvalidValueException(this.parser, "date", value, e);
        }
    }

    private Number getValueNumber(String type) throws XmlPullParserException, IOException {
        String value = this.parser.nextText().trim();
        Number number = null;
        try {
            if ("byte".equals(type)) {
                number = value.startsWith("0x") ? Integer.valueOf(Byte.parseByte(value.substring(2), 16)) : Integer.valueOf(Byte.parseByte(value));
            } else if ("integer".equals(type)) {
                number = value.startsWith("0x") ? Integer.valueOf(Integer.parseInt(value.substring(2), 16)) : Integer.valueOf(Integer.parseInt(value));
            } else if ("long".equals(type)) {
                number = value.startsWith("0x") ? Long.valueOf(Long.parseLong(value.substring(2), 16)) : Long.valueOf(Long.parseLong(value));
            } else if ("float".equals(type)) {
                number = value.startsWith("0x") ? Float.valueOf(Integer.parseInt(value.substring(2), 16)) : Float.valueOf(Float.parseFloat(value));
            } else if ("double".equals(type)) {
                number = value.startsWith("0x") ? Double.valueOf(Integer.parseInt(value.substring(2), 16)) : Double.valueOf(Double.parseDouble(value));
            } else if ("bigdecimal".equals(type)) {
                number = value.startsWith("0x") ? new BigDecimal(Integer.parseInt(value.substring(2), 16)) : new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            throw new PersistenceInvalidValueException(this.parser, type, value, e);
        }
        return number;
    }

    private PersistentContextServices.ObjectReference getValueReference() throws XmlPullParserException, IOException, PersistenceException {
        this.parser.nextTag();
        this.parser.require(2, "", "reference");
        String idstr = this.parser.getAttributeValue("", "id_state");
        if (idstr == null) {
            throw new PersistenceMissingAttributeException(this.parser, "id_state");
        }
        PersistentIdentifier id = this.context.getIdentifier(idstr);
        this.parser.nextTag();
        this.parser.require(3, "", "reference");
        this.parser.nextTag();
        return this.context.add(id);
    }

    private List getValueList() throws XmlPullParserException, IOException, PersistenceException {
        this.parser.nextTag();
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.parser.getEventType() == 2 && "item".equals(this.parser.getName())) {
            String type = this.parser.getAttributeValue("", "type");
            if (type == null) {
                throw new PersistenceMissingAttributeException(this.parser, "type");
            }
            list.add(this.getValue(type));
            this.parser.require(3, "", "item");
            this.parser.nextTag();
        }
        return this.manager.getWrappedList(list, this.context);
    }

    private Set getValueSet() throws XmlPullParserException, IOException, PersistenceException {
        this.parser.nextTag();
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        while (this.parser.getEventType() == 2 && "item".equals(this.parser.getName())) {
            String type = this.parser.getAttributeValue("", "type");
            if (type == null) {
                throw new PersistenceMissingAttributeException(this.parser, "type");
            }
            set.add(this.getValue(type));
            this.parser.require(3, "", "item");
            this.parser.nextTag();
        }
        return this.manager.getWrappedSet(set, this.context);
    }

    private void checkDocumentEnd() throws XmlPullParserException {
        if (this.parser.getEventType() == 1) {
            throw new PersistenceEndOfDocumentException(this.parser);
        }
    }

    private Map getValueMap() throws XmlPullParserException, IOException, PersistenceException {
        this.parser.nextTag();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        while (this.parser.getEventType() == 2 && "mapitem".equals(this.parser.getName())) {
            this.parser.nextTag();
            this.parser.require(2, "", "key");
            String keyType = this.parser.getAttributeValue("", "type");
            if (keyType == null) {
                throw new PersistenceMissingAttributeException(this.parser, "type");
            }
            Object key = this.getValue(keyType);
            this.parser.require(3, "", "key");
            this.parser.nextTag();
            this.parser.require(2, "", "value");
            String valueType = this.parser.getAttributeValue("", "type");
            if (valueType == null) {
                throw new PersistenceMissingAttributeException(this.parser, "type");
            }
            Object value = this.getValue(valueType);
            this.parser.require(3, "", "value");
            this.parser.nextTag();
            map.put(key, value);
            this.parser.require(3, "", "mapitem");
            this.parser.nextTag();
        }
        return this.manager.getWrappedMap(map, this.context);
    }
}

