/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.swing.impl.Utils;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropDownLabel
implements DropDown {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DropDownLabel.class);
    private final JComponent component;
    private final Set<ItemListener> itemListeners;
    private ComboBoxModel model;
    protected int selectedIndex;
    private JPopupMenu popup;
    private List<ImageIcon> icons;
    private boolean readonly = false;
    private final JLabel arrow;
    private Color disabledForeground = null;
    private Color enabledForeground = null;
    private final Color backgroundColor;
    private final Color warningBackgroundColor;
    private final ActionListenerSupport dropdownListsnersHelper;
    private Object lastAssignedValue;

    public DropDownLabel(JComponent component, Color warningBackgroundColor) {
        this.component = component;
        this.itemListeners = new HashSet<ItemListener>();
        this.dropdownListsnersHelper = new DefaultActionListenerSupport();
        this.component.setCursor(Cursor.getPredefinedCursor(12));
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DropDownLabel.this.doShowPopup();
            }
        });
        this.icons = null;
        this.backgroundColor = this.component.getBackground();
        this.warningBackgroundColor = warningBackgroundColor;
        this.arrow = new JLabel("\u23f7");
        this.arrow.setFocusable(false);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.arrow, "North");
        panel.setFocusable(false);
        this.component.setLayout(new BorderLayout(2, 0));
        this.component.add((Component)panel, "East");
        this.arrow.setVisible(false);
        this.arrow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DropDownLabel.this.doShowPopup();
            }
        });
        this.component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    DropDownLabel.this.doShowPopup();
                } else if (e.getKeyCode() == 40 && e.getModifiers() == 8) {
                    DropDownLabel.this.doShowPopup();
                }
                switch (e.getKeyCode()) {
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        e.consume();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JPopupMenu contextMenu = this.component.getComponentPopupMenu();
        try {
            block11: for (int i = 0; i < contextMenu.getComponentCount(); ++i) {
                Component comp = contextMenu.getComponent(i);
                if (!(comp instanceof JMenuItem)) continue;
                Action action = ((JMenuItem)comp).getAction();
                switch ((String)action.getValue("Name")) {
                    case "cut-to-clipboard": 
                    case "paste-from-clipboard": {
                        comp.setEnabled(false);
                        continue block11;
                    }
                    case "text-editor": {
                        action.putValue("EDITABLE", false);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.component.setComponentPopupMenu(null);
        }
    }

    public JComponent asJComponent() {
        return this.component;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
        this.component.setForeground(this.getForegoundColor());
    }

    private Color getForegoundColor() {
        if (this.disabledForeground == null) {
            this.disabledForeground = UIManager.getColor("Label.disabledForeground");
            this.enabledForeground = UIManager.getColor("Label.foreground");
            if (this.component instanceof AbstractButton) {
                this.disabledForeground = UIManager.getColor("Button.disabledText");
                this.enabledForeground = UIManager.getColor("Button.foreground");
            }
        }
        if (this.readonly) {
            return this.disabledForeground;
        }
        return this.enabledForeground;
    }

    private Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setVisibleDropdownArrow(boolean visible) {
        this.arrow.setVisible(visible);
    }

    public boolean isVisibleDropdownArrow() {
        return this.arrow.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
        this.arrow.setEnabled(enabled);
    }

    private void doShowPopup() {
        Utils.fireFocusEvent(this.component, 1004);
        ActionEvent ev = new ActionEvent(this, 0, null);
        this.dropdownListsnersHelper.fireActionEvent(ev);
        if (this.model == null) {
            return;
        }
        this.popup = new JPopupMenu();
        for (int i = 0; i < this.model.getSize(); ++i) {
            this.popup.add(this.createItem(i));
        }
        Dimension compsize = this.component.getSize();
        Dimension popupsize = this.popup.getPreferredSize();
        if (popupsize.width < compsize.width) {
            popupsize.width = compsize.width;
            this.popup.setPreferredSize(popupsize);
        }
        Point p = this.component.getLocationOnScreen();
        this.popup.show(this.component, 0, this.component.getHeight());
    }

    public void setIcons(List<ImageIcon> icons) {
        this.icons = icons;
    }

    public List<ImageIcon> getIcons() {
        return this.icons;
    }

    private ImageIcon getIcon(int index) {
        if (this.icons == null || index < 0 || index > this.icons.size()) {
            return null;
        }
        return this.icons.get(index);
    }

    private JMenuItem createItem(final int index) {
        JMenuItem item = new JMenuItem(Objects.toString(this.model.getElementAt(index), ""));
        item.setEnabled(!this.readonly);
        item.setIcon(this.getIcon(index));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DropDownLabel.this.readonly) {
                    return;
                }
                DropDownLabel.this.setSelectedIndex(index);
                ItemEvent ie = new ItemEvent((ItemSelectable)((Object)DropDownLabel.this), 1, index, 1);
                for (ItemListener itemListener : DropDownLabel.this.itemListeners) {
                    if (itemListener == null) continue;
                    itemListener.itemStateChanged(ie);
                }
            }
        });
        return item;
    }

    public void setModel(ComboBoxModel model) {
        this.model = model;
        if (this.lastAssignedValue != null) {
            this.setValue(this.lastAssignedValue);
            this.lastAssignedValue = null;
        }
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public void setSelectedIndex(int i) {
        if (this.model == null) {
            return;
        }
        String value = null;
        if (i < 0) {
            this.component.setToolTipText(null);
        } else {
            value = Objects.toString(this.model.getElementAt(i), "");
            this.component.setToolTipText(value);
        }
        this.selectedIndex = i;
        this.setText(value);
    }

    public void setValue(Object value) {
        ComboBoxModel theModel = this.getModel();
        if (theModel != null) {
            Object v = value instanceof LabeledValue ? ((LabeledValue)value).getValue() : value;
            for (int i = 0; i < theModel.getSize(); ++i) {
                Object item = theModel.getElementAt(i);
                if (Objects.equals(item, value)) {
                    this.setSelectedIndex(i);
                    this.lastAssignedValue = value;
                    return;
                }
                if (!(item instanceof LabeledValue) || !Objects.equals(item = ((LabeledValue)item).getValue(), v)) continue;
                this.setSelectedIndex(i);
                this.lastAssignedValue = value;
                return;
            }
        }
        this.selectedIndex = -1;
        this.lastAssignedValue = null;
        this.setText("", this.getBackgroundColor());
    }

    protected void setText(String s) {
        this.setText(s, this.getBackgroundColor());
    }

    protected void setText(String s, Color backgroundColor) {
        if (this.component instanceof JLabel) {
            if (StringUtils.isBlank((CharSequence)s)) {
                s = "\u00a0";
            }
            ((JLabel)this.component).setText(s);
        } else if (this.component instanceof AbstractButton) {
            ((AbstractButton)this.component).setText(s);
        } else {
            try {
                Class<?> theClass = this.component.getClass();
                Method method = theClass.getMethod("setText", String.class);
                method.invoke((Object)this.component, s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.component.setBackground(backgroundColor);
    }

    private String getText() {
        if (this.component instanceof JLabel) {
            String text = ((JLabel)this.component).getText();
            if (text.equals("\u00a0")) {
                return "";
            }
            return text;
        }
        if (this.component instanceof AbstractButton) {
            return ((AbstractButton)this.component).getText();
        }
        try {
            Class<?> theClass = this.component.getClass();
            Method method = theClass.getMethod("getText", new Class[0]);
            return (String)method.invoke((Object)this.component, new Object[0]);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public Object getSelectedItem() {
        if (this.model == null) {
            return null;
        }
        if (this.selectedIndex < 0) {
            String text = this.getText();
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
            return null;
        }
        return this.model.getElementAt(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object[] getSelectedObjects() {
        if (this.model == null) {
            return null;
        }
        return new Object[]{this.getSelectedItem()};
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.add(itemListener);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    public void addDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.addActionListener(listener);
    }

    public void removeDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.removeActionListener(listener);
    }
}

