/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellHandler {
    protected mxGraphComponent graphComponent;
    protected mxCellState state;
    protected Rectangle[] handles;
    protected boolean handlesVisible = true;
    protected transient Rectangle bounds;
    protected transient JComponent preview;
    protected transient Point first;
    protected transient int index;

    public mxCellHandler(mxGraphComponent graphComponent, mxCellState state) {
        this.graphComponent = graphComponent;
        this.refresh(state);
    }

    public boolean isActive() {
        return this.first != null;
    }

    public void refresh(mxCellState state) {
        this.state = state;
        this.handles = this.createHandles();
        mxGraph graph = this.graphComponent.getGraph();
        mxRectangle tmp = graph.getBoundingBox(state.getCell());
        if (tmp != null) {
            this.bounds = tmp.getRectangle();
            if (this.handles != null) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (!this.isHandleVisible(i)) continue;
                    this.bounds.add(this.handles[i]);
                }
            }
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public mxCellState getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isLabelMovable() {
        mxGraph graph = this.graphComponent.getGraph();
        String label = graph.getLabel(this.state.getCell());
        return graph.isLabelMovable(this.state.getCell()) && label != null && label.length() > 0;
    }

    public boolean isHandlesVisible() {
        return this.handlesVisible;
    }

    public void setHandlesVisible(boolean handlesVisible) {
        this.handlesVisible = handlesVisible;
    }

    public boolean isLabel(int index) {
        return index == this.getHandleCount() - 1;
    }

    protected Rectangle[] createHandles() {
        return null;
    }

    protected int getHandleCount() {
        return this.handles != null ? this.handles.length : 0;
    }

    public String getToolTipText(MouseEvent e) {
        return null;
    }

    public int getIndexAt(int x, int y) {
        if (this.handles != null && this.isHandlesVisible()) {
            int tol = this.graphComponent.getTolerance();
            Rectangle rect = new Rectangle(x - tol / 2, y - tol / 2, tol, tol);
            for (int i = this.handles.length - 1; i >= 0; --i) {
                if (!this.isHandleVisible(i) || !this.handles[i].intersects(rect)) continue;
                return i;
            }
        }
        return -1;
    }

    public void mousePressed(MouseEvent e) {
        if (!e.isConsumed()) {
            int tmp = this.getIndexAt(e.getX(), e.getY());
            if (!this.isIgnoredEvent(e) && tmp >= 0 && this.isHandleEnabled(tmp)) {
                this.graphComponent.stopEditing(true);
                this.start(e, tmp);
                e.consume();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        int index;
        if (!e.isConsumed() && this.handles != null && (index = this.getIndexAt(e.getX(), e.getY())) >= 0 && this.isHandleEnabled(index)) {
            Cursor cursor = this.getCursor(e, index);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                e.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(new Cursor(12));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.reset();
    }

    public void start(MouseEvent e, int index) {
        this.index = index;
        this.first = e.getPoint();
        this.preview = this.createPreview();
        if (this.preview != null) {
            this.graphComponent.getGraphControl().add((Component)this.preview, 0);
        }
    }

    protected boolean isIgnoredEvent(MouseEvent e) {
        return this.graphComponent.isEditEvent(e);
    }

    protected JComponent createPreview() {
        return null;
    }

    public void reset() {
        if (this.preview != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
            this.preview = null;
        }
        this.first = null;
    }

    protected Cursor getCursor(MouseEvent e, int index) {
        return null;
    }

    public void paint(Graphics g) {
        if (this.handles != null && this.isHandlesVisible()) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!this.isHandleVisible(i) || !g.hitClip(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height)) continue;
                g.setColor(this.getHandleFillColor(i));
                g.fillRect(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height);
                g.setColor(this.getHandleBorderColor(i));
                g.drawRect(this.handles[i].x, this.handles[i].y, this.handles[i].width - 1, this.handles[i].height - 1);
            }
        }
    }

    public Color getSelectionColor() {
        return null;
    }

    public Stroke getSelectionStroke() {
        return null;
    }

    protected boolean isHandleEnabled(int index) {
        return true;
    }

    protected boolean isHandleVisible(int index) {
        return !this.isLabel(index) || this.isLabelMovable();
    }

    protected Color getHandleFillColor(int index) {
        if (this.isLabel(index)) {
            return mxSwingConstants.LABEL_HANDLE_FILLCOLOR;
        }
        return mxSwingConstants.HANDLE_FILLCOLOR;
    }

    protected Color getHandleBorderColor(int index) {
        return mxSwingConstants.HANDLE_BORDERCOLOR;
    }

    protected void destroy() {
    }
}

