/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.georeferencing.swing.GeoreferencingLauncher;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLocator;
import org.gvsig.raster.georeferencing.swing.impl.launcher.GeorefLauncherPanel;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;

public class GeorefLauncherDialog
extends JPanel
implements GeoreferencingLauncher {
    private static final long serialVersionUID = 7362459094802955247L;
    private GeorefLauncherPanel geoLauncherPanel = null;
    private List<String> viewNameList = null;
    private int polynomialDegree = 0;

    public GeorefLauncherDialog(List<String> viewList, int polynomialDegree) {
        this.viewNameList = viewList;
        this.polynomialDegree = polynomialDegree;
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        GeoreferencingOptionsDataModel dataModel = GeoreferencingSwingLocator.getSwingManager().getDataModel();
        dataModel.reset();
        this.add((Component)((Object)this.getGeorefLauncherPanel()), "Center");
    }

    public void setButtonsListener(ButtonsPanelListener listener) {
        this.getGeorefLauncherPanel().setButtonsListener(listener);
    }

    public GeorefLauncherPanel getGeorefLauncherPanel() {
        if (this.geoLauncherPanel == null) {
            this.geoLauncherPanel = new GeorefLauncherPanel(this.viewNameList, this.polynomialDegree);
        }
        return this.geoLauncherPanel;
    }

    public JPanel getComponent() {
        return this;
    }

    public RasterDataStore getDataStore() {
        return this.geoLauncherPanel.getFileSelectionPanel().getSelectedStore();
    }

    public String getSelectedView() {
        return this.geoLauncherPanel.getTypeSelectionPanel().getSelectedView();
    }

    public int getType() {
        return this.geoLauncherPanel.getTypeSelectionPanel().getType();
    }

    public int getAlgorithm() {
        return this.geoLauncherPanel.getAlgorithmSelectionPanel().getAlgorithm();
    }

    public String getOutFile() {
        return this.geoLauncherPanel.getOutFileSelectionPanel().getOutFile();
    }

    public int getInterpolationMethod() {
        return this.geoLauncherPanel.getAlgorithmSelectionPanel().getSelectedInterpolationMethod();
    }

    public int getDegree() {
        String degree = (String)this.geoLauncherPanel.getAlgorithmSelectionPanel().getDegreeList().getSelectedItem();
        String[] l = degree.split(" ");
        degree = l[l.length - 1];
        try {
            return Integer.valueOf(degree);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void buildDataModel() {
        GeoreferencingOptionsDataModel dataModel = GeoreferencingSwingLocator.getSwingManager().getDataModel();
        dataModel.setAlgorithm(this.getAlgorithm());
        dataModel.setDegree(this.getDegree());
        dataModel.setInterpolationMethod(this.getInterpolationMethod());
        dataModel.setOutFile(this.getOutFile());
        dataModel.setType(this.getType());
        dataModel.setDataStore(this.getDataStore());
        dataModel.setSelectedView(this.getSelectedView());
    }
}

