/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;

public class CellSizeOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CellSizeContainer xCellSize = null;
    private CellSizeContainer yCellSize = null;

    public CellSizeOptionsPanel() {
        this.init();
    }

    public void init() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"cellsize"), 0, 0, null, null));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 5, 0);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.getXCellSizeTextField(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getYCellSizeTextField(), gbc);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.getXCellSizeTextField().setEnabled(enable);
        this.getYCellSizeTextField().setEnabled(enable);
    }

    public CellSizeContainer getXCellSizeTextField() {
        if (this.xCellSize == null) {
            this.xCellSize = new CellSizeContainer("X: ");
        }
        return this.xCellSize;
    }

    public CellSizeContainer getYCellSizeTextField() {
        if (this.yCellSize == null) {
            this.yCellSize = new CellSizeContainer("Y: ");
        }
        return this.yCellSize;
    }

    public double getXCellSizeValue() {
        try {
            return Double.valueOf(this.xCellSize.getValue());
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
    }

    public double getYCellSizeValue() {
        try {
            return Double.valueOf(this.yCellSize.getValue());
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
    }

    public void setXCellSize(double dataCellSize) {
        if (this.xCellSize != null) {
            this.xCellSize.setValue(dataCellSize + "");
        }
    }

    public void setYCellSize(double dataCellSize) {
        if (this.yCellSize != null) {
            this.yCellSize.setValue(dataCellSize + "");
        }
    }

    public class CellSizeContainer
    extends JPanel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private JFormattedTextField box = new JFormattedTextField(new DecimalFormat("########.########"));
        private PropertyChangeListener listener = null;

        public CellSizeContainer(String txt) {
            this.box.setValue(0.0);
            this.box.addPropertyChangeListener("value", this);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)new JLabel(txt), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.box, gridBagConstraints);
        }

        public String getValue() {
            double n = ((Number)this.box.getValue()).doubleValue();
            return Double.toString(n);
        }

        public void setValue(String value) {
            this.box.setValue(new Double(value));
        }

        public void setListener(PropertyChangeListener listener) {
            this.listener = listener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.listener.propertyChange(evt);
        }

        @Override
        public void setEnabled(boolean enable) {
            this.box.setEnabled(enable);
        }
    }
}

