/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.swing.impl.option.ColorSelector;

public class CheckOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DataInputContainer threshold = null;
    private JCheckBox showNumber = null;
    private JCheckBox addErrorInCSV = null;
    private JCheckBox centerPoint = null;
    private ColorSelector backgroundColorSel = null;
    private ColorSelector textColorSel = null;

    public CheckOptionsPanel() {
        this.init();
    }

    public void init() {
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"options"), 0, 0, null, null));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.getBackGroundColorSelector(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getTextSelector(), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridy = 2;
        this.add((Component)this.getShowNumberCheck(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getAddErrorsCSVCheck(), gbc);
        gbc.gridy = 4;
        this.add((Component)this.getCenterViewCheck(), gbc);
        gbc.gridy = 5;
        this.add((Component)this.getThresholdError(), gbc);
    }

    public DataInputContainer getThresholdError() {
        if (this.threshold == null) {
            this.threshold = new DataInputContainer();
            this.threshold.setLabelText(Messages.getText((String)"umbral_error"));
        }
        return this.threshold;
    }

    public ColorSelector getBackGroundColorSelector() {
        if (this.backgroundColorSel == null) {
            this.backgroundColorSel = new ColorSelector(Color.BLACK, Messages.getText((String)"background_color"));
        }
        return this.backgroundColorSel;
    }

    public ColorSelector getTextSelector() {
        if (this.textColorSel == null) {
            this.textColorSel = new ColorSelector(Color.RED, Messages.getText((String)"text_color"));
        }
        return this.textColorSel;
    }

    public JCheckBox getShowNumberCheck() {
        if (this.showNumber == null) {
            this.showNumber = new JCheckBox(Messages.getText((String)"show_number"));
        }
        return this.showNumber;
    }

    public JCheckBox getAddErrorsCSVCheck() {
        if (this.addErrorInCSV == null) {
            this.addErrorInCSV = new JCheckBox(Messages.getText((String)"add_errors_csv"));
        }
        return this.addErrorInCSV;
    }

    public JCheckBox getCenterViewCheck() {
        if (this.centerPoint == null) {
            this.centerPoint = new JCheckBox(Messages.getText((String)"center_view"));
        }
        return this.centerPoint;
    }
}

