/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.model.GCPEvent;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.model.GCPListener;

public class GCPListImpl
implements GCPList {
    private List<GPGraphic> pList = new ArrayList<GPGraphic>();
    private List<GCPListener> listeners = new ArrayList<GCPListener>();
    private int selectedPoint = -1;

    public void addListener(GCPListener listener) {
        this.listeners.add(listener);
    }

    public void buildNewList(GeoPointList geoPointList) {
        long id = System.currentTimeMillis();
        if (geoPointList != null) {
            this.pList.clear();
            for (int i = 0; i < geoPointList.size(); ++i) {
                GPGraphic graphicGCP = new GPGraphic((GeoPoint)geoPointList.get(i));
                graphicGCP.setId(id);
                graphicGCP.setNumber(i);
                this.pList.add(graphicGCP);
                ++id;
            }
        }
    }

    public void setPositionFromID(long id, int newPosition) {
        if (newPosition < this.size()) {
            for (int j = 0; j < this.size(); ++j) {
                GPGraphic gpg = this.pList.get(j);
                if (id != gpg.getId()) continue;
                gpg.setNumber(j);
                break;
            }
        }
    }

    public GeoPoint getGeoPoint(int i) {
        for (int j = 0; j < this.pList.size(); ++j) {
            GPGraphic graphicPoint = this.pList.get(j);
            if (graphicPoint.getGeoPoint().getNumber() != i) continue;
            return graphicPoint.getGeoPoint();
        }
        return null;
    }

    public GeoPointList getGeoPointList() {
        GeoPointListImpl geoPointList = new GeoPointListImpl();
        for (int i = 0; i < this.pList.size(); ++i) {
            geoPointList.add(this.pList.get(i).getGeoPoint());
        }
        return geoPointList;
    }

    public Object getGraphicPoint(int i) {
        for (int j = 0; j < this.pList.size(); ++j) {
            GPGraphic graphicPoint = this.pList.get(j);
            if (graphicPoint.getGeoPoint().getNumber() != i) continue;
            return graphicPoint;
        }
        return null;
    }

    public int size() {
        return this.pList.size();
    }

    public void add(Object graphicPoint) {
        this.pList.add((GPGraphic)graphicPoint);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addPoint(new GCPEvent(this.pList, this.pList.size() - 1));
        }
    }

    public void remove(int pos) {
        int position\u00cdnArray = -1;
        for (int j = 0; j < this.pList.size(); ++j) {
            GPGraphic graphicPoint = this.pList.get(j);
            if (graphicPoint.getGeoPoint().getNumber() != pos) continue;
            position\u00cdnArray = j;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).removePoint(new GCPEvent(this.pList, position\u00cdnArray));
        }
        this.pList.remove(position\u00cdnArray);
    }

    public void removeAll() {
        int i;
        for (i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).removePoint(new GCPEvent(this.pList, -1));
        }
        for (i = this.pList.size() - 1; i >= 0; --i) {
            this.pList.remove(i);
        }
    }

    public void setSelectedPoint(int number) {
        this.selectedPoint = number;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).selectPoint(new GCPEvent(this.pList, number));
        }
    }

    public int getSelectedPoint() {
        return this.selectedPoint;
    }

    class GeoPointListImpl
    extends ArrayList<GeoPoint>
    implements GeoPointList {
        private static final long serialVersionUID = 1L;

        GeoPointListImpl() {
        }

        public GeoPointList clone() {
            GeoPointListImpl clonedPointList = new GeoPointListImpl();
            for (int i = 0; i < this.size(); ++i) {
                clonedPointList.add(((GeoPoint)this.get(i)).cloneGeoPoint());
            }
            return clonedPointList;
        }
    }
}

