/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.raster.georeferencing.swing.GeoreferencingOptions;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLocator;
import org.gvsig.raster.georeferencing.swing.impl.option.GeorefOptionsPanel;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;

public class GeorefOptionsDialog
extends JPanel
implements GeoreferencingOptions {
    private static final long serialVersionUID = 7362459094802955247L;
    private GeorefOptionsPanel geoOptionsPanel = null;
    private GeoreferencingOptionsDataModel dataModel = null;
    private int polynomialDegree = 0;

    public GeorefOptionsDialog(int polynomialDegree, ButtonsPanelListener listener) {
        this.polynomialDegree = polynomialDegree;
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this.add((Component)((Object)this.getOptionsPanel(listener)), "Center");
    }

    public GeorefOptionsPanel getOptionsPanel(ButtonsPanelListener listener) {
        if (this.geoOptionsPanel == null) {
            this.geoOptionsPanel = new GeorefOptionsPanel(this.polynomialDegree, listener);
        }
        return this.geoOptionsPanel;
    }

    public int getAlgorithm() {
        return this.geoOptionsPanel.getAlgorithmSelectionPanel().getAlgorithm();
    }

    public int getDegree() {
        return this.geoOptionsPanel.getAlgorithmSelectionPanel().getSelectedDegree();
    }

    public int getInterpolationMethod() {
        return this.geoOptionsPanel.getAlgorithmSelectionPanel().getSelectedInterpolationMethod();
    }

    public void setInterpolationMethod(int interpolationMethod) {
        this.geoOptionsPanel.getAlgorithmSelectionPanel().setInterpolationMethod(interpolationMethod);
    }

    public void setOutFile(String out) {
        this.geoOptionsPanel.getOutFileSelectionPanel().setOutFile(out);
    }

    public void setDegree(int optiondegree) {
        this.geoOptionsPanel.getAlgorithmSelectionPanel().setDegree(optiondegree);
    }

    public void setAlgorithm(int alg) {
        this.geoOptionsPanel.getAlgorithmSelectionPanel().setAlgorithm(alg);
    }

    public void setBackGroundColor(Color c) {
        this.geoOptionsPanel.getCheckOptionsPanel().getBackGroundColorSelector().setColor(c);
    }

    public Color getBackGroundColor() {
        return this.geoOptionsPanel.getCheckOptionsPanel().getBackGroundColorSelector().getColor();
    }

    public void setTextColor(Color c) {
        this.geoOptionsPanel.getCheckOptionsPanel().getTextSelector().setColor(c);
    }

    public Color getTextColor() {
        return this.geoOptionsPanel.getCheckOptionsPanel().getTextSelector().getColor();
    }

    public double getThresholdError() {
        String value = this.geoOptionsPanel.getCheckOptionsPanel().getThresholdError().getValue();
        try {
            Double result = new Double(value);
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public void setThresholdError(double threshold) {
        this.geoOptionsPanel.getCheckOptionsPanel().getThresholdError().setValue(new Double(threshold).toString());
    }

    public GeoreferencingOptionsDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = GeoreferencingSwingLocator.getSwingManager().getDataModel();
        }
        return this.dataModel;
    }

    public JPanel getComponent() {
        return this;
    }
}

