/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRConverter {
    private final String DEFAULT_GEOMETRY_COLUMN_NAME = "ogr_geometry";
    private static final Logger LOG = LoggerFactory.getLogger(OGRConverter.class);

    public FeatureType convert(FeatureDefn featureDefn, String defaultGeometryField) throws GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        EditableFeatureType editableFeatureType = DALLocator.getDataManager().createFeatureType();
        return this.convert(editableFeatureType, featureDefn, defaultGeometryField);
    }

    public FeatureType convert(EditableFeatureType editableFeatureType, FeatureDefn featureDefn, String defaultGeometryField) throws GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        int i;
        editableFeatureType.setHasOID(true);
        for (i = 0; i < featureDefn.GetFieldCount(); ++i) {
            FieldDefn fieldDefn = featureDefn.GetFieldDefn(i);
            EditableFeatureAttributeDescriptor attributeDescriptor = editableFeatureType.add(fieldDefn.GetName(), this.convertToDataType(fieldDefn.GetFieldType()));
            attributeDescriptor.setPrecision(fieldDefn.GetPrecision());
        }
        for (i = 0; i < featureDefn.GetGeomFieldCount(); ++i) {
            GeomFieldDefn geomFieldDefn = featureDefn.GetGeomFieldDefn(i);
            String name = StringUtils.isBlank((CharSequence)geomFieldDefn.GetName()) ? "ogr_geometry" : geomFieldDefn.GetName();
            EditableFeatureAttributeDescriptor attributeDescriptor = editableFeatureType.add(name, 66);
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            GeometryType geometryType = geometryManager.getGeometryType(this.convertToGeomType(geomFieldDefn.GetFieldType()), 0);
            attributeDescriptor.setGeometryType(geometryType);
            if (geomFieldDefn.GetSpatialRef() == null) continue;
            IProjection projection = CRSFactory.getCRSFactory().get("wkt", geomFieldDefn.GetSpatialRef().ExportToWkt());
            attributeDescriptor.setSRS(projection);
        }
        if (editableFeatureType.getAttributeDescriptor(defaultGeometryField) != null) {
            editableFeatureType.setDefaultGeometryAttributeName(defaultGeometryField);
        } else {
            FeatureAttributeDescriptor[] attributeDescriptors;
            for (FeatureAttributeDescriptor attributeDescriptor : attributeDescriptors = editableFeatureType.getAttributeDescriptors()) {
                if (attributeDescriptor.getDataType().getType() != 66 || attributeDescriptor.getGeomType().getType() != this.convertToGeomType(featureDefn.GetGeomType())) continue;
                editableFeatureType.setDefaultGeometryAttributeName(attributeDescriptor.getName());
                LOG.warn("Default geometry field {} has not been found. Setting \"{}\" as default geometry field", new Object[]{defaultGeometryField, attributeDescriptor.getName()});
                break;
            }
            if (editableFeatureType.getDefaultGeometryAttributeName() == null) {
                LOG.warn("The default geometry field can not be set");
            }
        }
        return editableFeatureType.getNotEditableCopy();
    }

    public List<FieldDefn> convertFields(FeatureType featureType) {
        ArrayList<FieldDefn> fields = new ArrayList<FieldDefn>();
        for (int i = 0; i < featureType.getAttributeDescriptors().length; ++i) {
            FeatureAttributeDescriptor attributeDescriptor = featureType.getAttributeDescriptor(i);
            if (attributeDescriptor.getType() == 66) continue;
            fields.add(this.convertField(attributeDescriptor));
        }
        return fields;
    }

    public FieldDefn convertField(FeatureAttributeDescriptor attDescriptor) {
        if (attDescriptor != null) {
            FieldDefn fieldDefn = new FieldDefn(attDescriptor.getName(), this.convertToOGRType(attDescriptor.getType()));
            fieldDefn.SetPrecision(attDescriptor.getPrecision());
            return fieldDefn;
        }
        return null;
    }

    public List<GeomFieldDefn> convertGeometryFields(FeatureType featureType, boolean convertDefaultGeometryColumn) {
        ArrayList<GeomFieldDefn> geometryFields = new ArrayList<GeomFieldDefn>();
        for (int i = 0; i < featureType.getAttributeDescriptors().length; ++i) {
            FeatureAttributeDescriptor attributeDescriptor = featureType.getAttributeDescriptor(i);
            if (attributeDescriptor.getType() != 66 || i == featureType.getDefaultGeometryAttributeIndex() && (i != featureType.getDefaultGeometryAttributeIndex() || !convertDefaultGeometryColumn)) continue;
            geometryFields.add(this.convertGeomField(attributeDescriptor));
        }
        return geometryFields;
    }

    public GeomFieldDefn convertGeomField(FeatureAttributeDescriptor attDescriptor) {
        String name = attDescriptor.getName();
        if (attDescriptor.getName().equals("ogr_geometry")) {
            name = "";
        }
        GeomFieldDefn geomFieldDefn = new GeomFieldDefn(name, this.convertToOGRGeomType(attDescriptor.getGeomType().getType()));
        if (attDescriptor.getSRS() != null) {
            SpatialReference srs = new SpatialReference(attDescriptor.getSRS().export("wkt"));
            geomFieldDefn.SetSpatialRef(srs);
        }
        return geomFieldDefn;
    }

    public FeatureProvider convert(FeatureProvider featureProvider, FeatureType featureType, Feature ogrFeature) {
        int fid = ogrFeature.GetFID();
        if (featureProvider == null) {
            featureProvider = new DefaultFeatureProvider(featureType, (Object)fid);
        } else {
            featureProvider.setOID((Object)fid);
        }
        FeatureDefn defnRef = ogrFeature.GetDefnRef();
        FeatureAttributeDescriptor[] attributeDescriptors = featureType.getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.length; ++i) {
            Object value;
            String name;
            if (attributeDescriptors[i].getDataType().getType() == 66) {
                org.gvsig.fmap.geom.Geometry geometry;
                name = attributeDescriptors[i].getName();
                int fieldIndex = -1;
                fieldIndex = name.equals("ogr_geometry") ? defnRef.GetGeomFieldIndex("") : defnRef.GetGeomFieldIndex(name);
                Geometry ogrGeometry = ogrFeature.GetGeomFieldRef(fieldIndex);
                if (ogrGeometry == null) continue;
                try {
                    geometry = GeometryLocator.getGeometryManager().createFrom(ogrGeometry.ExportToWkb());
                }
                catch (BaseException e) {
                    LOG.warn(String.format("Can not create geometry from %1s. Setting null value to geometry field", ogrGeometry.ExportToWkt()), (Throwable)e);
                    geometry = null;
                }
                if (attributeDescriptors[i].getName().equals(featureType.getDefaultGeometryAttributeName())) {
                    featureProvider.setDefaultGeometry(geometry);
                }
                featureProvider.set(name, (Object)geometry);
                continue;
            }
            name = attributeDescriptors[i].getName();
            int fieldIndex = defnRef.GetFieldIndex(name);
            FieldDefn fieldDefn = defnRef.GetFieldDefn(fieldIndex);
            int dataType = this.convertToDataType(fieldDefn.GetFieldType());
            switch (dataType) {
                case 4: {
                    value = ogrFeature.GetFieldAsInteger(i);
                    break;
                }
                case 7: {
                    value = ogrFeature.GetFieldAsDouble(i);
                    break;
                }
                default: {
                    value = ogrFeature.GetFieldAsString(i);
                }
            }
            featureProvider.set(fieldDefn.GetName(), value);
        }
        return featureProvider;
    }

    public Feature convert(FeatureProvider featureProvider) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (featureProvider == null) {
            return null;
        }
        FeatureType featureType = featureProvider.getType();
        FeatureDefn featureDefn = new FeatureDefn();
        List<FieldDefn> fields = this.convertFields(featureType);
        for (FieldDefn fieldDefn : fields) {
            featureDefn.AddFieldDefn(fieldDefn);
        }
        List<GeomFieldDefn> geometryFields = this.convertGeometryFields(featureType, true);
        for (GeomFieldDefn geomFieldDefn : geometryFields) {
            featureDefn.AddGeomFieldDefn(geomFieldDefn);
        }
        Feature feature = new Feature(featureDefn);
        Integer oid = null;
        if (featureProvider.getOID() instanceof Integer) {
            oid = (Integer)featureProvider.getOID();
        } else if (featureProvider.getOID() instanceof Long) {
            oid = ((Long)featureProvider.getOID()).intValue();
        }
        feature.SetFID(oid.intValue());
        FeatureAttributeDescriptor[] attributeDescriptors = featureType.getAttributeDescriptors();
        block9: for (int i = 0; i < attributeDescriptors.length; ++i) {
            Integer fieldIndex = attributeDescriptors[i].getType() == 66 && attributeDescriptors[i].getName().equals("ogr_geometry") ? Integer.valueOf(featureDefn.GetGeomFieldIndex("")) : (attributeDescriptors[i].getType() == 66 ? Integer.valueOf(featureDefn.GetGeomFieldIndex(attributeDescriptors[i].getName())) : Integer.valueOf(featureDefn.GetFieldIndex(attributeDescriptors[i].getName())));
            Object value = featureProvider.get(i);
            if (value == null) continue;
            switch (attributeDescriptors[i].getType()) {
                case 8: {
                    feature.SetField(fieldIndex.intValue(), (String)value);
                    continue block9;
                }
                case 7: {
                    feature.SetField(fieldIndex.intValue(), ((Double)value).doubleValue());
                    continue block9;
                }
                case 1: {
                    feature.SetField(fieldIndex.intValue(), ((Boolean)value).toString());
                    continue block9;
                }
                case 9: {
                    Date date = (Date)value;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    feature.SetField(i, calendar.get(1), calendar.get(2), calendar.get(7), calendar.get(10), calendar.get(12), calendar.get(13), 0);
                    continue block9;
                }
                case 66: {
                    Geometry ogrGeometry;
                    org.gvsig.fmap.geom.Geometry geometry = (org.gvsig.fmap.geom.Geometry)value;
                    if (attributeDescriptors[i].getSRS() != null) {
                        IProjection projection = attributeDescriptors[i].getSRS();
                        SpatialReference srs = new SpatialReference(projection.export("wkt"));
                        ogrGeometry = ogr.CreateGeometryFromWkt((String)geometry.convertToWKT(), (SpatialReference)srs);
                        feature.SetGeomField(i, ogrGeometry);
                        continue block9;
                    }
                    ogrGeometry = ogr.CreateGeometryFromWkt((String)geometry.convertToWKT());
                    feature.SetGeomField(fieldIndex.intValue(), ogrGeometry);
                    continue block9;
                }
            }
        }
        return feature;
    }

    public int convertToOGRGeomType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 23: 
            case 24: {
                return 2;
            }
            case 3: 
            case 19: 
            case 25: {
                return 3;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 4;
            }
            case 8: 
            case 21: {
                return 5;
            }
            case 9: 
            case 22: {
                return 6;
            }
            case 16: {
                return 100;
            }
        }
        return 0;
    }

    public int convertToGeomType(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 21;
            }
            case 6: {
                return 9;
            }
            case 100: {
                return 16;
            }
        }
        return 0;
    }

    public int convertToOGRType(int type) {
        switch (type) {
            case 9: {
                return 9;
            }
            case 6: 
            case 7: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 4;
    }

    public int convertToDataType(int type) {
        switch (type) {
            case 9: {
                return 9;
            }
            case 2: {
                return 7;
            }
            case 0: {
                return 4;
            }
            case 10: {
                return 10;
            }
        }
        return 8;
    }

    public Feature convert(FeatureDefn layerDefn, Feature feature) {
        int fieldIndex;
        int i;
        Feature newFeature = new Feature(layerDefn);
        block5: for (i = 0; i < feature.GetDefnRef().GetFieldCount(); ++i) {
            FieldDefn fieldDefn = feature.GetDefnRef().GetFieldDefn(i);
            fieldIndex = newFeature.GetDefnRef().GetFieldIndex(fieldDefn.GetName());
            if (fieldIndex == -1) continue;
            int fieldType = feature.GetDefnRef().GetFieldDefn(i).GetFieldType();
            switch (fieldType) {
                case 9: {
                    int[] year = new int[1];
                    int[] month = new int[1];
                    int[] day = new int[1];
                    int[] hour = new int[1];
                    int[] minute = new int[1];
                    int[] second = new int[1];
                    int[] flags = new int[1];
                    feature.GetFieldAsDateTime(i, year, month, day, hour, minute, second, flags);
                    newFeature.SetField(i, year[0], month[0], day[0], hour[0], minute[0], second[0], flags[0]);
                    continue block5;
                }
                case 2: {
                    newFeature.SetField(i, feature.GetFieldAsDouble(i));
                    continue block5;
                }
                case 0: {
                    newFeature.SetField(i, feature.GetFieldAsInteger(i));
                    continue block5;
                }
                default: {
                    newFeature.SetField(i, feature.GetFieldAsString(i));
                }
            }
        }
        for (i = 0; i < feature.GetDefnRef().GetGeomFieldCount(); ++i) {
            GeomFieldDefn geomFieldDefn = feature.GetDefnRef().GetGeomFieldDefn(i);
            fieldIndex = newFeature.GetDefnRef().GetGeomFieldIndex(geomFieldDefn.GetName());
            if (fieldIndex == -1) continue;
            if (geomFieldDefn.GetFieldType() == newFeature.GetGeomFieldDefnRef(fieldIndex).GetFieldType()) {
                Geometry geometry = feature.GetGeomFieldRef(geomFieldDefn.GetName());
                newFeature.SetGeomField(fieldIndex, geometry);
                continue;
            }
            LOG.warn("Ignoring geometry field. Can not fix {}. Geometry type is not equals", (Object)geomFieldDefn.GetName());
        }
        return newFeature;
    }
}

