/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.gdal.prov.ogr.OGRConverter;
import org.gvsig.gdal.prov.ogr.OGRNewDataStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OGRFilesystemServerProvider.class);
    private FilesystemServerExplorerProviderServices serverExplorer;

    public String getDataStoreProviderName() {
        return "OGRDataStoreProvider";
    }

    public String getDescription() {
        return "OGR provider to open vectorial resources";
    }

    public boolean accept(File pathname) {
        return pathname.isFile() && ogr.Open((String)pathname.getAbsolutePath(), (int)1) != null;
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public boolean canCreate() {
        throw new UnsupportedOperationException();
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        if (parameters instanceof OGRNewDataStoreParameters) {
            final OGRNewDataStoreParameters newOGRDataStoreParameters = (OGRNewDataStoreParameters)parameters;
            final File file = newOGRDataStoreParameters.getFile();
            if (file.isFile() && file.exists()) {
                if (overwrite) {
                    try {
                        this.remove((DataStoreParameters)newOGRDataStoreParameters);
                    }
                    catch (RemoveException e) {
                        throw new CreateException("Can not overwrite file", (Throwable)e);
                    }
                } else {
                    throw new CreateException(file.getAbsolutePath(), (Throwable)new IllegalArgumentException(String.format("%1s exists and overwrite option is false", file.getAbsolutePath())));
                }
            }
            try {
                final FileResource resource = (FileResource)this.serverExplorer.getServerExplorerProviderServices().createResource("file", new Object[]{file.getAbsolutePath()});
                resource.addConsumer((ResourceConsumer)this);
                resource.execute(new ResourceAction(){

                    public Object run() throws Exception {
                        Layer existingLayer;
                        String driverName = newOGRDataStoreParameters.getDriverName();
                        Driver driver = ogr.GetDriverByName((String)driverName);
                        if (driver == null || StringUtils.isBlank((CharSequence)driverName)) {
                            throw new IllegalArgumentException("Driver name can not be blank and driver must exist.");
                        }
                        List options = newOGRDataStoreParameters.getDatasetCreationOptions();
                        DataSource dataSource = null;
                        dataSource = options == null ? driver.CreateDataSource(resource.getFile().getAbsolutePath()) : driver.CreateDataSource(resource.getFile().getAbsolutePath(), new Vector(options));
                        if (dataSource == null) {
                            LOG.error("Can not open datasource from {} and {} options", (Object)resource.getFile().getAbsoluteFile(), (Object)options);
                            throw new ResourceExecuteException((Resource)resource, null);
                        }
                        String layerName = newOGRDataStoreParameters.getLayerName();
                        if (StringUtils.isBlank((CharSequence)layerName)) {
                            layerName = file.getName();
                        }
                        if ((existingLayer = dataSource.GetLayerByName(layerName)) != null) {
                            for (int i = 0; i < dataSource.GetLayerCount(); ++i) {
                                if (!dataSource.GetLayerByIndex(i).GetName().equals(existingLayer.GetName())) continue;
                                dataSource.DeleteLayer(i);
                                break;
                            }
                        }
                        OGRConverter converter = new OGRConverter();
                        FeatureAttributeDescriptor geometryAttribute = newOGRDataStoreParameters.getDefaultFeatureType().getDefaultGeometryAttribute();
                        Integer ogrType = null;
                        SpatialReference srs = null;
                        if (geometryAttribute != null) {
                            int type = geometryAttribute.getGeomType().getType();
                            ogrType = converter.convertToOGRGeomType(type);
                            IProjection projection = geometryAttribute.getSRS();
                            if (projection == null && newOGRDataStoreParameters.getCRS() != null) {
                                projection = newOGRDataStoreParameters.getCRS();
                                srs = new SpatialReference(projection.export("wkt"));
                            }
                        }
                        Layer layer = null;
                        layer = srs == null ? dataSource.CreateLayer(layerName) : (ogrType == null ? dataSource.CreateLayer(layerName, srs) : dataSource.CreateLayer(layerName, srs, ogrType.intValue()));
                        if (layer.TestCapability("CreateField")) {
                            List<FieldDefn> fields = converter.convertFields((FeatureType)newOGRDataStoreParameters.getDefaultFeatureType());
                            for (FieldDefn fieldDefn : fields) {
                                layer.CreateField(fieldDefn);
                            }
                        } else {
                            LOG.warn("{} driver does not support creation of fields", (Object)driver.getName());
                        }
                        if (layer.TestCapability("CreateGeomField")) {
                            List<GeomFieldDefn> geomFields = converter.convertGeometryFields((FeatureType)newOGRDataStoreParameters.getDefaultFeatureType(), false);
                            for (GeomFieldDefn geomFieldDefn : geomFields) {
                                layer.CreateGeomField(geomFieldDefn);
                            }
                        } else {
                            LOG.warn("{} driver does not support creation of geometry fields, only default OGR geometry field has been created", (Object)driver.getName());
                        }
                        dataSource.delete();
                        return null;
                    }
                });
            }
            catch (InitializeException e) {
                throw new CreateException("Can not create file resource to create it", (Throwable)e);
            }
        }
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        OGRNewDataStoreParameters newParameters = new OGRNewDataStoreParameters();
        EditableFeatureType editableFeatureType = DALLocator.getDataManager().createFeatureType();
        newParameters.setDefaultFeatureType((FeatureType)editableFeatureType);
        return newParameters;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        if (parameters instanceof OGRNewDataStoreParameters) {
            final OGRNewDataStoreParameters newOGRDataStoreParameters = (OGRNewDataStoreParameters)parameters;
            File file = newOGRDataStoreParameters.getFile();
            if (!file.exists() && !file.canWrite()) {
                throw new RemoveException(file.getAbsolutePath(), (Throwable)new IllegalArgumentException(String.format("%1s does not exist", file.getAbsolutePath())));
            }
            try {
                final FileResource resource = (FileResource)this.serverExplorer.getServerExplorerProviderServices().createResource("file", new Object[]{file.getAbsolutePath()});
                resource.addConsumer((ResourceConsumer)this);
                resource.execute(new ResourceAction(){

                    public Object run() throws Exception {
                        resource.closeRequest();
                        String driverName = newOGRDataStoreParameters.getDriverName();
                        Driver driver = ogr.GetDriverByName((String)driverName);
                        if (driver == null || StringUtils.isBlank((CharSequence)driverName)) {
                            LOG.warn("Driver name is blank or driver null, trying to get it opening datasource of resource");
                            DataSource dataSource = ogr.Open((String)resource.getFile().getAbsolutePath());
                            if (dataSource == null) {
                                LOG.error("Can not determiante driver to remove resource");
                                throw new RemoveException(resource.getName(), null);
                            }
                            driver = dataSource.GetDriver();
                        }
                        if (!driver.TestCapability("DeleteDataSource")) {
                            LOG.error("{} driver does not support delete data source", (Object)driver.getName());
                            throw new RemoveException(resource.getFile().getAbsolutePath(), null);
                        }
                        driver.DeleteDataSource(resource.getFile().getAbsolutePath());
                        return null;
                    }
                });
                resource.addConsumer((ResourceConsumer)this);
            }
            catch (InitializeException e) {
                throw new RemoveException("Can not create file resource to remove it", (Throwable)e);
            }
        }
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        if (parameters instanceof OGRNewDataStoreParameters) {
            File file;
            OGRNewDataStoreParameters newOGRDataStoreParameters = (OGRNewDataStoreParameters)parameters;
            String driverName = newOGRDataStoreParameters.getDriverName();
            Driver driver = null;
            if (!StringUtils.isNotBlank((CharSequence)driverName)) {
                return false;
            }
            driver = ogr.GetDriverByName((String)driverName);
            if (driver.TestCapability("CreateDataSource") && driver.TestCapability("CreateField") && (file = newOGRDataStoreParameters.getFile()) != null && file.canWrite()) {
                return true;
            }
        }
        return false;
    }
}

