/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circlecr;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class Circle2Tg1PEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter firstPoint;
    protected EditingServiceParameter secondPoint;
    protected EditingServiceParameter thirdPoint;
    protected EditingServiceParameter fourthPoint;
    protected EditingServiceParameter fifthPoint;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;

    public Circle2Tg1PEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPoint = new DefaultEditingServiceParameter("first_point_of_the_first_line", "first_point_of_the_first_line", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPoint = new DefaultEditingServiceParameter("second_point_of_the_first_line", "second_point_of_the_first_line", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.thirdPoint = new DefaultEditingServiceParameter("first_point_of_the_second_line", "first_point_of_the_second_line", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.fourthPoint = new DefaultEditingServiceParameter("second_point_of_the_second_line", "second_point_of_the_second_line", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.fifthPoint = new DefaultEditingServiceParameter("point_near_center", "point_near_center", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public DefaultDrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        if (this.values != null) {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point secondPointValue = (Point)this.values.get(this.secondPoint);
            Point thirdPointValue = (Point)this.values.get(this.thirdPoint);
            Point fourthPointValue = (Point)this.values.get(this.fourthPoint);
            Point fifthPointValue = (Point)this.values.get(this.fifthPoint);
            if (firstPointValue != null && secondPointValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                    Line line = editingProviderServices.createLine(firstPointValue, mousePosition, subtype);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
            if (firstPointValue != null && secondPointValue != null && thirdPointValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Line line1 = editingProviderServices.createLine(firstPointValue, secondPointValue, subtype);
                    drawingStatus.addStatus((Geometry)line1, auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)secondPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
            if (firstPointValue != null && secondPointValue != null && thirdPointValue != null && fourthPointValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Line line1 = editingProviderServices.createLine(firstPointValue, secondPointValue, subtype);
                    drawingStatus.addStatus((Geometry)line1, auxiliaryLineSymbolEditing, "");
                    Line line = editingProviderServices.createLine(thirdPointValue, mousePosition, subtype);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)secondPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)thirdPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
            if (firstPointValue != null && secondPointValue != null && thirdPointValue != null && fourthPointValue != null && fifthPointValue == null) {
                try {
                    Point intersectionB;
                    Point intersectionA;
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Line line1 = editingProviderServices.createLine(firstPointValue, secondPointValue, subtype);
                    drawingStatus.addStatus((Geometry)line1, auxiliaryLineSymbolEditing, "");
                    Line line2 = editingProviderServices.createLine(thirdPointValue, fourthPointValue, subtype);
                    drawingStatus.addStatus((Geometry)line2, auxiliaryLineSymbolEditing, "");
                    Circle circle = editingProviderServices.createCircle(firstPointValue, secondPointValue, thirdPointValue, fourthPointValue, mousePosition, subtype);
                    drawingStatus.addStatus((Geometry)circle, polygonSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)circle, previewSymbol, "");
                    Point center = circle.getCenter();
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)secondPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)thirdPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)fourthPointValue, auxiliaryPointSymbolEditing, "");
                    EuclideanLine2D tangent1 = euclideanManager.createLine2D(firstPointValue.getX(), firstPointValue.getY(), secondPointValue.getX(), secondPointValue.getY());
                    EuclideanLine2D tangent2 = euclideanManager.createLine2D(thirdPointValue.getX(), thirdPointValue.getY(), fourthPointValue.getX(), fourthPointValue.getY());
                    if (tangent1.isParallel(tangent2)) {
                        if (Objects.equals(tangent1.getYIntercept(), tangent2.getYIntercept())) {
                            EuclideanLine2D perp = tangent1.getPerpendicular(mousePosition.getX(), mousePosition.getY());
                            Point2D intersection = tangent1.getIntersection(perp);
                            drawingStatus.addStatus((Geometry)editingProviderServices.createLine(mousePosition.getX(), mousePosition.getY(), intersection.getX(), intersection.getY(), subtype), auxiliaryLineSymbolEditing, "");
                        }
                    } else {
                        EuclideanLine2D perp;
                        Point2D intersectionTangents = tangent1.getIntersection(tangent2);
                        drawingStatus.addStatus((Geometry)editingProviderServices.createLine(intersectionTangents.getX(), intersectionTangents.getY(), center.getX(), center.getY(), subtype), auxiliaryLineSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)geomManager.createPoint(intersectionTangents.getX(), intersectionTangents.getY(), subtype), auxiliaryPointSymbolEditing, "");
                        EuclideanLine2D[] bisectors = tangent1.getBisectors(tangent2);
                        double distance0 = bisectors[0].getDistance(mousePosition.getX(), mousePosition.getY());
                        double distance1 = bisectors[1].getDistance(mousePosition.getX(), mousePosition.getY());
                        EuclideanLine2D bisector = bisectors[0];
                        if (distance0 > distance1) {
                            bisector = bisectors[1];
                        }
                        Point2D intersection = Double.isInfinite((perp = bisector.getPerpendicular(mousePosition.getX(), mousePosition.getY())).getSlope()) ? new Point2D.Double(mousePosition.getX(), center.getY()) : bisector.getIntersection(perp);
                        drawingStatus.addStatus((Geometry)editingProviderServices.createLine(intersection.getX(), intersection.getY(), center.getX(), center.getY(), subtype), auxiliaryLineSymbolEditing, "");
                    }
                    drawingStatus.addStatus((Geometry)editingProviderServices.createLine(mousePosition, center, subtype), auxiliaryLineSymbolEditing, "");
                    EuclideanLine2D perpA = tangent1.getPerpendicular(center.getX(), center.getY());
                    if (tangent1.getSlope() == 0.0) {
                        intersectionA = editingProviderServices.createPoint(center.getX(), tangent1.getYIntercept(), subtype);
                    } else {
                        Point2D intersection = tangent1.getIntersection(perpA);
                        intersectionA = editingProviderServices.createPoint(intersection.getX(), intersection.getY(), subtype);
                    }
                    drawingStatus.addStatus((Geometry)intersectionA, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)editingProviderServices.createLine(center, intersectionA, subtype), auxiliaryLineSymbolEditing, "");
                    EuclideanLine2D perpB = tangent2.getPerpendicular(center.getX(), center.getY());
                    if (tangent2.getSlope() == 0.0) {
                        intersectionB = editingProviderServices.createPoint(center.getX(), tangent2.getYIntercept(), subtype);
                    } else {
                        Point2D intersection = tangent2.getIntersection(perpB);
                        intersectionB = editingProviderServices.createPoint(intersection.getX(), intersection.getY(), subtype);
                    }
                    drawingStatus.addStatus((Geometry)intersectionB, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)editingProviderServices.createLine(center, intersectionB, subtype), auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    public EditingServiceParameter next() {
        if (this.values != null) {
            if (this.values.get(this.firstPoint) == null) {
                return this.firstPoint;
            }
            if (this.values.get(this.secondPoint) == null) {
                return this.secondPoint;
            }
            if (this.values.get(this.thirdPoint) == null) {
                return this.thirdPoint;
            }
            if (this.values.get(this.fourthPoint) == null) {
                return this.fourthPoint;
            }
            if (this.values.get(this.fifthPoint) == null) {
                return this.fifthPoint;
            }
        }
        return null;
    }

    public void stop() {
        this.values.clear();
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.firstPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.secondPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.thirdPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.fourthPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.fifthPoint && value instanceof Point) {
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.firstPoint);
        list.add(this.secondPoint);
        list.add(this.thirdPoint);
        list.add(this.fourthPoint);
        list.add(this.fifthPoint);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public Geometry finish() throws FinishServiceException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point firstPointValue = (Point)this.values.get(this.firstPoint);
        Point secondPointValue = (Point)this.values.get(this.secondPoint);
        Point thirdPointValue = (Point)this.values.get(this.thirdPoint);
        Point fourthPointValue = (Point)this.values.get(this.fourthPoint);
        Point fifthPointValue = (Point)this.values.get(this.fifthPoint);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
            Circle circle = editingProviderServices.createCircle(firstPointValue, secondPointValue, thirdPointValue, fourthPointValue, fifthPointValue, subtype);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circle);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-circle-2tg1p";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

