/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circlecr;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.circlecr.CircleCDEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class CircumferenceCDEditingProvider
extends CircleCDEditingProvider
implements EditingProvider {
    public CircumferenceCDEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices, parameters);
    }

    @Override
    public DefaultDrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        geometries.setPreviewSymbol(previewSymbol);
        if (this.values != null && this.values.get(this.center) != null && this.values.get(this.diameter) == null) {
            Point centerPoint = (Point)this.values.get(this.center);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Point oppositePosition = GeometryUtils.createPoint((double)(centerPoint.getX() - (mousePosition.getX() - centerPoint.getX())), (double)(centerPoint.getY() - (mousePosition.getY() - centerPoint.getY())));
                Line line = editingProviderServices.createLine(oppositePosition, mousePosition, subtype);
                Circumference circumference = (Circumference)geomManager.create(23, subtype);
                circumference.setPoints(centerPoint, mousePosition.distance((Geometry)centerPoint));
                geometries.addStatus((Geometry)centerPoint, auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                geometries.addStatus((Geometry)circumference, lineSymbolEditing, "");
                geometries.addStatus((Geometry)circumference, previewSymbol, "");
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
            return geometries;
        }
        return null;
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point centerPoint = (Point)this.values.get(this.center);
        double diameterValue = (Double)this.values.get(this.diameter);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
            Circumference circumference = (Circumference)geomManager.create(23, subtype);
            circumference.setPoints(centerPoint, diameterValue / 2.0);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circumference);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "insert-circumference-cd";
    }
}

