/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorerParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCServerExplorerBase;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class H2SpatialExplorer
extends JDBCServerExplorerBase {
    public H2SpatialExplorer(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices services, JDBCHelper helper) throws InitializeException {
        super(parameters, services, helper);
    }

    public H2SpatialExplorerParameters getParameters() {
        return (H2SpatialExplorerParameters)super.getParameters();
    }

    public ResourcesStorage getResourcesStorage(DataStore dataStore) {
        ResourcesStorage ress = super.getResourcesStorage(dataStore);
        return ress;
    }

    public H2SpatialHelper getHelper() {
        return (H2SpatialHelper)super.getHelper();
    }

    public Object execute(String sql) {
        if (StringUtils.equalsIgnoreCase((CharSequence)sql, (CharSequence)"!SHUTDOWN")) {
            this.getHelper().shutdown();
            return null;
        }
        return super.execute(sql);
    }

    public boolean exists() {
        try {
            H2SpatialExplorerParameters serverParameters = this.getParameters();
            File f = H2SpatialUtils.normalizeH2File(serverParameters.getFile());
            if (!f.exists()) {
                return false;
            }
            return super.exists();
        }
        catch (Throwable th) {
            return false;
        }
    }

    protected ResourcesStorage getLocalResourcesStorage(DataStoreParameters parameters, String storeName) {
        return null;
    }
}

