/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2.operations;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;

public class H2SpatialFetchFeatureTypeOperation
extends FetchFeatureTypeOperation {
    private static Map<String, GeometryType> h2spatialGeometryTypes = null;
    private Map<String, GeometryColumnInfo> geometry_column;

    public H2SpatialFetchFeatureTypeOperation(JDBCHelper helper) {
        super(helper);
    }

    private GeometryType getGT(GeometryManager manager, int type, int subtype) {
        try {
            return manager.getGeometryType(type, subtype);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public H2SpatialFetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryColumn, IProjection crs, int geometryType, int geometrySubtype) {
        super(helper, featureType, table, primaryKeys, defaultGeometryColumn, crs, geometryType, geometrySubtype);
    }

    private GeometryColumnInfo getGeometryColumnInfo(String name) {
        if (this.geometry_column == null) {
            this.geometry_column = new HashMap<String, GeometryColumnInfo>();
            try {
                StringBuilder where = null;
                if (this.table.hasDatabase()) {
                    if (where == null) {
                        where = new StringBuilder();
                    } else {
                        where.append(" AND ");
                    }
                    where.append("UPPER(F_TABLE_CATALOG) = '");
                    where.append(this.table.getDatabase().toUpperCase());
                    where.append("'");
                }
                if (this.table.hasSchema()) {
                    if (where == null) {
                        where = new StringBuilder();
                    } else {
                        where.append(" AND ");
                    }
                    where.append("UPPER(F_TABLE_SCHEMA) = '");
                    where.append(this.table.getSchema().toUpperCase());
                    where.append("'");
                }
                if (this.table.hasTable()) {
                    if (where == null) {
                        where = new StringBuilder();
                    } else {
                        where.append(" AND ");
                    }
                    where.append("UPPER(F_TABLE_NAME) = '");
                    where.append(this.table.getTable().toUpperCase());
                    where.append("'");
                }
                String sql = "SELECT F_GEOMETRY_COLUMN, GEOMETRY_TYPE, COORD_DIMENSION, SRID, TYPE FROM GEOMETRY_COLUMNS WHERE " + where;
                Statement st = this.getConnection().createStatement();
                ResultSet rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
                while (rs.next()) {
                    this.geometry_column.put(rs.getString("F_GEOMETRY_COLUMN"), new GeometryColumnInfo(rs.getString("F_GEOMETRY_COLUMN"), rs.getInt("GEOMETRY_TYPE"), rs.getString("TYPE"), rs.getInt("COORD_DIMENSION"), rs.getInt("SRID")));
                }
            }
            catch (SQLException | AccessResourceException ex) {
                LOGGER.warn("Can't read metadata from table '" + this.table + "'.", ex);
            }
        }
        return this.geometry_column.get(name);
    }

    public void fetch(JDBCConnection conn) throws DataException {
        super.fetch(conn);
    }

    protected void fetchGeometryTypeAndSRS(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        try {
            if (attr.getType() == 66) {
                GeometryType gt;
                GeometryColumnInfo column_info = this.getGeometryColumnInfo(attr.getName());
                String type = "GEOMETRY";
                if (column_info != null) {
                    type = column_info.dimensions == 3 ? column_info.geometryTypeName + "Z" : column_info.geometryTypeName;
                    SRSSolver solver = this.helper.getSRSSolver();
                    attr.setSRS(solver.getProjection(this.getConnection(), (Object)column_info.srid));
                }
                if ((gt = this.getGeometryTypeFromH2SpatialType(type)) != null) {
                    attr.setGeometryType(gt);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't fetch geometry type and SRS.", ex);
        }
    }

    private GeometryType getGeometryTypeFromH2SpatialType(String typeName) {
        if (h2spatialGeometryTypes == null) {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            h2spatialGeometryTypes = new HashMap<String, GeometryType>();
            h2spatialGeometryTypes.put("POINT", this.getGT(manager, 1, 0));
            h2spatialGeometryTypes.put("POINTZ", this.getGT(manager, 1, 1));
            h2spatialGeometryTypes.put("LINESTRING", this.getGT(manager, 18, 0));
            h2spatialGeometryTypes.put("LINESTRINGZ", this.getGT(manager, 18, 1));
            h2spatialGeometryTypes.put("POLYGON", this.getGT(manager, 19, 0));
            h2spatialGeometryTypes.put("POLYGONZ", this.getGT(manager, 19, 1));
            h2spatialGeometryTypes.put("MULTIPOINT", this.getGT(manager, 7, 0));
            h2spatialGeometryTypes.put("MULTIPOINTZ", this.getGT(manager, 7, 1));
            h2spatialGeometryTypes.put("MULTILINESTRING", this.getGT(manager, 21, 0));
            h2spatialGeometryTypes.put("MULTILINESTRINGZ", this.getGT(manager, 21, 1));
            h2spatialGeometryTypes.put("MULTIPOLYGON", this.getGT(manager, 22, 0));
            h2spatialGeometryTypes.put("MULTIPOLYGONZ", this.getGT(manager, 22, 1));
            h2spatialGeometryTypes.put("GEOMETRY", this.getGT(manager, 0, 0));
            h2spatialGeometryTypes.put("GEOMETRYZ", this.getGT(manager, 0, 1));
            h2spatialGeometryTypes.put("GEOMCOLLECTION", this.getGT(manager, 0, 0));
            h2spatialGeometryTypes.put("GEOMCOLLECTIONZ", this.getGT(manager, 0, 1));
        }
        return h2spatialGeometryTypes.get(typeName);
    }

    public String getSQLToRetrievePrimaryKeysFromInformationSchema() throws SQLException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.select().column().name("COLUMN_LIST");
        sqlbuilder.select().column().name("CONSTRAINT_TYPE");
        sqlbuilder.select().from().table().schema("INFORMATION_SCHEMA").name("CONSTRAINTS");
        sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.column("TABLE_NAME"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getTable())));
        if (this.table.hasSchema()) {
            sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.column("TABLE_SCHEMA"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getSchema())));
        }
        sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column("CONSTRAINT_TYPE"), (ExpressionBuilder.Value)expbuilder.constant((Object)"PRIMARY KEY")));
        return sqlbuilder.toString();
    }

    private static class GeometryColumnInfo {
        public String columnName;
        public int geometryType;
        public String geometryTypeName;
        public int dimensions;
        public int srid;

        public GeometryColumnInfo(String columnName, int geometryType, String geometryTypeName, int dimensions, int srid) {
            this.columnName = columnName;
            this.geometryType = geometryType;
            this.geometryTypeName = geometryTypeName;
            this.dimensions = dimensions;
            this.srid = srid;
        }
    }
}

