/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.split;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.VectorEditingException;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperation;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SplitEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selection;
    private final EditingServiceParameter splitGeometry;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;

    public SplitEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.splitGeometry = new DefaultEditingServiceParameter("draw_geometry_to_split", "draw_geometry_to_split", 2, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.GEOMETRY});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.splitGeometry) == null) {
            return this.splitGeometry;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.splitGeometry);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (this.values != null && value != null) {
            if (value instanceof FeatureSelection) {
                FeatureSelection featureSelection = (FeatureSelection)value;
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        GeometryType geoType = geometry.getGeometryType();
                        if (geoType.isTypeOf(1) || geoType.isTypeOf(7)) {
                            throw new InvalidEntryException(null);
                        }
                    });
                    this.values.put(this.selection, value);
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
            if (value instanceof Geometry) {
                Geometry geometry = (Geometry)value;
                if (geometry instanceof MultiCurve) {
                    MultiCurve multiCurve = (MultiCurve)geometry;
                    for (int i = 0; i < multiCurve.getPrimitivesNumber(); ++i) {
                        if (!this.isValid((Curve)multiCurve.getPrimitiveAt(i))) continue;
                        this.values.put(this.splitGeometry, geometry);
                        return;
                    }
                } else if (geometry instanceof Curve && this.isValid((Curve)geometry)) {
                    this.values.put(this.splitGeometry, geometry);
                    return;
                }
            }
        }
        throw new InvalidEntryException(null);
    }

    private boolean isValid(Curve curve) {
        FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
        try {
            featureSelection.accept(obj -> {
                Feature feature = (Feature)obj;
                Geometry geometry = feature.getDefaultGeometry();
                Geometry intersection = geometry.intersection((Geometry)curve);
                if (intersection instanceof Complex ? ((Aggregate)(intersection = ((Complex)intersection).createAggregate(22, t -> t.getGeometryType().getType() == 22 || t.getGeometryType().getType() == 19))).getPrimitivesNumber() == 0 : intersection == null || !intersection.getGeometryType().isTypeOf(1) && !intersection.getGeometryType().isTypeOf(7) && !intersection.getGeometryType().isTypeOf(2) && !intersection.getGeometryType().isTypeOf(8)) {
                    throw new VectorEditingException();
                }
            });
            return true;
        }
        catch (BaseException e) {
            return false;
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            Geometry splitter = (Geometry)this.values.get(this.splitGeometry);
            ToolsLocator.getDisposableManager().bind((Disposable)featureSelection);
            DisposableIterator it = null;
            try {
                it = featureSelection.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    Geometry geometryToBeSplitted = feature.getDefaultGeometry();
                    GeometryType geoType = geometryToBeSplitted.getGeometryType();
                    if (geoType.isTypeOf(3) || geoType.isTypeOf(2)) {
                        MultiPrimitive splittedGeometries = (MultiPrimitive)this.split((Primitive)geometryToBeSplitted, splitter);
                        for (int j = 0; j < splittedGeometries.getPrimitivesNumber(); ++j) {
                            this.copyAlfanumericDataAndInsert((Geometry)splittedGeometries.getPrimitiveAt(j), feature);
                        }
                    } else if (geoType.isTypeOf(9) || geoType.isTypeOf(8)) {
                        MultiPrimitive multiPrimitive = (MultiPrimitive)geometryToBeSplitted;
                        GeometryManager geoManager = GeometryLocator.getGeometryManager();
                        Object multiNoSplitted = geoType.isTypeOf(9) ? geoManager.createMultiSurface(editingProviderServices.getSubType(this.featureStore)) : geoManager.createMultiCurve(editingProviderServices.getSubType(this.featureStore));
                        for (int i = 0; i < multiPrimitive.getPrimitivesNumber(); ++i) {
                            Geometry geoSplitted = this.split(multiPrimitive.getPrimitiveAt(i), splitter);
                            if (geoSplitted instanceof MultiPrimitive) {
                                MultiPrimitive multiSplitted = (MultiPrimitive)geoSplitted;
                                for (int j = 0; j < multiSplitted.getPrimitivesNumber(); ++j) {
                                    this.copyAlfanumericDataAndInsert((Geometry)multiSplitted.getPrimitiveAt(j), feature);
                                }
                                continue;
                            }
                            multiNoSplitted.addPrimitive((Primitive)geoSplitted);
                        }
                        if (multiNoSplitted.getPrimitivesNumber() > 0) {
                            this.copyAlfanumericDataAndInsert((Geometry)multiNoSplitted, feature);
                        }
                    }
                    editingProviderServices.deleteFeatureFromFeatureStore(feature, this.featureStore);
                }
                featureSelection.deselectAll();
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
                DisposeUtils.disposeQuietly((Disposable)featureSelection);
            }
        }
    }

    private void copyAlfanumericDataAndInsert(Geometry geometry, Feature feature) throws DataException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        EditableFeature eFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
        eFeature.setDefaultGeometry(geometry);
        editingProviderServices.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
    }

    private Geometry split(Primitive geometry, Geometry splitter) throws GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        SplitOperation operation = SplitOperationUtils.getOperation(geometry);
        if (operation != null) {
            return operation.split((Geometry)geometry, splitter);
        }
        return null;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                this.setValue(selected);
            }
        }
    }

    public String getName() {
        return "modify-split";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

