/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.split.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperation;

public class SplitOperationUtils {
    private static final Map<Integer, SplitOperation> operations = new HashMap<Integer, SplitOperation>();

    private SplitOperationUtils() {
    }

    public static void register(SplitOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static SplitOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        SplitOperation operation = operations.get(type);
        return operation;
    }

    public static Point getMidPoint(Point a, Point b, int subtype) throws CreateGeometryException {
        double x = (a.getX() + b.getX()) / 2.0;
        double y = (a.getY() + b.getY()) / 2.0;
        return SplitOperationUtils.createPoint(x, y, subtype);
    }

    public static Point createPoint(double x, double y, int subtype) throws CreateGeometryException {
        Point point = (Point)GeometryLocator.getGeometryManager().create(1, subtype);
        point.setX(x);
        point.setY(y);
        return point;
    }

    public static Point[] getPerpendicular(Double m, Double b, Point perp, int subtype) throws CreateGeometryException {
        if (m == Double.POSITIVE_INFINITY) {
            Point[] res = new Point[]{SplitOperationUtils.createPoint(0.0, perp.getY(), subtype), SplitOperationUtils.createPoint(1.0, perp.getY(), subtype)};
            return res;
        }
        if (m == Double.NEGATIVE_INFINITY) {
            Point[] res = new Point[]{SplitOperationUtils.createPoint(1.0, perp.getY(), subtype), SplitOperationUtils.createPoint(0.0, perp.getY(), subtype)};
            return res;
        }
        Double m1 = -1.0 / m;
        Double b1 = perp.getY() - m1 * perp.getX();
        Point[] res = new Point[2];
        if (Double.isInfinite(m1)) {
            res[0] = SplitOperationUtils.createPoint(perp.getX(), 0.0, subtype);
            res[1] = SplitOperationUtils.createPoint(perp.getX(), perp.getY(), subtype);
        } else {
            res[0] = SplitOperationUtils.createPoint(0.0, 0.0 + b1, subtype);
            res[1] = SplitOperationUtils.createPoint(perp.getX(), m1 * perp.getX() + b1, subtype);
        }
        return res;
    }

    public static Double[] getLineParams(Point point, Point nextPoint) {
        Double[] lineParams = new Double[2];
        double denom = nextPoint.getX() - point.getX();
        if (denom != 0.0) {
            lineParams[0] = (nextPoint.getY() - point.getY()) / denom;
            lineParams[1] = point.getY() - lineParams[0] * point.getX();
        } else if (nextPoint.getY() >= point.getY()) {
            lineParams[0] = Double.POSITIVE_INFINITY;
            lineParams[1] = Double.NEGATIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        } else {
            lineParams[0] = Double.NEGATIVE_INFINITY;
            lineParams[1] = Double.POSITIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        }
        return lineParams;
    }

    public static Point getIntersection(Point[] lineA, Point[] lineB, int subtype) throws CreateGeometryException {
        Point p1 = lineA[0];
        Point p2 = lineA[1];
        Point p3 = lineB[0];
        Point p4 = lineB[1];
        double m1 = Double.POSITIVE_INFINITY;
        if (p2.getX() - p1.getX() != 0.0) {
            m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        }
        double m2 = Double.POSITIVE_INFINITY;
        if (p4.getX() - p3.getX() != 0.0) {
            m2 = (p4.getY() - p3.getY()) / (p4.getX() - p3.getX());
        }
        if (m1 == Double.POSITIVE_INFINITY && m2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        double b1 = p2.getY() - m1 * p2.getX();
        double b2 = p4.getY() - m2 * p4.getX();
        if (m1 != Double.POSITIVE_INFINITY && m2 != Double.POSITIVE_INFINITY) {
            if (m1 == m2) {
                return null;
            }
            double x = (b2 - b1) / (m1 - m2);
            return SplitOperationUtils.createPoint(x, m1 * x + b1, subtype);
        }
        if (m1 == Double.POSITIVE_INFINITY) {
            double x = p1.getX();
            return SplitOperationUtils.createPoint(x, m2 * x + b2, subtype);
        }
        if (m2 == Double.POSITIVE_INFINITY) {
            double x = p3.getX();
            return SplitOperationUtils.createPoint(x, m1 * x + b1, subtype);
        }
        return null;
    }

    public static double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static Point getCenterOfCurve(Point p1, Point p2, Point p3, Point p4) throws CreateGeometryException {
        if (!p1.equals(p2) && !p3.equals(p4)) {
            int subtype = p1.getGeometryType().getSubType();
            Point midPointChord1 = SplitOperationUtils.getMidPoint(p1, p2, subtype);
            Point midPointChord2 = SplitOperationUtils.getMidPoint(p3, p4, subtype);
            Double[] bisector1Params = SplitOperationUtils.getLineParams(p1, p2);
            Double[] bisector2Params = SplitOperationUtils.getLineParams(p3, p4);
            Point[] bisector1 = SplitOperationUtils.getPerpendicular(bisector1Params[0], bisector1Params[1], midPointChord1, subtype);
            Point[] bisector2 = SplitOperationUtils.getPerpendicular(bisector2Params[0], bisector2Params[1], midPointChord2, subtype);
            return SplitOperationUtils.getIntersection(bisector1, bisector2, subtype);
        }
        return null;
    }

    public static Point getCenterOfCurve(Point p1, Point p2, Point p3) throws CreateGeometryException {
        if (!p1.equals(p2) && !p2.equals(p3)) {
            int subtype = p1.getGeometryType().getSubType();
            Double[] lineAParams = SplitOperationUtils.getLineParams(p1, p2);
            Double[] lineBParams = SplitOperationUtils.getLineParams(p2, p3);
            double mA = lineAParams[0];
            double mB = lineBParams[0];
            if (mB - mA != 0.0) {
                double x = (mA * mB * (p1.getY() - p3.getY()) + mB * (p1.getX() + p2.getX()) - mA * (p2.getX() + p3.getX())) / (2.0 * (mB - mA));
                Point midPointA = SplitOperationUtils.getMidPoint(p1, p2, subtype);
                Point[] bisectorA = SplitOperationUtils.getPerpendicular(lineAParams[0], lineAParams[1], midPointA, subtype);
                Double[] bisectorAParams = SplitOperationUtils.getLineParams(bisectorA[0], bisectorA[1]);
                double mBisector = bisectorAParams[0];
                double yBisector = bisectorAParams[1];
                double y = x * mBisector + yBisector;
                return SplitOperationUtils.createPoint(x, y, subtype);
            }
        }
        return null;
    }

    public static boolean intersects(Curve curve, Point projectedPoint) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double tolerance = 2.0;
        return curve.buffer(tolerance).intersects((Geometry)projectedPoint);
    }
}

