/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesLocator;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesManager;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesParameters;
import org.gvsig.derivedgeometries.swing.api.exceptions.DerivedGeometriesException;
import org.gvsig.derivedgeometries.swing.api.exceptions.FetaureTableModelException;
import org.gvsig.derivedgeometries.swing.api.panels.FeaturesControlPanel;
import org.gvsig.derivedgeometries.swing.api.tablemodels.DerivedGeometriesSelectionModel;
import org.gvsig.derivedgeometries.swing.impl.views.FeaturesControlPanelView;
import org.gvsig.derivedgeometries.swing.impl.views.SelectedFeaturesTableModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeaturesControlPanel
extends FeaturesControlPanelView
implements FeaturesControlPanel {
    private static final long serialVersionUID = -2215258264697623544L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFeaturesControlPanel.class);
    private List<FeatureReference> features = new ArrayList<FeatureReference>();
    private DerivedGeometriesParameters parameters;

    public DefaultFeaturesControlPanel() {
        this.initAddAllButton();
        this.initRemoveAllButton();
        this.initAddButton();
        this.initRemoveButton();
        this.initMoveUpButton();
        this.initMoveDownButton();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void doAction() {
        this.getParameters().setSelectedFeatures(this.features);
        DerivedGeometriesManager manager = DerivedGeometriesLocator.getManager();
        manager.startDerivedGeometriesProcess(this.parameters);
        this.getSelectedFeaturesTableModel().clear();
        this.features.clear();
    }

    public DerivedGeometriesParameters getParameters() {
        return this.parameters;
    }

    private int[] getSelectedIndexs() {
        if (this.features == null || this.features.size() == 0) {
            return new int[-1];
        }
        return this.getSelectedFeaturesTable().getSelectedRows();
    }

    private boolean hasMoreThanOneGeometry(Feature feature) {
        Geometry geom = feature.getDefaultGeometry();
        return geom instanceof Aggregate && ((Aggregate)geom).getPrimitivesNumber() > 1;
    }

    private void initAddAllButton() {
        this.getAddAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureStore featureStore = DefaultFeaturesControlPanel.this.getParameters().getSourceLayer().getFeatureStore();
                ArrayList<FeatureReference> tmpFeatures = new ArrayList<FeatureReference>();
                boolean showWarningDialog = false;
                DisposableIterator it = null;
                FeatureSet featureSet = null;
                try {
                    featureSet = featureStore.getFeatureSet();
                    it = featureSet.fastIterator();
                }
                catch (DataException ex) {
                    String message = String.format("Error getting feature set or fast iterator of %1", featureStore);
                    LOG.info(message, (Throwable)ex);
                    return;
                }
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    if (DefaultFeaturesControlPanel.this.hasMoreThanOneGeometry(feature) || feature.getDefaultGeometry() == null) {
                        showWarningDialog = true;
                        continue;
                    }
                    tmpFeatures.add(feature.getCopy().getReference());
                }
                it.dispose();
                featureSet.dispose();
                if (showWarningDialog) {
                    DefaultFeaturesControlPanel.this.showWarningDialog();
                }
                DefaultFeaturesControlPanel.this.features = tmpFeatures;
                try {
                    DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().loadData(DefaultFeaturesControlPanel.this.features);
                }
                catch (DerivedGeometriesException ex) {
                    LOG.info("Error loading features", (Throwable)ex);
                }
            }
        });
    }

    private void initAddButton() {
        this.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureStore featureStore = DefaultFeaturesControlPanel.this.getParameters().getSourceLayer().getFeatureStore();
                boolean showWarningDialog = false;
                DerivedGeometriesSelectionModel selectionModel = null;
                try {
                    selectionModel = (DerivedGeometriesSelectionModel)DefaultFeaturesControlPanel.this.getAllFeaturesTable(featureStore).getSelectionModel();
                }
                catch (FetaureTableModelException e1) {
                    e1.printStackTrace();
                }
                if (showWarningDialog) {
                    DefaultFeaturesControlPanel.this.showWarningDialog();
                }
                DefaultFeaturesControlPanel.this.features.addAll(selectionModel.getSelectedFeatures());
                selectionModel.getSelectedFeatures().clear();
                try {
                    DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().loadData(DefaultFeaturesControlPanel.this.features);
                }
                catch (DerivedGeometriesException ex) {
                    LOG.info("Error loading features", (Throwable)ex);
                }
            }
        });
    }

    private void initMoveDownButton() {
        this.getMoveDownButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureReference selected;
                int i;
                int[] currIndexs = DefaultFeaturesControlPanel.this.getSelectedIndexs();
                if (currIndexs.length <= 0 || currIndexs[currIndexs.length - 1] >= DefaultFeaturesControlPanel.this.features.size() - 1) {
                    return;
                }
                ArrayList<FeatureReference> selectedFeatures = new ArrayList<FeatureReference>();
                for (i = 0; i < currIndexs.length; ++i) {
                    selected = null;
                    selected = (FeatureReference)DefaultFeaturesControlPanel.this.features.get(currIndexs[i]);
                    selectedFeatures.add(selected);
                }
                if (!selectedFeatures.isEmpty()) {
                    DefaultFeaturesControlPanel.this.features.removeAll(selectedFeatures);
                    for (i = 0; i < selectedFeatures.size(); ++i) {
                        selected = (FeatureReference)selectedFeatures.get(i);
                        DefaultFeaturesControlPanel.this.features.add(currIndexs[i] + 1, selected);
                    }
                    try {
                        DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().loadData(DefaultFeaturesControlPanel.this.features);
                    }
                    catch (DerivedGeometriesException ex) {
                        LOG.info("Error loading features", (Throwable)ex);
                        return;
                    }
                    for (i = 0; i < currIndexs.length; ++i) {
                        DefaultFeaturesControlPanel.this.getSelectedFeaturesTable().addRowSelectionInterval(currIndexs[i] + 1, currIndexs[i] + 1);
                    }
                }
            }
        });
    }

    private void initMoveUpButton() {
        this.getMoveUpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureReference selected;
                int i;
                int[] currIndexs = DefaultFeaturesControlPanel.this.getSelectedIndexs();
                if (currIndexs.length <= 0 || currIndexs[0] == 0) {
                    return;
                }
                ArrayList<FeatureReference> selectedFeatures = new ArrayList<FeatureReference>();
                for (i = 0; i < currIndexs.length; ++i) {
                    selected = null;
                    try {
                        selected = ((FeatureReference)DefaultFeaturesControlPanel.this.features.get(currIndexs[i])).getFeature().getReference();
                    }
                    catch (DataException ex) {
                        LOG.info("Error getting feature", (Throwable)ex);
                        return;
                    }
                    selectedFeatures.add(selected);
                }
                if (!selectedFeatures.isEmpty()) {
                    DefaultFeaturesControlPanel.this.features.removeAll(selectedFeatures);
                    for (i = 0; i < selectedFeatures.size(); ++i) {
                        selected = (FeatureReference)selectedFeatures.get(i);
                        DefaultFeaturesControlPanel.this.features.add(currIndexs[i] - 1, selected);
                    }
                    try {
                        DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().loadData(DefaultFeaturesControlPanel.this.features);
                    }
                    catch (DerivedGeometriesException ex) {
                        LOG.info("Error loading features", (Throwable)ex);
                        return;
                    }
                    for (i = 0; i < currIndexs.length; ++i) {
                        DefaultFeaturesControlPanel.this.getSelectedFeaturesTable().addRowSelectionInterval(currIndexs[i] - 1, currIndexs[i] - 1);
                    }
                }
            }
        });
    }

    private void initRemoveAllButton() {
        this.getRemoveAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DefaultFeaturesControlPanel.this.features.isEmpty()) {
                    DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().clear();
                    DefaultFeaturesControlPanel.this.features.clear();
                }
            }
        });
    }

    private void initRemoveButton() {
        this.getRemoveButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = DefaultFeaturesControlPanel.this.getSelectedFeaturesTable().getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    DefaultFeaturesControlPanel.this.features.remove(selectedRows[i]);
                }
                try {
                    DefaultFeaturesControlPanel.this.getSelectedFeaturesTableModel().loadData(DefaultFeaturesControlPanel.this.features);
                }
                catch (DerivedGeometriesException ex) {
                    LOG.info("Error loading features", (Throwable)ex);
                    return;
                }
            }
        });
    }

    private void initSelectionListener() {
        ListSelectionModel selectionModel = this.getSelectedFeaturesTable().getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FeatureStore featureStore = DefaultFeaturesControlPanel.this.getParameters().getSourceLayer().getFeatureStore();
                try {
                    FeatureSelection selection = (FeatureSelection)featureStore.getSelection();
                    selection.deselectAll();
                    int[] selectedRows = DefaultFeaturesControlPanel.this.getSelectedIndexs();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        selection.select((FeatureReference)DefaultFeaturesControlPanel.this.features.get(selectedRows[i]));
                    }
                }
                catch (DataException ex) {
                    LOG.info("Error selecting features", (Throwable)ex);
                    return;
                }
            }
        });
    }

    private void refreshDataView(DerivedGeometriesParameters parameters) {
        this.getSourceLayerNameTextField().setText(parameters.getSourceLayer().getName());
        this.getOutputLayerNameTextField().setText(parameters.getOutPutLayerName());
        FeatureStore featureStore = parameters.getSourceLayer().getFeatureStore();
        try {
            this.getAllFeaturesScrollPane().setViewportView((Component)this.getAllFeaturesTable(featureStore));
        }
        catch (DerivedGeometriesException e) {
            LOG.info("Error getting feature table", (Throwable)e);
            return;
        }
        this.getSelectedFeaturesTable().setModel(new SelectedFeaturesTableModel(featureStore));
        this.getSelectedFeaturesScrollPane().setViewportView(this.getSelectedFeaturesTable());
    }

    public void setParameters(DerivedGeometriesParameters theParameters) {
        this.parameters = theParameters;
        this.refreshDataView(this.parameters);
        this.initSelectionListener();
    }

    private void showWarningDialog() {
        String title = "_warning_adding_features";
        String message = "_warning_there_are_features_with_more_than_one_geometry_or_without_geometry";
        ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
        dlgManager.messageDialog(message, title, 2);
    }

    public boolean validateFields() {
        return !this.features.isEmpty();
    }
}

