/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.views;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.derivedgeometries.swing.api.tablemodels.DerivedGeometriesSelectionModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.SelectionChangeException;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.tools.dispose.DisposableIterator;

public class DefaultDerivedGeometriesSelectionModel
implements DerivedGeometriesSelectionModel {
    protected EventListenerList listenerList = new EventListenerList();
    List<FeatureReference> selectedFeatures = new ArrayList<FeatureReference>();
    FeatureTableModel featureTableModel;
    private int selectionMode = 1;
    private boolean isAdjusting = false;
    private int anchor = -1;
    private int lead = -1;
    private int currentFirst = -1;
    private int currentLast = -1;

    public DefaultDerivedGeometriesSelectionModel(FeatureTableModel theFeatureTableModel) {
        this.featureTableModel = theFeatureTableModel;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void addSelectionInterval(int index0, int index1) {
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                for (int i = first; i <= last; ++i) {
                    Feature feature = DefaultDerivedGeometriesSelectionModel.this.getFeature(i);
                    if (selection.isSelected(feature)) continue;
                    selection.select(feature);
                    for (int j = 0; j < DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.size(); ++j) {
                        int index = DefaultDerivedGeometriesSelectionModel.this.getIndexOfFeatureReference(DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.get(j));
                        if (i >= index) continue;
                        DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.add(j, feature.getReference());
                        return;
                    }
                    DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.add(feature.getReference());
                }
            }
        }, index0, index1, true);
    }

    public void clearSelection() {
        try {
            this.getFeatureSelection().deselectAll();
        }
        catch (DataException e) {
            throw new SelectionChangeException((Throwable)e);
        }
        this.selectedFeatures.clear();
    }

    public int getAnchorSelectionIndex() {
        return this.anchor;
    }

    private void doWithSelection(FeatureSelectionOperation operation, int index0, int index1, boolean select) {
        int last;
        this.anchor = index0;
        this.lead = index1;
        int first = index0 <= index1 ? index0 : index1;
        int n = last = index0 <= index1 ? index1 : index0;
        if (this.currentFirst == first && this.currentLast == last) {
            return;
        }
        this.currentFirst = first;
        this.currentLast = last;
        FeatureSelection selection = this.getFeatureSelection();
        selection.beginComplexNotification();
        try {
            if (first == 0 && last == this.featureTableModel.getRowCount() - 1) {
                if (!select) {
                    selection.deselectAll();
                    this.selectedFeatures.clear();
                } else {
                    operation.doWithSelection(selection, first, last);
                }
            } else {
                operation.doWithSelection(selection, first, last);
            }
        }
        catch (DataException e) {
            throw new SelectionChangeException((Throwable)e);
        }
        finally {
            selection.endComplexNotification();
        }
        this.fireValueChanged(first, last, this.isAdjusting);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    private Feature getFeature(int index) {
        return this.featureTableModel.getFeatureAt(index);
    }

    private FeatureSelection getFeatureSelection() {
        try {
            return (FeatureSelection)this.getFeatureStore().getSelection();
        }
        catch (DataException ex) {
            throw new SelectionChangeException((Throwable)ex);
        }
    }

    private FeatureStore getFeatureStore() {
        return this.featureTableModel.getFeatureStore();
    }

    private int getIndexOfFeatureReference(FeatureReference featureReference) {
        for (int i = 0; i < this.featureTableModel.getRowCount(); ++i) {
            Feature tmpFeature = this.featureTableModel.getFeatureAt(i);
            FeatureReference tmpFeatureReference = tmpFeature.getReference();
            if (!featureReference.equals(tmpFeatureReference)) continue;
            return i;
        }
        return -1;
    }

    public int getLeadSelectionIndex() {
        return this.lead;
    }

    public int getMaxSelectionIndex() {
        int resp = this.getSelectionIndex(true);
        return resp;
    }

    public int getMinSelectionIndex() {
        int resp = this.getSelectionIndex(false);
        return resp;
    }

    private int getSelectionIndex(boolean last) {
        int resp;
        block8: {
            int ind = -1;
            resp = -1;
            FeatureSet fs = null;
            DisposableIterator diter = null;
            try {
                FeatureSelection selection = this.getFeatureSelection();
                if (selection.isEmpty()) break block8;
                fs = this.getFeatureStore().getFeatureSet();
                diter = fs.fastIterator();
                Feature feat = null;
                while (diter.hasNext()) {
                    ++ind;
                    feat = (Feature)diter.next();
                    if (!selection.isSelected(feat)) continue;
                    resp = ind;
                    if (last) continue;
                    break;
                }
            }
            catch (DataException e) {
                throw new SelectionChangeException((Throwable)e);
            }
            finally {
                if (diter != null) {
                    diter.dispose();
                }
                if (fs != null) {
                    fs.dispose();
                }
            }
        }
        return resp;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void insertIndexInterval(int index, int length, boolean before) {
    }

    public boolean isSelectedIndex(int index) {
        if (index == -1) {
            return false;
        }
        Feature feature = this.featureTableModel.getFeatureAt(index);
        return this.getFeatureSelection().isSelected(feature);
    }

    public boolean isSelectionEmpty() {
        try {
            return this.getFeatureSelection().isEmpty();
        }
        catch (Exception ex) {
            throw new SelectionChangeException((Throwable)ex);
        }
    }

    public void removeIndexInterval(int index0, int index1) {
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                for (int i = first; i <= last; ++i) {
                    Feature feature = DefaultDerivedGeometriesSelectionModel.this.getFeature(i);
                    if (!selection.isSelected(feature)) continue;
                    selection.deselect(feature);
                    DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.remove(feature.getReference());
                }
            }
        }, index0, index1, false);
    }

    public void setAnchorSelectionIndex(int index) {
        this.anchor = index;
    }

    public void setLeadSelectionIndex(int index) {
        this.lead = index;
    }

    public void setSelectionInterval(int index0, int index1) {
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                selection.deselectAll();
                DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.clear();
                for (int i = first; i <= last; ++i) {
                    Feature feature = DefaultDerivedGeometriesSelectionModel.this.getFeature(i);
                    selection.select(feature);
                    DefaultDerivedGeometriesSelectionModel.this.selectedFeatures.add(feature.getReference());
                }
            }
        }, index0, index1, true);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (this.isAdjusting != valueIsAdjusting) {
            this.isAdjusting = valueIsAdjusting;
            if (this.isAdjusting) {
                this.getFeatureSelection().beginComplexNotification();
            } else {
                this.getFeatureSelection().endComplexNotification();
            }
        }
    }

    public List<FeatureReference> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public void setSelectedFeatures(List<FeatureReference> list) {
        this.selectedFeatures = list;
    }

    private static interface FeatureSelectionOperation {
        public void doWithSelection(FeatureSelection var1, int var2, int var3) throws DataException;
    }
}

