/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesLocator;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesManager;
import org.gvsig.derivedgeometries.swing.api.panels.FeaturesControlPanel;
import org.gvsig.derivedgeometries.swing.api.panels.LayerAndProcessSelectionPanel;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class DerivedGeometriesPanelView
extends JPanel {
    private static final long serialVersionUID = -5574613054191988321L;
    private LayerAndProcessSelectionPanel layerAndProcessSelectionPanel;
    private FeaturesControlPanel featuresControlPanel;
    private JPanel buttonsPanel;
    private JButton nextButton;
    private JButton cancelButton;

    public DerivedGeometriesPanelView(MapControl theMapControl) {
        DerivedGeometriesManager manager = DerivedGeometriesLocator.getManager();
        this.layerAndProcessSelectionPanel = manager.getLayerAndProcessSelectionPanel(theMapControl);
        this.featuresControlPanel = manager.getFeaturesControlPanel();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layerAndProcessSelectionPanel.asJComponent(), "First");
        this.add((Component)this.featuresControlPanel.asJComponent(), "Center");
        this.featuresControlPanel.asJComponent().setVisible(false);
        this.add((Component)this.getButtonsPanel(), "Last");
    }

    @Override
    public Dimension getPreferredSize() {
        JComponent c1 = this.layerAndProcessSelectionPanel.asJComponent();
        JComponent c2 = this.featuresControlPanel.asJComponent();
        int with = (int)Math.max(c1.getPreferredSize().getWidth(), c2.getPreferredSize().getWidth());
        int height = (int)Math.max(c1.getPreferredSize().getHeight(), c2.getPreferredSize().getHeight());
        return new Dimension(with, height);
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new FlowLayout(2));
            this.buttonsPanel.add(this.getNextButton());
            this.buttonsPanel.add(this.getCancelButton());
        }
        return this.buttonsPanel;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.cancelButton = new JButton(i18nManager.getTranslation("_cancel"));
        }
        return this.cancelButton;
    }

    protected JButton getNextButton() {
        if (this.nextButton == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.nextButton = new JButton(i18nManager.getTranslation("_next") + " >");
        }
        return this.nextButton;
    }

    protected LayerAndProcessSelectionPanel getLayerAndProcessSelectionPanel() {
        return this.layerAndProcessSelectionPanel;
    }

    protected FeaturesControlPanel getFeaturesControlPanel() {
        return this.featuresControlPanel;
    }
}

