/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.SymbolTableFactory;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ElementFactory;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionBuilderConfig
implements ExpressionBuilderConfig,
ExpressionBuilderConfig.Preferences,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpressionBuilderConfig.class);
    private List<Element> elements;
    private List<Element> addElements;
    private int limit;
    private Map<String, SymbolTable> symbolTables;
    private final ExpressionEvaluatorSwingManager manager;
    private SymbolTable previewSymbolTable;
    private boolean SQLCompatible;
    private final PropertiesSupportHelper propertiesSupportHelper;
    private boolean showLabelsOfAttributes;
    private boolean allowAggregates;
    private Function<String, Integer> allowedFunctions;
    private Map<String, Factory> suggestionFactories;
    private History history;
    private Bookmarks bookmarks;

    public DefaultExpressionBuilderConfig(ExpressionEvaluatorSwingManager manager) {
        this.manager = manager;
        this.limit = 6;
        this.SQLCompatible = false;
        this.propertiesSupportHelper = new PropertiesSupportHelper();
        this.showLabelsOfAttributes = true;
        this.allowAggregates = false;
        this.suggestionFactories = new HashMap<String, Factory>();
        this.initSymbolTables();
    }

    public ExpressionBuilderConfig.Preferences getPreferences() {
        return this;
    }

    public Collection<Factory> getSuggestionFactories() {
        return this.suggestionFactories.values();
    }

    public Function<String, Integer> getAllowedFunctions() {
        return this.allowedFunctions;
    }

    private void initSymbolTables() {
        ExpressionEvaluatorManager theManager = ExpressionEvaluatorLocator.getManager();
        for (SymbolTableFactory factory : theManager.getSymbolTableFactories()) {
            if (factory == null) continue;
            String factoryName = "(unknown)";
            try {
                factoryName = factory.getName();
                if (!factory.isAutoload()) continue;
                this.addSymbolTable(factory.create(new Object[0]));
            }
            catch (Throwable th) {
                LOGGER.warn("Can't create symbol table '" + factoryName + "'.", th);
            }
        }
    }

    public synchronized List<Element> getElements() {
        if (this.elements == null || this.elements.isEmpty()) {
            this.elements = this.manager.createElements(this.getSymbolTables(), f -> {
                if (f.group().equalsIgnoreCase("Aggregate") && !this.allowAggregates()) {
                    return false;
                }
                Function<String, Integer> isFunctionAllowed = this.isFunctionAllowed();
                return isFunctionAllowed == null || isFunctionAllowed.apply(f.name()) != 2;
            });
            for (ElementFactory factory : this.manager.getElementFactories()) {
                if (!factory.isAutoload()) continue;
                Element e = factory.createElement(new Object[0]);
                this.elements.add(e);
                e.setConfig((ExpressionBuilderConfig)this);
            }
            if (this.addElements != null) {
                for (Element element : this.addElements) {
                    this.elements.add(element);
                }
            }
        }
        return Collections.unmodifiableList(this.elements);
    }

    public synchronized void addElement(Element element) {
        if (element == null) {
            return;
        }
        this.getElements();
        for (Element theElement : this.elements) {
            if (!theElement.getName().equalsIgnoreCase(element.getName())) continue;
            return;
        }
        this.elements.add(element);
        if (this.addElements == null) {
            this.addElements = new ArrayList<Element>();
        }
        this.addElements.add(element);
        element.setConfig((ExpressionBuilderConfig)this);
    }

    public synchronized void removeElement(String elementName) {
        Element theElement;
        Iterator<Element> iterator;
        if (StringUtils.isBlank((CharSequence)elementName)) {
            return;
        }
        if (this.addElements != null) {
            iterator = this.addElements.iterator();
            while (iterator.hasNext()) {
                theElement = iterator.next();
                if (!theElement.getName().equalsIgnoreCase(elementName)) continue;
                iterator.remove();
            }
        }
        this.getElements();
        if (this.elements != null) {
            iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                theElement = iterator.next();
                if (!theElement.getName().equalsIgnoreCase(elementName)) continue;
                iterator.remove();
                break;
            }
        }
    }

    public Collection<SymbolTable> getSymbolTables() {
        if (this.symbolTables == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.symbolTables.values());
    }

    public void addSymbolTable(String name) {
        ExpressionEvaluatorManager theManager = ExpressionEvaluatorLocator.getManager();
        SymbolTable symbolTable = theManager.getSymbolTable(name);
        if (symbolTable == null) {
            throw new IllegalArgumentException("Can't locate symbol table '" + name + "'.");
        }
        this.addSymbolTable(symbolTable);
    }

    public synchronized void addSymbolTable(SymbolTable symbolTable) {
        if (symbolTable == null) {
            return;
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            LOGGER.warn("Added a symbol table after the elements are build.");
            for (Element element : this.elements) {
                DisposeUtils.disposeQuietly((Disposable)element);
            }
            this.elements.clear();
        }
        if (this.symbolTables == null) {
            this.symbolTables = new HashMap<String, SymbolTable>();
        }
        this.symbolTables.put(symbolTable.getName(), symbolTable);
    }

    public void removeAllSymbolTables() {
        if (this.symbolTables != null) {
            this.symbolTables.clear();
        }
    }

    public synchronized void removeAllElements() {
        if (this.elements != null) {
            for (Element element : this.elements) {
                DisposeUtils.disposeQuietly((Disposable)element);
            }
            this.elements.clear();
        }
    }

    public synchronized void removeAddedElements() {
        if (this.addElements != null) {
            for (Element element : this.addElements) {
                DisposeUtils.disposeQuietly((Disposable)element);
            }
            this.addElements.clear();
        }
    }

    public int getSimpleElementsLimit() {
        return this.limit;
    }

    public void setSimpleElementsLimit(int limit) {
        this.limit = limit;
    }

    public void removeSymbolTable(String name) {
        if (this.symbolTables != null) {
            this.symbolTables.remove(name);
        }
    }

    public SymbolTable getPreviewSymbolTable() {
        return this.previewSymbolTable;
    }

    public void setPreviewSymbolTable(SymbolTable symbolTable) {
        this.previewSymbolTable = symbolTable;
    }

    public void addPreviewSymbolTable(SymbolTable symbolTable) {
        if (symbolTable == null) {
            return;
        }
        if (this.previewSymbolTable == null) {
            this.previewSymbolTable = symbolTable;
            return;
        }
        this.previewSymbolTable.addSymbolTable(symbolTable);
    }

    public void setSQLCompatible(boolean SQLCompatible) {
        this.SQLCompatible = SQLCompatible;
    }

    public boolean isSQLCompatible() {
        return this.SQLCompatible;
    }

    public Object getProperty(String string) {
        return this.propertiesSupportHelper.getProperty(string);
    }

    public void setProperty(String string, Object o) {
        this.propertiesSupportHelper.setProperty(string, o);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesSupportHelper.getProperties();
    }

    public boolean getShowLabelsOfElements() {
        return this.showLabelsOfAttributes;
    }

    public void setShowLabelsOfElements(boolean showLabels) {
        this.showLabelsOfAttributes = showLabels;
    }

    public boolean allowAggregates() {
        return this.allowAggregates;
    }

    public boolean allowAggregates(boolean allow) {
        boolean r = this.allowAggregates;
        this.allowAggregates = allow;
        return r;
    }

    public Function<String, Integer> isFunctionAllowed() {
        return this.allowedFunctions;
    }

    public void setAllowedFunctions(Function<String, Integer> allow) {
        this.allowedFunctions = allow;
    }

    public synchronized String getSuggestion(Expression expression) {
        if (expression == null) {
            return null;
        }
        String text = expression.getPhrase();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        boolean needseparator = false;
        StringBuilder builder = null;
        for (Factory factory : this.suggestionFactories.values()) {
            SuggestionProvider provider = (SuggestionProvider)factory.create(new Object[0]);
            String suggestion = provider.getSuggestion(text);
            if (suggestion == null) continue;
            if (builder == null) {
                builder = new StringBuilder();
                builder.append(suggestion);
                continue;
            }
            builder.append("\n\n");
            builder.append(suggestion);
        }
        if (builder != null) {
            return builder.toString();
        }
        return null;
    }

    public synchronized void addSuggestionFactory(Factory factory) {
        if (factory == null) {
            return;
        }
        this.suggestionFactories.put(factory.getName(), factory);
    }

    public synchronized void dispose() {
        this.removeAllElements();
        this.removeAllSymbolTables();
        if (this.addElements != null) {
            for (Element element : this.addElements) {
                DisposeUtils.disposeQuietly((Disposable)element);
            }
            this.addElements.clear();
        }
    }

    public List<Element> getAddedElements() {
        return this.addElements;
    }

    public ExpressionBuilderConfig cloneConfig() {
        try {
            return (ExpressionBuilderConfig)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        DefaultExpressionBuilderConfig other = (DefaultExpressionBuilderConfig)super.clone();
        other.symbolTables = new HashMap<String, SymbolTable>();
        other.elements = new ArrayList<Element>();
        other.addElements = new ArrayList<Element>();
        other.suggestionFactories = new HashMap<String, Factory>();
        if (this.symbolTables != null) {
            for (SymbolTable symbolTable : this.symbolTables.values()) {
                other.addSymbolTable(symbolTable);
            }
        }
        if (this.addElements != null) {
            for (Element element : this.addElements) {
                other.addElements.add(element.cloneElement());
            }
        }
        if (this.suggestionFactories != null) {
            for (Factory suggestionFactory : this.suggestionFactories.values()) {
                other.addSuggestionFactory(suggestionFactory);
            }
        }
        return other;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        if (this.history == null) {
            this.history = ExpressionEvaluatorLocator.getManager().getHistory();
        }
        return this.history;
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
        SymbolTable symbolTable = ExpressionUtils.createBookmarksSymbolTable((String)bookmarks.getGroupName());
        this.addSymbolTable(symbolTable);
    }

    public Bookmarks getBookmarks() {
        if (this.bookmarks == null) {
            this.bookmarks = ExpressionEvaluatorLocator.getManager().getBookmarks();
        }
        return this.bookmarks;
    }
}

