/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.CalculatorController;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ElementFactory;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.FunctionAdditionalPanelFactory;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.JExpressionPicker;
import org.gvsig.expressionevaluator.swing.JScriptEditor;
import org.gvsig.expressionevaluator.swing.JTextComponentProxy;
import org.gvsig.expressionevaluator.swing.impl.DefaultCalculatorController;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionPickerController;
import org.gvsig.expressionevaluator.swing.impl.DefaultJExpressionBuilder;
import org.gvsig.expressionevaluator.swing.impl.DefaultJExpressionBuilderView2;
import org.gvsig.expressionevaluator.swing.impl.DefaultJExpressionBuilderView3;
import org.gvsig.expressionevaluator.swing.impl.DefaultJExpressionPicker;
import org.gvsig.expressionevaluator.swing.impl.JScriptEditorImpl;
import org.gvsig.expressionevaluator.swing.impl.elements.DefaultAggregateElements;
import org.gvsig.expressionevaluator.swing.impl.elements.DefaultConstantValueElement;
import org.gvsig.expressionevaluator.swing.impl.elements.DefaultFunctionElement;
import org.gvsig.expressionevaluator.swing.impl.elements.DefaultGroupElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class DefaultExpressionEvaluatorSwingManager
implements ExpressionEvaluatorSwingManager {
    private final Map<String, ElementFactory> elementsFactories = new HashMap<String, ElementFactory>();
    private final Map<String, FunctionAdditionalPanelFactory> functionAdditionalPanelFactories = new HashMap<String, FunctionAdditionalPanelFactory>();

    public List<Element> createElements(Collection<SymbolTable> symbolTables, Predicate<Function> isAllowed) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        HashMap<String, Object> functions = new HashMap<String, Object>();
        for (SymbolTable symbolTable : symbolTables) {
            for (Object function : symbolTable.functions()) {
                if (function.isHidden() || isAllowed == null || !isAllowed.test((Function)function)) continue;
                functions.put(function.name().toUpperCase(), function);
            }
        }
        HashMap<String, Element.GroupElement> functionGroups = new HashMap<String, Element.GroupElement>();
        HashMap<String, Element.GroupElement> operatorGroups = new HashMap<String, Element.GroupElement>();
        for (Object function : functions.values()) {
            Element.GroupElement group;
            String groupName;
            if (function.isOperator()) {
                groupName = function.group();
                group = (Element.GroupElement)operatorGroups.get(groupName);
                if (group == null) {
                    group = new DefaultGroupElement(groupName);
                    operatorGroups.put(groupName, group);
                }
                group.addElement((Element)new DefaultFunctionElement((Function)function));
                continue;
            }
            groupName = function.group();
            group = (Element.GroupElement)functionGroups.get(groupName);
            if (group == null) {
                group = new DefaultGroupElement(groupName);
                functionGroups.put(groupName, group);
            }
            group.addElement((Element)new DefaultFunctionElement((Function)function));
        }
        DefaultAggregateElements builtinFunctions = new DefaultAggregateElements(this, i18n.getTranslation("_Functions"));
        for (Object group : functionGroups.values()) {
            builtinFunctions.addElement((Element)group);
        }
        DefaultAggregateElements operatorFunctions = new DefaultAggregateElements(this, i18n.getTranslation("_Operators"));
        for (Element.GroupElement group : operatorGroups.values()) {
            operatorFunctions.addElement((Element)group);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add((Element)operatorFunctions);
        elements.add((Element)builtinFunctions);
        return elements;
    }

    public void registerElement(ElementFactory factory) {
        this.elementsFactories.put(factory.getName().toLowerCase(), factory);
    }

    public Collection<ElementFactory> getElementFactories() {
        ArrayList<ElementFactory> factories = new ArrayList<ElementFactory>();
        factories.addAll(this.elementsFactories.values());
        Collections.sort(factories, new Comparator<ElementFactory>(){

            @Override
            public int compare(ElementFactory o1, ElementFactory o2) {
                return StringUtils.compare((String)o1.getName(), (String)o2.getName());
            }
        });
        return factories;
    }

    public Action createJExpressionBuilderAction(JTextComponent jtext) {
        CreateJExpressionBuilderAction action = new CreateJExpressionBuilderAction(jtext);
        return action;
    }

    public Action createUniqueTemporalFileAction(JTextComponent jtext, String filename, String fileExtension) {
        return this.createUniqueTemporalFileAction(jtext, (Pair<String, String>)new ImmutablePair((Object)filename, (Object)fileExtension));
    }

    public Action createUniqueTemporalFileAction(final JTextComponent jtext, final Pair<String, String> nameAndExtension) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        AbstractAction uniqueTemporalFileAction = new AbstractAction(i18nManager.getTranslation("_Temporal_file_path")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileExtension = (String)nameAndExtension.getRight();
                if (!StringUtils.startsWith((CharSequence)fileExtension, (CharSequence)".")) {
                    fileExtension = "." + fileExtension;
                }
                if (jtext.isEditable() && jtext.isEnabled()) {
                    jtext.setText("<%=UNIQUETEMPORARYFILE('" + (String)nameAndExtension.getLeft() + fileExtension + "')%>");
                }
            }
        };
        return uniqueTemporalFileAction;
    }

    public JExpressionBuilder createJExpressionBuilder(ExpressionBuilderConfig config) {
        DefaultJExpressionBuilder x = new DefaultJExpressionBuilder(this, config, new DefaultJExpressionBuilderView2(){

            @Override
            public ImageIcon loadImage(String imageName) {
                return DefaultExpressionEvaluatorSwingManager.this.loadImageFromIconTheme(imageName);
            }
        });
        return x;
    }

    public JExpressionBuilder createJExpressionBuilder() {
        DefaultJExpressionBuilder x = new DefaultJExpressionBuilder(this, new DefaultExpressionBuilderConfig(this), new DefaultJExpressionBuilderView2(){

            @Override
            public ImageIcon loadImage(String imageName) {
                return DefaultExpressionEvaluatorSwingManager.this.loadImageFromIconTheme(imageName);
            }
        });
        return x;
    }

    public JExpressionBuilder createJExpressionBuilderAssistant(JTextComponent expression) {
        return this.createJExpressionBuilderAssistant(() -> expression);
    }

    public JExpressionBuilder createJExpressionBuilderAssistant(JTextComponentProxy expression) {
        DefaultJExpressionBuilder x = new DefaultJExpressionBuilder(this, new DefaultExpressionBuilderConfig(this), new DefaultJExpressionBuilderView3(expression){

            @Override
            public ImageIcon loadImage(String imageName) {
                return DefaultExpressionEvaluatorSwingManager.this.loadImageFromIconTheme(imageName);
            }
        });
        return x;
    }

    public ImageIcon loadImageFromIconTheme(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource(name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public Element createElement(String name, Object ... parameters) {
        ElementFactory factory = this.elementsFactories.get(name.toLowerCase());
        if (factory == null) {
            throw new RuntimeException("Can't locate element factory '" + name + "'.");
        }
        return factory.createElement(parameters);
    }

    public Element.GroupElement createGroupElement(String name) {
        DefaultGroupElement e = new DefaultGroupElement(name);
        return e;
    }

    public Element.GroupElement createGroupElement(String name, List<Element> elements) {
        DefaultGroupElement e = new DefaultGroupElement(this, name, elements);
        return e;
    }

    public Element.FunctionElement createFunctionElement(Function function) {
        DefaultFunctionElement e = new DefaultFunctionElement(function);
        return e;
    }

    public Element.ConstantElement createConstantElement(Object value, String label) {
        DefaultConstantValueElement e = new DefaultConstantValueElement(value, label, null);
        return e;
    }

    public Element.ConstantElement createConstantElement(Object value, String label, String description) {
        DefaultConstantValueElement e = new DefaultConstantValueElement(value, (String)StringUtils.defaultIfEmpty((CharSequence)label, (CharSequence)""), description);
        return e;
    }

    public ExpressionPickerController createExpressionPickerController(JTextComponent text, JButton button) {
        DefaultExpressionPickerController c = new DefaultExpressionPickerController(this, text, button, null, null);
        return c;
    }

    public ExpressionPickerController createExpressionPickerController(JTextComponent text, JButton button, JButton bookmarks, JButton history) {
        DefaultExpressionPickerController c = new DefaultExpressionPickerController(this, text, button, bookmarks, history);
        return c;
    }

    public ExpressionPickerController createExpressionPickerController(JComboBox combo, JButton button, JButton bookmarks, JButton history) {
        DefaultExpressionPickerController c = new DefaultExpressionPickerController(this, combo, button, bookmarks, history);
        return c;
    }

    public JExpressionPicker createJExpressionPicker() {
        DefaultJExpressionPicker x = new DefaultJExpressionPicker(this);
        return x;
    }

    public CalculatorController createCalculatorController(JTextComponent text, int dataType) {
        DefaultCalculatorController controller = new DefaultCalculatorController(this, text, dataType);
        return controller;
    }

    public void registerAdditionalPanel(FunctionAdditionalPanelFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        this.functionAdditionalPanelFactories.put(factory.getName().toUpperCase(), factory);
    }

    public Collection<FunctionAdditionalPanelFactory> getFunctionAdditionalPanelFactories() {
        return this.functionAdditionalPanelFactories.values();
    }

    public FunctionAdditionalPanelFactory getFunctionAdditionalPanelFactory(String functionName) {
        FunctionAdditionalPanelFactory factory = this.functionAdditionalPanelFactories.get(functionName.toUpperCase());
        return factory;
    }

    public JScriptEditor createJScriptEditor(Script script) {
        JScriptEditorImpl editor = new JScriptEditorImpl(script);
        return editor;
    }

    private static class CreateJExpressionBuilderAction
    extends AbstractAction {
        private JTextComponent jtext;

        public CreateJExpressionBuilderAction(JTextComponent jtext) {
            this.jtext = jtext;
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("ActionCommandKey", "CreateJExpressionBuilderAction");
            this.putValue("Name", i18n.getTranslation("_Show_expression_builder"));
            this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("picker-expression"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            final JExpressionBuilder panel = ExpressionEvaluatorSwingLocator.getManager().createJExpressionBuilder();
            final Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Expression_builder"), null, 3);
            dialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (dialog.getAction() == 1) {
                        if (ExpressionUtils.isDynamicText((String)jtext.getText())) {
                            jtext.replaceSelection(panel.getExpression().getPhrase());
                        } else {
                            jtext.replaceSelection(ExpressionUtils.surroundByDynamicTextTag((String)panel.getExpression().getPhrase(), (boolean)true));
                        }
                    }
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
    }
}

