/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.table.gui.GeneralTablePropertiesPageFactory;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.dynobject.DynObject;

public class TableProperties
extends Extension {
    public void initialize() {
        PropertiesPageManager propertiesPageManager = MapControlLocator.getPropertiesPageManager();
        propertiesPageManager.registerFactory((PropertiesPageFactory)new GeneralTablePropertiesPageFactory());
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        if ("table-show-properties".equalsIgnoreCase(actionCommand)) {
            Document doc = application.getActiveDocument(TableManager.TYPENAME);
            if (doc == null) {
                return;
            }
            ProjectManager projectmanager = ApplicationLocator.getProjectManager();
            DocumentManager tableManager = projectmanager.getDocumentManager(TableManager.TYPENAME);
            IWindow win = tableManager.getPropertiesWindow(doc);
            application.getUIManager().addWindow(win);
        } else if ("table-edit-openparameters".equalsIgnoreCase(actionCommand)) {
            TableDocument tabledoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
            if (tabledoc == null) {
                return;
            }
            FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)((Object)tabledoc.getMainComponent());
            FeatureStore featureStore = tablePanel.getFeatureStore();
            this.editOpenParameters(featureStore);
        }
    }

    public void editOpenParameters(FeatureStore store) {
        try {
            DataStoreParameters parameters = store.getParameters();
            DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
            DataStoreParametersPanel panel = manager.createDataStoreParametersPanel((DynObject)parameters);
            panel.setExcludeGeometryOptions(true);
            manager.showPropertiesDialog((DynObject)parameters, panel);
        }
        catch (Exception ex) {
            logger.info("Can't edit open parameters for layer", (Throwable)ex);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        Document doc = application.getActiveDocument(TableManager.TYPENAME);
        return doc != null;
    }
}

