/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.table.MyFileFilter;
import org.gvsig.app.project.documents.table.gui.CSVSeparatorOptionsPanel;
import org.gvsig.app.project.documents.table.gui.Statistics;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportStatisticsFile {
    private static final Logger logger = LoggerFactory.getLogger(ExportStatisticsFile.class);
    private String lastPath = null;
    private Hashtable<String, MyFileFilter> dbfExtensionsSupported;
    private Hashtable<String, MyFileFilter> csvExtensionsSupported;

    public ExportStatisticsFile(List<Statistics.MyObjectStatistics> valores) {
        JFileChooser jfc = new JFileChooser(this.lastPath);
        jfc.removeChoosableFileFilter(jfc.getAcceptAllFileFilter());
        this.dbfExtensionsSupported = new Hashtable();
        this.csvExtensionsSupported = new Hashtable();
        this.dbfExtensionsSupported.put("dbf", new MyFileFilter("dbf", PluginServices.getText((Object)this, (String)"Ficheros_dbf"), "dbf"));
        this.csvExtensionsSupported.put("csv", new MyFileFilter("csv", PluginServices.getText((Object)this, (String)"Ficheros_csv"), "csv"));
        Iterator<MyFileFilter> iter = this.csvExtensionsSupported.values().iterator();
        while (iter.hasNext()) {
            jfc.addChoosableFileFilter(iter.next());
        }
        iter = this.dbfExtensionsSupported.values().iterator();
        while (iter.hasNext()) {
            jfc.addChoosableFileFilter(iter.next());
        }
        if (jfc.showSaveDialog((Component)PluginServices.getMainFrame()) == 0) {
            int resp;
            File endFile = jfc.getSelectedFile();
            if (endFile.exists() && (resp = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"fichero_ya_existe_seguro_desea_guardarlo") + "\n" + endFile.getAbsolutePath(), PluginServices.getText((Object)this, (String)"guardar"), 0)) != 0) {
                return;
            }
            MyFileFilter filter = (MyFileFilter)jfc.getFileFilter();
            if (filter.getExtensionOfAFile(endFile = filter.normalizeExtension(endFile)).toLowerCase().compareTo("csv") == 0) {
                this.exportToCSVFile(valores, endFile);
            } else if (filter.getExtensionOfAFile(endFile).toLowerCase().compareTo("dbf") == 0) {
                try {
                    this.exportToDBFFile(valores, endFile);
                }
                catch (Exception e) {
                    NotificationManager.addError((Throwable)e);
                }
            }
        }
    }

    private void exportToCSVFile(List<Statistics.MyObjectStatistics> valores, File endFile) {
        try {
            FileWriter fileCSV;
            CSVSeparatorOptionsPanel csvSeparatorOptions = new CSVSeparatorOptionsPanel();
            PluginServices.getMDIManager().addWindow((IWindow)csvSeparatorOptions);
            String separator = csvSeparatorOptions.getSeparator();
            if (separator != null) {
                fileCSV = new FileWriter(endFile);
                fileCSV.write(PluginServices.getText((Object)this, (String)"Nombre") + separator + PluginServices.getText((Object)this, (String)"Valor") + "\n");
                ListIterator<Statistics.MyObjectStatistics> iterador = valores.listIterator();
                while (iterador.hasNext()) {
                    Statistics.MyObjectStatistics data = (Statistics.MyObjectStatistics)iterador.next();
                    fileCSV.write(data.getKey() + separator + data.getValue() + "\n");
                }
            } else {
                return;
            }
            fileCSV.close();
            JOptionPane.showMessageDialog(null, PluginServices.getText((Object)this, (String)"fichero_creado_en") + " " + endFile.getAbsolutePath(), PluginServices.getText((Object)this, (String)"fichero_creado_en_formato") + " csv " + PluginServices.getText((Object)this, (String)"mediante_el_separador") + " \"" + separator + "\"", 1);
        }
        catch (IOException e) {
            logger.error("Error exportando a formato csv");
            JOptionPane.showMessageDialog(null, PluginServices.getText((Object)this, (String)"Error_exportando_las_estadisticas") + " " + endFile.getAbsolutePath(), PluginServices.getText((Object)this, (String)"Error"), 0);
        }
    }

    public void exportToDBFFile(List<Statistics.MyObjectStatistics> valores, File endFile) throws DataException, ValidateDataParametersException {
        DataManager datamanager = DALLocator.getDataManager();
        DataServerExplorerParameters no_params = datamanager.createServerExplorerParameters("FilesystemExplorer");
        FilesystemServerExplorer explorer = (FilesystemServerExplorer)datamanager.openServerExplorer("FilesystemExplorer", no_params);
        String providerName = explorer.getProviderName(endFile);
        try {
            if (endFile.exists()) {
                endFile.delete();
            }
            endFile.createNewFile();
            DataStoreParameters dsp = explorer.createStoreParameters(endFile, providerName);
            NewFeatureStoreParameters parameters = (NewFeatureStoreParameters)datamanager.createNewStoreParameters("FilesystemExplorer", providerName);
            parameters.delegate((DynObject)dsp);
            EditableFeatureType type = parameters.getDefaultFeatureType();
            type.add(PluginServices.getText((Object)this, (String)"Nombre"), 8, 50);
            type.add(PluginServices.getText((Object)this, (String)"Valor"), 7, 100).setPrecision(25);
            parameters.setDefaultFeatureType((FeatureType)type);
            datamanager.newStore("FilesystemExplorer", providerName, (NewDataStoreParameters)parameters, true);
            FeatureStore target = (FeatureStore)datamanager.openStore(providerName, (DataStoreParameters)parameters);
            target.edit(2);
            ListIterator<Statistics.MyObjectStatistics> iterador = valores.listIterator();
            while (iterador.hasNext()) {
                Statistics.MyObjectStatistics data = (Statistics.MyObjectStatistics)iterador.next();
                EditableFeature ef = target.createNewFeature().getEditable();
                ef.set(PluginServices.getText((Object)this, (String)"Nombre"), (Object)data.getKey());
                ef.set(PluginServices.getText((Object)this, (String)"Valor"), (Object)data.getValue());
                target.insert(ef);
            }
            target.finishEditing();
            target.dispose();
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"fichero_creado_en") + " " + endFile.getAbsolutePath(), PluginServices.getText((Object)this, (String)"fichero_creado_en_formato") + " dbf", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

