/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.HasDataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureStoreModel;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDocument
extends AbstractDocument
implements HasDataStore,
Observer {
    public static final String TABLE_PROPERTIES_PAGE_GROUP = "TableDocument";
    private static final long serialVersionUID = -1842181135614158881L;
    private static final Logger logger = LoggerFactory.getLogger(TableDocument.class);
    private FeatureStore store = null;
    private String featureTypeId = null;
    private String[] attributeNames;
    private List<TableLink> linkTable;
    private VectorLayer associatedLayer;
    private FeatureQuery query = null;
    private Evaluator baseFilter = null;
    private FeatureQueryOrder baseOrder = null;
    private FeatureStoreModel featureStoreModel;
    private Map<String, String> patterns = null;

    public TableDocument(DocumentManager factory) {
        super(factory);
    }

    public TableDocument() {
        this(null);
    }

    public TableDocument(DocumentManager factory, FeatureStore store) {
        this(factory);
        this.setStore(store);
    }

    public synchronized FeatureStoreModel getFeatureStoreModel() {
        if (this.featureStoreModel == null) {
            try {
                this.featureStoreModel = new FeatureStoreModel(this.getStore(), this.getQuery());
            }
            catch (BaseException e) {
                NotificationManager.addError((Throwable)e);
            }
        }
        return this.featureStoreModel;
    }

    public final void setStore(FeatureStore store) {
        if (this.store != null) {
            throw new UnsupportedOperationException("can't set store. store already set.");
        }
        this.store = store;
        DisposeUtils.bind((Disposable)this.store);
        this.store.addObserver((Observer)this);
        this.query = null;
        this.initializeFormattingPatterns();
    }

    private void initializeFormattingPatterns() {
        FeatureType featureType;
        try {
            featureType = this.store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            logger.warn("Can't initialize formating patterns", (Throwable)ex);
            return;
        }
        this.patterns = new HashMap<String, String>();
        for (FeatureAttributeDescriptor descriptor : featureType) {
            String pattern = null;
            switch (descriptor.getDataType().getType()) {
                case 2: 
                case 4: 
                case 5: {
                    pattern = "#,##0";
                    break;
                }
                case 7: {
                    pattern = "#,##0.0000000000";
                    break;
                }
                case 6: {
                    pattern = "#,##0.0000";
                    break;
                }
                case 19: {
                    pattern = "#,##0.0000";
                    break;
                }
                case 9: {
                    pattern = new SimpleDateFormat().toPattern();
                }
            }
            this.patterns.put(descriptor.getName(), pattern);
        }
    }

    public String getFormattingPattern(String columnName) {
        if (this.patterns == null) {
            return null;
        }
        String pattern = this.patterns.get(columnName);
        return pattern;
    }

    public void setFormattingPattern(String columnName, String pattern) {
        if (this.patterns == null) {
            return;
        }
        this.patterns.put(columnName, pattern);
    }

    public FeatureQuery getQuery() {
        if (this.query == null) {
            try {
                FeatureType fType2 = null;
                this.query = this.store.createFeatureQuery();
                if (this.featureTypeId != null) {
                    for (FeatureType fType2 : this.store.getFeatureTypes()) {
                        if (!this.featureTypeId.equals(fType2.getId())) continue;
                        this.query.setFeatureType(fType2);
                        break;
                    }
                    if (fType2 == null) {
                        throw new RuntimeException(MessageFormat.format("frature type {1} not found.", this.featureTypeId));
                    }
                } else {
                    fType2 = this.store.getDefaultFeatureType();
                }
                if (this.attributeNames != null) {
                    ArrayList<String> newNames = new ArrayList<String>();
                    for (String name : this.attributeNames) {
                        if (fType2.getIndex(name) <= -1) continue;
                        newNames.add(name);
                    }
                    if (newNames.size() > 0) {
                        this.query.setAttributeNames(newNames.toArray(this.attributeNames));
                    }
                }
                this.query.setFilter(this.baseFilter);
                this.query.setOrder(this.baseOrder);
            }
            catch (DataException e) {
                NotificationManager.addError((Throwable)e);
                return null;
            }
        }
        return this.query;
    }

    public FeatureStore getStore() {
        return this.store;
    }

    public FeatureStore getDataStore() {
        return this.store;
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public List<TableLink> getLinks() {
        return this.linkTable;
    }

    public boolean hasLinks() {
        return this.linkTable != null && this.linkTable.size() > 0;
    }

    public String getLinkTable() {
        if (this.linkTable == null || this.linkTable.isEmpty()) {
            return null;
        }
        return this.linkTable.get(0).getTargetTable().getName();
    }

    public String getField1() {
        if (this.linkTable.isEmpty()) {
            return null;
        }
        return this.linkTable.get(0).getSourceFieldName();
    }

    public String getField2() {
        if (this.linkTable.isEmpty()) {
            return null;
        }
        return this.linkTable.get(0).getTargetFieldName();
    }

    public void setLinkTable(String targetTable, String fieldSource, String fieldTarget) {
        this.addLinkTable(targetTable, fieldSource, fieldTarget);
    }

    public void addLinkTable(String targetTable, String fieldSource, String fieldTarget) {
        TableDocument target = (TableDocument)ProjectManager.getInstance().getCurrentProject().getDocument(targetTable, TableManager.TYPENAME);
        TableLink link = new TableLink(this, target, fieldSource, fieldTarget);
        link.setEnabled(true);
        if (this.linkTable == null) {
            this.linkTable = new ArrayList<TableLink>();
        }
        this.linkTable.add(link);
    }

    public void removeLinkTable() {
        if (this.linkTable.isEmpty()) {
            return;
        }
        TableLink link = this.linkTable.remove(this.linkTable.size() - 1);
        link.setEnabled(false);
        this.linkTable = null;
    }

    public void removeLinkTable(String name) {
        for (TableLink link : this.linkTable) {
            if (!name.equals(link.target.getName())) continue;
            link.setEnabled(false);
            this.linkTable.remove(link);
        }
    }

    public VectorLayer getAssociatedLayer() {
        return this.associatedLayer;
    }

    public void setAssociatedLayer(VectorLayer associatedLayer) {
        this.associatedLayer = associatedLayer;
    }

    public void update(Observable arg0, Object arg1) {
        FeatureStoreNotification event;
        if (this.store.equals(arg0) && arg1 instanceof FeatureStoreNotification && ("Transform_Change".equals((event = (FeatureStoreNotification)arg1).getType()) || "resourceChange_DataStore".equals(event.getType()))) {
            this.query = null;
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            super.loadFromState(state);
            this.store = (FeatureStore)state.get("store");
            this.featureTypeId = state.getString("featureTypeId");
            this.attributeNames = (String[])state.getArray("attributeNames", String.class);
            this.linkTable = state.getList("linkTable");
            this.associatedLayer = (FLyrVect)state.get("associatedLayer");
            this.query = (FeatureQuery)state.get("query");
            this.baseFilter = (Evaluator)state.get("baseFilter");
            this.baseOrder = (FeatureQueryOrder)state.get("baseOrder");
            this.patterns = new HashMap<String, String>(state.getMap("patterns"));
        }
        catch (Throwable e) {
            String storeName = this.store == null ? "unknow" : this.store.getFullName();
            logger.warn("can't load table '" + this.getName() + "' (store=" + storeName + ") from persisted state.", e);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("store", (Persistent)this.store);
        state.set("featureTypeId", this.featureTypeId);
        state.set("attributeNames", this.attributeNames);
        state.set("linkTable", this.linkTable);
        state.set("associatedLayer", (Persistent)this.associatedLayer);
        state.set("query", (Persistent)this.query);
        state.set("baseOrder", (Persistent)this.baseOrder);
        state.set("patterns", this.patterns);
    }

    public boolean isTemporary() {
        if (this.associatedLayer != null && this.associatedLayer.isTemporary()) {
            return true;
        }
        return this.getFeatureStore().isTemporary();
    }

    public boolean isAvailable() {
        return this.store != null;
    }

    public boolean contains(Object value) {
        DataStoreParameters params;
        if (value == null) {
            return false;
        }
        if (value instanceof FeatureStore) {
            params = ((FeatureStore)value).getParameters();
        } else if (value instanceof DataStoreParameters) {
            params = (DataStoreParameters)value;
        } else {
            return false;
        }
        FeatureStore featureStore = this.getStore();
        return featureStore.getParameters().isTheSameStore(params);
    }

    public void refresh() {
        try {
            this.getStore().refresh();
        }
        catch (IllegalStateException e) {
            logger.debug("Can't refresh table", (Throwable)e);
        }
        catch (DataException e) {
            logger.warn("Can't refresh table", (Throwable)e);
        }
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.store);
        DisposeUtils.disposeQuietly((Disposable)this.featureStoreModel);
        this.store = null;
        this.associatedLayer = null;
        this.baseFilter = null;
        this.baseOrder = null;
        this.featureStoreModel = null;
        this.linkTable = null;
        this.patterns = null;
        this.query = null;
        super.doDispose();
    }

    public static class TableLink
    implements Observer,
    Persistent {
        private TableDocument source = null;
        private FeatureStore storeSource = null;
        private int fieldSource = -1;
        private TableDocument target = null;
        private FeatureStore storeTarget = null;
        private int fieldTarget = -1;
        private boolean enabled = false;

        public TableLink() {
        }

        public TableLink(TableDocument source, TableDocument target, String fieldSource, String fieldTarget) {
            this();
            this.initialize(source, target, fieldSource, fieldTarget);
        }

        private void initialize(TableDocument source, TableDocument target, String fieldSource, String fieldTarget) {
            this.source = source;
            this.target = target;
            this.storeSource = this.source.getStore();
            this.storeTarget = this.target.getStore();
            try {
                this.fieldSource = this.storeSource.getDefaultFeatureType().getIndex(fieldSource);
                this.fieldTarget = this.storeTarget.getDefaultFeatureType().getIndex(fieldTarget);
            }
            catch (DataException ex) {
                logger.error("Can't initialize TableLink", (Throwable)ex);
                throw new RuntimeException("Can't initialize TableLink", ex);
            }
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.storeSource.addObserver((Observer)this);
            } else {
                this.storeSource.deleteObserver((Observer)this);
            }
            this.enabled = enabled;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public TableDocument getTargetTable() {
            return this.target;
        }

        public TableDocument getSourceTable() {
            return this.source;
        }

        public String getSourceFieldName() {
            try {
                return this.storeSource.getDefaultFeatureType().get(this.fieldSource).getName();
            }
            catch (DataException e) {
                logger.warn("Can't get source field name.", (Throwable)e);
                return null;
            }
        }

        public String getTargetFieldName() {
            try {
                return this.storeTarget.getDefaultFeatureType().get(this.fieldTarget).getName();
            }
            catch (DataException e) {
                logger.warn("Can't get target field name.", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable arg0, Object arg1) {
            try {
                FeatureSet fCollection1 = (FeatureSet)this.storeSource.getSelection();
                FeatureSelection fCollection2 = (FeatureSelection)this.storeTarget.createSelection();
                ArrayList<Object> idx = new ArrayList<Object>();
                DisposableIterator iterator1 = null;
                try {
                    iterator1 = fCollection1.fastIterator();
                    while (iterator1.hasNext()) {
                        Feature feature = (Feature)iterator1.next();
                        Object obj = feature.get(this.fieldSource);
                        if (idx.contains(obj)) continue;
                        idx.add(obj);
                    }
                }
                finally {
                    if (iterator1 != null) {
                        iterator1.dispose();
                    }
                }
                FeatureSet set = null;
                DisposableIterator iterator2 = null;
                try {
                    set = this.storeTarget.getFeatureSet();
                    iterator2 = set.fastIterator();
                    while (iterator2.hasNext()) {
                        Feature feature = (Feature)iterator2.next();
                        Object obj = feature.get(this.fieldTarget);
                        if (!idx.contains(obj)) continue;
                        fCollection2.select(feature);
                    }
                }
                catch (DataException e1) {
                    NotificationManager.addError((Throwable)e1);
                    return;
                }
                finally {
                    if (iterator2 != null) {
                        iterator2.dispose();
                    }
                    if (set != null) {
                        set.dispose();
                    }
                }
                if (this.storeSource != this.storeTarget) {
                    this.storeTarget.setSelection((FeatureSet)fCollection2);
                }
            }
            catch (DataException e2) {
                logger.warn(e2.getMessage(), (Throwable)e2);
            }
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.initialize((TableDocument)((Object)state.get("source")), (TableDocument)((Object)state.get("target")), state.getString("fieldSource"), state.getString("fieldTarget"));
            this.setEnabled(state.getBoolean("enabled"));
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("source", (Persistent)this.source);
            state.set("target", (Persistent)this.target);
            state.set("fieldSource", this.getSourceFieldName());
            state.set("fieldTarget", this.getTargetFieldName());
            state.set("enabled", this.getEnabled());
        }
    }
}

