/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table;

import java.awt.Dimension;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.addlayer.AddLayerDialog;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.AbstractDocumentManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentAction;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.actions.CopyDocumentAction;
import org.gvsig.app.project.documents.actions.CutDocumentAction;
import org.gvsig.app.project.documents.actions.PasteDocumentAction;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.table.gui.TableProperties;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanel;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.IdentityUtils;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.Invocable;
import org.gvsig.tools.util.MappedIterator;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableManager
extends AbstractDocumentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDocument.class);
    public static final String PERSISTENCE_TABLE_DOCUMENT_DEFINITION_NAME = "TableDocument";
    public static final String PERSISTENCE_TABLELINK_DEFINITION_NAME = "TableLink";
    public static String TYPENAME = "project.document.table";
    private DynStruct persistenceDefinition = null;

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"document-table-icon");
    }

    public ImageIcon getIconSelected() {
        return IconThemeHelper.getImageIcon((String)"document-table-icon-sel");
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"Tabla");
    }

    public String getTypeName() {
        return TYPENAME;
    }

    public int getPriority() {
        return 1;
    }

    public Iterator<? extends Document> createDocumentsByUser() {
        return this.createDocumentsByUser(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<? extends Document> createDocumentsByUser(Invocable whenDocumentsLoaded) {
        AddLayerDialog fopen = null;
        try {
            fopen = new AddLayerDialog(PluginServices.getText((Object)((Object)this), (String)"Nueva_tabla"));
            List wizards = ApplicationLocator.getManager().getWizardPanels();
            Dimension preferredSize = fopen.getPreferredSize();
            for (WizardPanel panel : wizards) {
                panel.initWizard();
                Dimension dim = panel.getPreferredSize();
                if (dim.height > preferredSize.height) {
                    preferredSize.height = dim.height;
                }
                if (dim.width > preferredSize.width) {
                    preferredSize.width = dim.width;
                }
                fopen.addWizardTab(panel.getTabName(), panel);
            }
            Dimension screensize = ToolsSwingUtils.getCurrentScreenSize();
            ToolsSwingUtils.ensureHeightWitdh((JComponent)fopen, (int)(3 * (screensize.height / 4)), (int)(2 * (screensize.width / 4)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
            PluginServices.getMDIManager().addWindow((IWindow)fopen);
            if (fopen.isAccepted()) {
                WizardPanel selectedPanel = (WizardPanel)fopen.getSelectedTab();
                if (whenDocumentsLoaded == null) {
                    List docs = (List)selectedPanel.executeWizard();
                    this.checkDocuments(docs);
                    Iterator iterator = docs.iterator();
                    return iterator;
                }
                Thread task = new Thread(() -> {
                    List docs = (List)selectedPanel.executeWizard();
                    this.checkDocuments(docs);
                    whenDocumentsLoaded.call(new Object[]{docs.iterator()});
                }, "DocumentTableLoader");
                task.start();
                Iterator iterator = Collections.EMPTY_LIST.iterator();
                return iterator;
            }
        }
        catch (Exception e) {
            NotificationManager.addError((Throwable)e);
        }
        finally {
            if (fopen != null) {
                fopen.dispose();
                fopen = null;
            }
        }
        return null;
    }

    private void checkDocuments(List<TableDocument> docs) {
        if (docs == null) {
            return;
        }
        for (TableDocument doc : docs) {
            try {
                FeatureStore store = doc.getDataStore();
                FeatureType type = store.getDefaultFeatureType();
                if (type.supportReferences()) continue;
                I18nManager i18n = ToolsLocator.getI18nManager();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog("\"" + doc.getName() + "\"\n" + i18n.getTranslation("_The_table_has_no_primary_key_or_OID") + "\n" + i18n.getTranslation("_Many_features_selection_deletion_modification_will_not_be_available_as_they_require_it_for_proper_operation"), null, i18n.getTranslation("_Warning"), 2, "TableDoNotSupportReferences");
            }
            catch (Exception exception) {}
        }
    }

    public AbstractDocument createDocumentByUser() {
        return (AbstractDocument)this.createDocumentsByUser().next();
    }

    public static void register() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        TableManager factory = new TableManager();
        ToolsLocator.getExtensionPointManager().add("FileTableOpenDialog", "").append("FileOpenTable", "", FilesystemExplorerWizardPanel.class);
        IconThemeHelper.registerIcon((String)"document", (String)"document-table-icon", TableManager.class);
        IconThemeHelper.registerIcon((String)"document", (String)"document-table-icon-sel", TableManager.class);
        IconThemeHelper.registerIcon((String)"document", (String)"document-table-icon-small", TableManager.class);
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        manager.registerFactory((PersistenceFactory)factory);
        if (factory.persistenceDefinition == null) {
            DynObjectManager dynman = ToolsLocator.getDynObjectManager();
            factory.persistenceDefinition = dynman.createDynClass("Persistence", PERSISTENCE_TABLE_DOCUMENT_DEFINITION_NAME, "Table document Persistence definition");
            factory.persistenceDefinition.extend(manager.getDefinition("AbstractDocument"));
            factory.persistenceDefinition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(true);
            factory.persistenceDefinition.addDynFieldString("featureTypeId").setMandatory(false);
            factory.persistenceDefinition.addDynFieldArray("attributeNames").setClassOfItems(String.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldObject("associatedLayer").setClassOfValue(FLyrVect.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldObject("query").setClassOfValue(FeatureQuery.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldObject("baseFilter").setClassOfValue(Evaluator.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldObject("baseOrder").setClassOfValue(FeatureQueryOrder.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldList("linkTable").setClassOfItems(TableDocument.TableLink.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldMap("patterns").setClassOfItems(String.class).setMandatory(false);
        }
        if (manager.getDefinition(PERSISTENCE_TABLELINK_DEFINITION_NAME) == null) {
            DynStruct tableLinkDefinition = manager.addDefinition(TableDocument.TableLink.class, PERSISTENCE_TABLELINK_DEFINITION_NAME, "TableLink Persistence definition", null, null);
            tableLinkDefinition.addDynFieldObject("source").setClassOfValue(TableDocument.class).setMandatory(true);
            tableLinkDefinition.addDynFieldObject("target").setClassOfValue(TableDocument.class).setMandatory(true);
            tableLinkDefinition.addDynFieldString("fieldSource").setMandatory(true);
            tableLinkDefinition.addDynFieldString("fieldTarget").setMandatory(true);
            tableLinkDefinition.addDynFieldBoolean("enabled").setMandatory(true);
        }
        ProjectManager.getInstance().registerDocumentFactory((DocumentManager)factory);
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, (DocumentAction)new CopyDocumentAction());
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, (DocumentAction)new CutDocumentAction());
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, (DocumentAction)new PasteDocumentAction());
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getStoresRepository().addRepository((StoresRepository)new TableDocumentStoresRepository("PROJECT_TABLES", i18n.getTranslation("_Project_tables")));
    }

    public AbstractDocument createDocument() {
        TableDocument doc = new TableDocument((DocumentManager)this);
        if (this.notifyObservers("DocumentManager.CreateDocument", (Document)doc).isCanceled()) {
            return null;
        }
        return doc;
    }

    public Class<? extends IDocumentWindow> getMainWindowClass() {
        return FeatureTableDocumentPanel.class;
    }

    public IWindow getMainWindow(Document doc, WindowLayout layout) {
        FeatureStore store = ((TableDocument)doc).getFeatureStore();
        if (!IdentityUtils.isAuthorized((String)"document-table-showmainwindow", (Object)doc, (String)store.getFullName())) {
            return null;
        }
        IDocumentWindow win = (IDocumentWindow)super.getMainWindow(doc, layout);
        if (win == null) {
            try {
                win = this.createDocumentWindow(doc);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (win == null) {
                try {
                    ((TableDocument)doc).getFeatureStore().refresh();
                }
                catch (DataException ex) {
                    throw new RuntimeException(ex);
                }
                win = this.createDocumentWindow(doc);
            }
            if (layout != null && win != null) {
                win.setWindowLayout(layout);
            }
        }
        if (this.notifyObservers("DocumentManager.getMainWindow", (IWindow)win).isCanceled()) {
            return null;
        }
        return win;
    }

    public IWindow getPropertiesWindow(Document doc) {
        Object win = super.getPropertiesWindow(doc);
        if (win == null) {
            win = new TableProperties((TableDocument)doc);
        }
        if (this.notifyObservers("DocumentManager.getPropertiesWindow", (IWindow)win).isCanceled()) {
            return null;
        }
        return win;
    }

    protected Class<? extends Document> getDocumentClass() {
        return TableDocument.class;
    }

    public DynStruct getDefinition(String className) {
        if (this.persistenceDefinition.getName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.persistenceDefinition.getFullName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.getDocumentClass().getName().equals(className)) {
            return this.persistenceDefinition;
        }
        return null;
    }

    public boolean manages(Object object) {
        return object instanceof TableDocument;
    }

    public TableDocument getTableDocument(VectorLayer layer) {
        if (layer == null) {
            return null;
        }
        List tableDocs = this.getProject().getDocuments(TYPENAME);
        for (Document document : tableDocs) {
            if (layer != ((TableDocument)document).getAssociatedLayer()) continue;
            return (TableDocument)document;
        }
        return null;
    }

    public TableDocument getTableDocument(FeatureStore store) {
        if (store == null) {
            return null;
        }
        List tableDocs = this.getProject().getDocuments(TYPENAME);
        for (Document document : tableDocs) {
            if (store != ((TableDocument)document).getFeatureStore()) continue;
            return (TableDocument)document;
        }
        return null;
    }

    public void removeTableDocument(VectorLayer layer) {
        TableDocument doc = this.getTableDocument(layer);
        if (doc != null) {
            PluginServices.getMDIManager().closeSingletonWindow((Object)doc);
            this.getProject().remove((Document)doc);
        }
    }

    private Project getProject() {
        return ProjectManager.getInstance().getCurrentProject();
    }

    private static class TableDocumentStoresRepository
    extends AbstractStoresRepository {
        public TableDocumentStoresRepository(String name, String label) {
            super(name, label);
        }

        protected DataStoreParameters getMyParameters(String name) {
            Project project = ProjectManager.getInstance().getCurrentProject();
            TableDocument tableDoc = (TableDocument)project.getDocument(name, TYPENAME);
            if (tableDoc == null || tableDoc.getFeatureStore() == null) {
                return null;
            }
            return tableDoc.getFeatureStore().getParameters();
        }

        protected FeatureType getMyFeatureType(String name) {
            Project project = ProjectManager.getInstance().getCurrentProject();
            TableDocument tableDoc = (TableDocument)project.getDocument(name, TYPENAME);
            if (tableDoc == null || tableDoc.getFeatureStore() == null) {
                return null;
            }
            return tableDoc.getFeatureStore().getDefaultFeatureTypeQuietly();
        }

        protected boolean isEmptyMyRepository() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            return project.getDocuments(TYPENAME).isEmpty();
        }

        protected int getMySize() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            int sz = project.getDocuments(TYPENAME).size();
            return sz;
        }

        protected UnmodifiableBasicSet<String> getMyKeySet() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            final List docs = project.getDocuments(TYPENAME);
            if (docs == null) {
                return UnmodifiableBasicSet.EMPTY_UNMODIFIABLEBASICSET;
            }
            UnmodifiableBasicSet<String> x = new UnmodifiableBasicSet<String>(){

                public boolean isEmpty() {
                    return docs.isEmpty();
                }

                public int size() {
                    return docs.size();
                }

                public Iterator<String> iterator() {
                    return new MappedIterator(docs.iterator(), t -> {
                        if (t == null) {
                            return null;
                        }
                        return ((TableDocument)((Object)t)).getName();
                    });
                }
            };
            return x;
        }

        public Iterator<DataStoreParameters> iterator() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            List docs = project.getDocuments(TYPENAME);
            if (docs == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return new MappedIterator(docs.iterator(), t -> {
                if (t == null || ((TableDocument)((Object)t)).getFeatureStore() == null) {
                    return null;
                }
                return ((TableDocument)((Object)t)).getFeatureStore().getParameters();
            });
        }

        public void add(String name, DataStoreParameters parameters) {
            Project project = ProjectManager.getInstance().getCurrentProject();
            TableDocument doc = (TableDocument)ProjectManager.getInstance().createDocument(TYPENAME);
            doc.setName(name);
            DataManager dataManager = DALLocator.getDataManager();
            try {
                FeatureStore store = (FeatureStore)dataManager.openStore(parameters.getProviderName(), parameters);
                doc.setStore(store);
                project.addDocument((Document)doc);
            }
            catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException ex) {
                this.LOGGER.warn("Can't add table to project", ex);
            }
        }

        public void add(String name, FeatureStore store) {
            Project project = ProjectManager.getInstance().getCurrentProject();
            TableDocument doc = (TableDocument)ProjectManager.getInstance().createDocument(TYPENAME);
            doc.setName(name);
            doc.setStore(store);
            project.addDocument((Document)doc);
        }

        public DataStore getStore(String name) {
            Project project = ProjectManager.getInstance().getCurrentProject();
            TableDocument tableDoc = (TableDocument)project.getDocument(name, TYPENAME);
            if (tableDoc == null || tableDoc.getFeatureStore() == null) {
                return null;
            }
            FeatureStore store = tableDoc.getFeatureStore();
            DisposeUtils.bind((Disposable)store);
            return store;
        }
    }
}

