/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.table.gui.CreateNewAttributePanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTypeEditingPanel
extends JPanel
implements IWindow {
    private static final long serialVersionUID = -4284879326692474318L;
    private static final Logger logger = LoggerFactory.getLogger(FeatureTypeEditingPanel.class);
    WindowInfo windowInfo = null;
    private JLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JTable jTableFields = null;
    private JButton jBtnNewField = null;
    private JButton jBtnDeleteField = null;
    private JButton jBtnRenameField = null;
    private JButton jBtnOK = null;
    private JButton jBtnCancel = null;
    private CreateNewAttributePanel panelNewField;
    private FeatureStore featureStore = null;
    private JPanel jPanelButtons = null;
    private EditableFeatureType editableType = null;

    public FeatureTypeEditingPanel(FeatureStore fs) throws DataException {
        this.featureStore = fs;
        this.editableType = fs.getDefaultFeatureType().getEditable();
        this.panelNewField = new CreateNewAttributePanel(this.featureStore);
        this.initialize();
        MyTableModel tm = new MyTableModel();
        this.getJTableFields().setModel(tm);
        TableColumn typeColumn = this.jTableFields.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Boolean");
        comboBox.addItem("Date");
        comboBox.addItem("Integer");
        comboBox.addItem("Double");
        comboBox.addItem("String");
        typeColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(5);
        flowLayout.setHgap(0);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(15);
        borderLayout.setVgap(15);
        this.jLabel = new JLabel();
        this.jLabel.setText(PluginServices.getText((Object)this, (String)"add_delete_edit_fields") + ": ");
        this.setLayout(borderLayout);
        this.setSize(new Dimension(663, 404));
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        JPanel jPanelNorth = new JPanel(new FlowLayout(0));
        jPanelNorth.add(this.jLabel);
        this.add((Component)jPanelNorth, "North");
        JPanel jPanelCenter = new JPanel(new FlowLayout(0, 10, 0));
        jPanelCenter.add(this.getJScrollPane());
        this.add((Component)jPanelCenter, "Center");
        this.add((Component)this.getJPanelButtons(), "East");
        JPanel jPanelSouth = new JPanel();
        jPanelSouth.setLayout(flowLayout);
        jPanelSouth.add((Component)this.getJBtnOK(), null);
        jPanelSouth.add((Component)this.getJBtnCancel(), null);
        this.add((Component)jPanelSouth, "South");
    }

    public WindowInfo getWindowInfo() {
        if (this.windowInfo == null) {
            this.windowInfo = new WindowInfo(41);
            this.windowInfo.setTitle(PluginServices.getText((Object)this, (String)"field_manager"));
            this.windowInfo.setHeight(this.getHeight());
            this.windowInfo.setWidth(this.getWidth());
        }
        return this.windowInfo;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(482, 350));
            this.jScrollPane.setViewportView(this.getJTableFields());
        }
        return this.jScrollPane;
    }

    private JTable getJTableFields() {
        if (this.jTableFields == null) {
            this.jTableFields = new JTable();
            this.jTableFields.setSelectionMode(2);
            this.jTableFields.setColumnSelectionAllowed(false);
            ListSelectionModel rowSM = this.jTableFields.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        FeatureTypeEditingPanel.this.jBtnDeleteField.setEnabled(false);
                    } else {
                        FeatureTypeEditingPanel.this.jBtnDeleteField.setEnabled(true);
                    }
                    if (FeatureTypeEditingPanel.this.jTableFields.getSelectedRows().length != 1) {
                        FeatureTypeEditingPanel.this.getJBtnRenameField().setEnabled(false);
                    } else {
                        FeatureTypeEditingPanel.this.getJBtnRenameField().setEnabled(true);
                    }
                }
            });
        }
        return this.jTableFields;
    }

    private JButton getJBtnNewField() {
        if (this.jBtnNewField == null) {
            this.jBtnNewField = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnNewField.setText(PluginServices.getText((Object)this, (String)"new_field"));
            this.jBtnNewField.addActionListener(new ActionListener(){
                private List<String> tempFieldNames = new ArrayList<String>();
                {
                    try {
                        int size = FeatureTypeEditingPanel.this.editableType.size();
                        for (int i = 0; i < size; ++i) {
                            FeatureAttributeDescriptor ad = FeatureTypeEditingPanel.this.editableType.get(i);
                            this.tempFieldNames.add(ad.getName());
                        }
                    }
                    catch (Exception ex) {
                        logger.warn("Can't initialize tempFieldNames", (Throwable)ex);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataManager dataManager = DALLocator.getDataManager();
                    FeatureStoreProviderFactory factory = (FeatureStoreProviderFactory)dataManager.getStoreProviderFactory(FeatureTypeEditingPanel.this.featureStore.getProviderName());
                    FeatureTypeEditingPanel.this.panelNewField.setMaxAttributeNameSize(factory.getMaxAttributeNameSize());
                    ActionListener okAction = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                EditableFeatureAttributeDescriptor ead = FeatureTypeEditingPanel.this.panelNewField.loadFieldDescription(FeatureTypeEditingPanel.this.editableType);
                                if (ead == null) {
                                    return;
                                }
                                if (ead.getType() == 8 && ead.getSize() > 254) {
                                    NotificationManager.showMessageInfo((String)(PluginServices.getText((Object)this, (String)"max_length_is") + ":" + 254), null);
                                    ead.setSize(254);
                                }
                                tempFieldNames.add(ead.getName());
                                FeatureTypeEditingPanel.this.jTableFields.revalidate();
                                PluginServices.getMDIManager().closeWindow((IWindow)FeatureTypeEditingPanel.this.panelNewField);
                            }
                            catch (ParseException e2) {
                                NotificationManager.addError((Throwable)e2);
                            }
                        }
                    };
                    FeatureTypeEditingPanel.this.panelNewField.setOkAction(okAction);
                    String[] names = this.tempFieldNames.toArray(new String[0]);
                    FeatureTypeEditingPanel.this.panelNewField.setCurrentFieldNames(names);
                    FeatureTypeEditingPanel.this.panelNewField = (CreateNewAttributePanel)PluginServices.getMDIManager().addWindow((IWindow)FeatureTypeEditingPanel.this.panelNewField);
                }
            });
        }
        return this.jBtnNewField;
    }

    private JButton getJBtnDelete() {
        if (this.jBtnDeleteField == null) {
            this.jBtnDeleteField = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnDeleteField.setText(PluginServices.getText((Object)this, (String)"delete_field"));
            this.jBtnDeleteField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selecteds = FeatureTypeEditingPanel.this.jTableFields.getSelectedRows();
                    TableModel tm = FeatureTypeEditingPanel.this.jTableFields.getModel();
                    for (int i = selecteds.length - 1; i >= 0; --i) {
                        String fieldName = (String)tm.getValueAt(selecteds[i], 0);
                        String old_geom_fld = FeatureTypeEditingPanel.this.editableType.getDefaultGeometryAttributeName();
                        if (old_geom_fld.compareTo(fieldName) == 0) {
                            JOptionPane.showMessageDialog(FeatureTypeEditingPanel.this.jTableFields, Messages.getText((String)"_Cannot_delete_geometry_field"), Messages.getText((String)"_Remove_column"), 2);
                            continue;
                        }
                        FeatureTypeEditingPanel.this.editableType.remove(fieldName);
                    }
                    FeatureTypeEditingPanel.this.jTableFields.getSelectionModel().clearSelection();
                    FeatureTypeEditingPanel.this.jTableFields.revalidate();
                }
            });
        }
        return this.jBtnDeleteField;
    }

    private JButton getJBtnRenameField() {
        if (this.jBtnRenameField == null) {
            this.jBtnRenameField = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnRenameField.setText(PluginServices.getText((Object)this, (String)"rename_field"));
            this.jBtnRenameField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selecteds = FeatureTypeEditingPanel.this.jTableFields.getSelectedRows();
                    TableModel tm = FeatureTypeEditingPanel.this.jTableFields.getModel();
                    for (int i = selecteds.length - 1; i >= 0; --i) {
                        String fieldName = (String)tm.getValueAt(selecteds[i], 0);
                        String old_geom_fld = FeatureTypeEditingPanel.this.editableType.getDefaultGeometryAttributeName();
                        if (old_geom_fld != null && old_geom_fld.compareTo(fieldName) == 0) {
                            JOptionPane.showMessageDialog(FeatureTypeEditingPanel.this.jTableFields, Messages.getText((String)"_Cannot_rename_geometry_field"), Messages.getText((String)"_Rename_column"), 2);
                            continue;
                        }
                        String newName = JOptionPane.showInputDialog((Component)PluginServices.getMDIManager().getActiveWindow(), PluginServices.getText((Object)this, (String)"_Please_insert_new_field_name"), fieldName);
                        if (newName == null) continue;
                        if (newName.length() == 0) {
                            JOptionPane.showMessageDialog(FeatureTypeEditingPanel.this.jTableFields, Messages.getText((String)"_No_input_name"), Messages.getText((String)"_Rename_column"), 0);
                            continue;
                        }
                        DataManager dataManager = DALLocator.getDataManager();
                        FeatureStoreProviderFactory factory = (FeatureStoreProviderFactory)dataManager.getStoreProviderFactory(FeatureTypeEditingPanel.this.featureStore.getProviderName());
                        if (factory.getMaxAttributeNameSize() > 0 && newName.length() > factory.getMaxAttributeNameSize()) {
                            JOptionPane.showMessageDialog(FeatureTypeEditingPanel.this.jTableFields, Messages.getText((String)"_Name_too_long"), Messages.getText((String)"_Rename_column"), 0);
                            continue;
                        }
                        if (FeatureTypeEditingPanel.this.editableType.getIndex(newName) != -1) {
                            NotificationManager.showMessageInfo((String)PluginServices.getText((Object)this, (String)"field_already_exists"), null);
                            continue;
                        }
                        try {
                            EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)FeatureTypeEditingPanel.this.editableType.getAttributeDescriptor(fieldName);
                            efad.setName(newName);
                            continue;
                        }
                        catch (Exception de) {
                            JOptionPane.showMessageDialog(FeatureTypeEditingPanel.this.jTableFields, Messages.getText((String)"_Unable_to_rename_field") + ": " + de.getMessage(), Messages.getText((String)"_Rename_column"), 0);
                        }
                    }
                    FeatureTypeEditingPanel.this.jTableFields.repaint();
                }
            });
        }
        return this.jBtnRenameField;
    }

    private JButton getJBtnOK() {
        if (this.jBtnOK == null) {
            this.jBtnOK = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnOK.setText(PluginServices.getText((Object)this, (String)"aceptar"));
            this.jBtnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FeatureTypeEditingPanel.this.featureStore.update(FeatureTypeEditingPanel.this.editableType);
                    }
                    catch (DataException e1) {
                        NotificationManager.showMessageError((String)PluginServices.getText((Object)this, (String)"update_featuretype_error"), (Exception)((Object)e1));
                    }
                    PluginServices.getMDIManager().closeWindow((IWindow)FeatureTypeEditingPanel.this);
                }
            });
        }
        return this.jBtnOK;
    }

    private JButton getJBtnCancel() {
        if (this.jBtnCancel == null) {
            this.jBtnCancel = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnCancel.setText(PluginServices.getText((Object)this, (String)"cancelar"));
            this.jBtnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginServices.getMDIManager().closeWindow((IWindow)FeatureTypeEditingPanel.this);
                }
            });
        }
        return this.jBtnCancel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            JPanel aux = new JPanel(new GridLayout(3, 1));
            aux.add(this.getJBtnNewField());
            aux.add(this.getJBtnRenameField());
            aux.add(this.getJBtnDelete());
            this.jPanelButtons.add((Component)aux, "North");
        }
        return this.jPanelButtons;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2847526298987536118L;

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return FeatureTypeEditingPanel.this.editableType.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FeatureAttributeDescriptor myField = null;
            myField = FeatureTypeEditingPanel.this.editableType.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return myField.getName();
                }
                case 1: {
                    return myField.getDataType().getName();
                }
                case 2: {
                    return myField.getSize();
                }
                case 3: {
                    return myField.getPrecision();
                }
                case 4: {
                    return myField.getDefaultValue();
                }
                case 5: {
                    if (myField.isComputed() && myField.getFeatureAttributeEmulator() instanceof FeatureAttributeEmulatorExpression) {
                        FeatureAttributeEmulatorExpression emulator = (FeatureAttributeEmulatorExpression)myField.getFeatureAttributeEmulator();
                        return emulator.getExpression().getPhrase();
                    }
                    if (myField.isComputed()) {
                        return PluginServices.getText((Object)this, (String)"_Virtual_field");
                    }
                    return "";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return super.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PluginServices.getText((Object)this, (String)"field_name");
                }
                case 1: {
                    return PluginServices.getText((Object)this, (String)"field_type");
                }
                case 2: {
                    return PluginServices.getText((Object)this, (String)"field_length");
                }
                case 3: {
                    return PluginServices.getText((Object)this, (String)"field_decimal_count");
                }
                case 4: {
                    return PluginServices.getText((Object)this, (String)"field_default_value");
                }
                case 5: {
                    return PluginServices.getText((Object)this, (String)"_Calculated");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                FeatureTypeEditingPanel.this.editableType.remove(rowIndex);
            }
            String name = "";
            int type = 8;
            int size = 0;
            int precision = 0;
            switch (columnIndex) {
                case 0: {
                    name = (String)aValue;
                    break;
                }
                case 1: {
                    String strType = (String)aValue;
                    if (strType.equals("String")) {
                        type = 8;
                    }
                    if (strType.equals("Double")) {
                        type = 7;
                        precision = 5;
                    }
                    if (strType.equals("Integer")) {
                        type = 4;
                    }
                    if (strType.equals("Boolean")) {
                        type = 1;
                    }
                    if (!strType.equals("Date")) break;
                    type = 9;
                    break;
                }
                case 2: {
                    size = (Integer)aValue;
                }
            }
            EditableFeatureAttributeDescriptor ead = FeatureTypeEditingPanel.this.editableType.add(name, type, size);
            ead.setPrecision(precision);
        }
    }
}

