/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.CheckGeometriesPanel;
import org.gvsig.export.swing.impl.panels.SelectAttributesPanel;
import org.gvsig.export.swing.impl.panels.SelectCharsetPanel;
import org.gvsig.export.swing.impl.panels.SelectFilterPanel;
import org.gvsig.export.swing.impl.panels.SelectGeometryFieldPanel;
import org.gvsig.export.swing.impl.panels.SelectGeometryTypePanel;
import org.gvsig.export.swing.impl.panels.SelectOutputFilePanel;
import org.gvsig.export.swing.impl.panels.SelectTargetProjectionPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelsFactory;
import org.gvsig.export.swing.spi.ExportPanelsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportPanelsManager
implements ExportPanelsManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExportPanelsManager.class);
    private final Map<String, ExportPanelsFactory> factories = new HashMap<String, ExportPanelsFactory>();
    private final Map<String, Class<? extends ExportPanel>> stdPanels = new HashMap<String, Class<? extends ExportPanel>>();

    public DefaultExportPanelsManager() {
        this.stdPanels.put("PANEL_CHECK_GEOMETRIES", CheckGeometriesPanel.class);
        this.stdPanels.put("PANEL_SELECT_CHARSET", SelectCharsetPanel.class);
        this.stdPanels.put("PANEL_SELECT_EXPORT_FILTER", SelectFilterPanel.class);
        this.stdPanels.put("PANEL_ATTRIBUTES_SELECTION", SelectAttributesPanel.class);
        this.stdPanels.put("PANEL_SELECT_GEOMETRY_TYPE", SelectGeometryTypePanel.class);
        this.stdPanels.put("PANEL_SELECT_OUTPUT_FILE", SelectOutputFilePanel.class);
        this.stdPanels.put("PANEL_SELECT_TARGET_PROJECTION", SelectTargetProjectionPanel.class);
        this.stdPanels.put("PANEL_SELECT_GEOMETRY_FIELD", SelectGeometryFieldPanel.class);
    }

    public ExportPanelsFactory getPanelsFactory(String name) {
        ExportPanelsFactory factory = this.factories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Don't exists export panels factory '" + name + "'.");
        }
        return factory;
    }

    public void register(ExportPanelsFactory factory) {
        this.factories.put(factory.getName(), factory);
    }

    public ExportPanel createStandardPanel(String panelId, JExportProcessPanel processPanel, ExportParameters parameters, Object ... args) {
        Class<? extends ExportPanel> panelClass = this.stdPanels.get(panelId);
        if (panelClass == null) {
            throw new IllegalArgumentException("The panel '" + panelId + "' is not registered.");
        }
        Class[] classArgs = new Class[args.length + 2];
        Object[] args2 = new Object[args.length + 2];
        classArgs[0] = JExportProcessPanel.class;
        classArgs[1] = ExportParameters.class;
        args2[0] = processPanel;
        args2[1] = parameters;
        for (int i = 0; i < args.length; ++i) {
            classArgs[i + 2] = args[i].getClass();
            args2[i + 2] = args[i];
        }
        try {
            Constructor<? extends ExportPanel> constructor = panelClass.getConstructor(classArgs);
            ExportPanel panel = constructor.newInstance(args2);
            return panel;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't create a standard panel with id '" + panelId + "'.", ex);
        }
    }
}

