/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl;

import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.export.swing.impl.DefaultJExportProcessPanel;
import org.gvsig.export.swing.impl.MessagePanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardOptionPanelAdapter
implements OptionPanel {
    private static final Logger LOG = LoggerFactory.getLogger(WizardOptionPanelAdapter.class);
    private final ExportPanel exportPanel;
    private final DefaultJExportProcessPanel processPanel;

    public WizardOptionPanelAdapter(DefaultJExportProcessPanel processPanel, ExportPanel exportPanel) {
        this.exportPanel = exportPanel;
        this.processPanel = processPanel;
    }

    public String getPanelTitle() {
        return this.exportPanel.getTitlePanel();
    }

    public void nextPanel() throws NotContinueWizardException {
        boolean valid;
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            valid = this.exportPanel.validatePanel();
        }
        catch (ExportPanelValidationException ex) {
            LOG.info("Export form, invalid values.", (Throwable)ex);
            throw new NotContinueWizardException(i18n.getTranslation("_Invalid_values_in_form"), (Throwable)ex, (Component)this.exportPanel.asJComponent());
        }
        if (!valid) {
            throw new NotContinueWizardException(i18n.getTranslation("_Invalid_values_in_form"), (Component)this.exportPanel.asJComponent(), true);
        }
        try {
            this.processPanel.setLastAcction(1);
            this.exportPanel.nextPanel();
        }
        catch (Exception ex) {
            LOG.warn("Fail the call to nextPanel.", (Throwable)ex);
            MessagePanel.showMessage(i18n.getTranslation("_Warning"), i18n.getTranslation("_There_have_been_problems_retrieving_panel_data") + " (" + this.exportPanel.getTitlePanel() + ")", ex, null);
        }
    }

    public void lastPanel() {
        try {
            this.processPanel.setLastAcction(0);
            this.exportPanel.previousPanel();
        }
        catch (Exception ex) {
            LOG.warn("Fail the call to previousPanel.", (Throwable)ex);
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            MessagePanel.showMessage(i18nManager.getTranslation("_Warning"), i18nManager.getTranslation("_There_have_been_problems_filling_data_in_panel") + " (" + this.exportPanel.getTitlePanel() + ")", ex, null);
        }
    }

    public void updatePanel() {
        try {
            this.exportPanel.enterPanel();
        }
        catch (Exception ex) {
            LOG.warn("Fail the call to enterPanel.", (Throwable)ex);
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            MessagePanel.showMessage(i18nManager.getTranslation("_Warning"), i18nManager.getTranslation("_There_have_been_problems_filling_data_in_panel") + " (" + this.exportPanel.getTitlePanel() + ")", ex, null);
        }
    }

    public JPanel getJPanel() {
        return (JPanel)this.exportPanel.asJComponent();
    }
}

