/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.ExportProgressPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.task.JTaskStatus;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportProgressPanel
extends ExportProgressPanelView
implements ExportPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportProgressPanel.class);
    private final JExportProcessPanel processPanel;
    private final ExportParameters parameters;
    private JTaskStatus jTaskStatus;
    private BookmarksController bookmarksController;

    public ExportProgressPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        TaskStatusSwingManager TaskStatusSwingManager2 = ToolsSwingLocator.getTaskStatusSwingManager();
        this.jTaskStatus = TaskStatusSwingManager2.createJTaskStatus();
        this.jpnMain.setLayout(new BorderLayout());
        this.jpnMain.add((Component)this.jTaskStatus, "North");
        this.jTaskStatus.bind(this.processPanel.getProcess().getTaskStatus());
        Bookmarks bookmarks = ExportLocator.getManager().getBookmarks();
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(bookmarks, this.btnBookmark);
        this.bookmarksController.setAllowAddBookmarks(Boolean.valueOf(true));
        this.bookmarksController.setFilter(null);
        this.bookmarksController.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (e.getID() == 1002) {
                        BookmarksController.BookmarkEvent bookmarkEvent = (BookmarksController.BookmarkEvent)e;
                        ExportParameters clone = ExportProgressPanel.this.parameters.clone();
                        clone.setCreationDate(new Date());
                        bookmarkEvent.setCurrentValue((Object)clone);
                    }
                }
                catch (CloneNotSupportedException ex) {
                    LOGGER.warn("Can't clone export parameters.", (Throwable)ex);
                }
            }
        });
    }

    public String getIdPanel() {
        return "ExportProgressPanel";
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("export_progress");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
    }

    public void nextPanel() {
        this.processPanel.setButtonEnabled(2, false);
    }

    public void previousPanel() {
        this.processPanel.setButtonEnabled(2, true);
        this.processPanel.setButtonEnabled(3, true);
        this.processPanel.setButtonText(3, ToolsLocator.getI18nManager().getTranslation("_Cancel"));
    }

    public JComponent asJComponent() {
        return this;
    }
}

