/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectGeometryTypePanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class SelectGeometryTypePanel
extends SelectGeometryTypePanelView
implements ExportPanel {
    private final ExportParametersGeometry parameters;
    private int[] geometryTypes;
    private int[] geometrySubtypes;
    private final Map<Integer, String> geometryTypeNames;
    private final Map<Integer, String> geometrySubtypeNames;
    private final JExportProcessPanel processPanel;

    public SelectGeometryTypePanel(JExportProcessPanel processPanel, ExportParametersGeometry parameters) {
        this(processPanel, (ExportParameters)parameters, null, null);
    }

    public SelectGeometryTypePanel(JExportProcessPanel processPanel, ExportParameters parameters, int[] geometryTypes, int[] geometrySubtypes) {
        this.processPanel = processPanel;
        this.geometryTypeNames = new HashMap<Integer, String>();
        this.geometrySubtypeNames = new HashMap<Integer, String>();
        this.parameters = (ExportParametersGeometry)parameters;
        this.geometryTypes = geometryTypes;
        this.geometrySubtypes = geometrySubtypes;
        this.initData();
        this.initComponents();
    }

    private void initData() {
        FeatureType ft = this.parameters.getSourceFeatureType();
        FeatureAttributeDescriptor geomDescriptor = ft.getDefaultGeometryAttribute();
        if (geomDescriptor == null) {
            this.parameters.setTargetGeometryType(0);
            this.parameters.setTargetGeometrySubtype(0);
        } else {
            GeometryType gt = geomDescriptor.getGeomType();
            this.parameters.setTargetGeometryType(gt.getType());
            this.parameters.setTargetGeometrySubtype(gt.getSubType());
        }
        if (ArrayUtils.isEmpty((int[])this.geometryTypes)) {
            this.geometryTypes = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 21, 22, 23, 24, 25};
        }
        if (ArrayUtils.isEmpty((int[])this.geometrySubtypes)) {
            this.geometrySubtypes = new int[]{0, 2, 1, 3};
        }
        this.geometryTypeNames.put(0, "GEOMETRY");
        this.geometryTypeNames.put(1, "POINT");
        this.geometryTypeNames.put(2, "CURVE");
        this.geometryTypeNames.put(3, "SURFACE");
        this.geometryTypeNames.put(4, "SOLID");
        this.geometryTypeNames.put(6, "AGGREGATE");
        this.geometryTypeNames.put(7, "MULTIPOINT");
        this.geometryTypeNames.put(8, "MULTICURVE");
        this.geometryTypeNames.put(9, "MULTISURFACE");
        this.geometryTypeNames.put(10, "MULTISOLID");
        this.geometryTypeNames.put(11, "CIRCLE");
        this.geometryTypeNames.put(12, "ARC");
        this.geometryTypeNames.put(13, "ELLIPSE");
        this.geometryTypeNames.put(14, "SPLINE");
        this.geometryTypeNames.put(15, "ELLIPTICARC");
        this.geometryTypeNames.put(17, "COMPLEX");
        this.geometryTypeNames.put(18, "LINE");
        this.geometryTypeNames.put(19, "POLYGON");
        this.geometryTypeNames.put(16, "NULL");
        this.geometryTypeNames.put(20, "RING");
        this.geometryTypeNames.put(21, "MULTILINE");
        this.geometryTypeNames.put(22, "MULTIPOLYGON");
        this.geometryTypeNames.put(23, "CIRCUMFERENCE");
        this.geometryTypeNames.put(24, "PERIELLIPSE");
        this.geometryTypeNames.put(25, "FILLEDSPLINE");
        this.geometrySubtypeNames.put(0, "2D");
        this.geometrySubtypeNames.put(2, "2DM");
        this.geometrySubtypeNames.put(1, "3D");
        this.geometrySubtypeNames.put(3, "3DM");
        this.geometrySubtypeNames.put(4, "UNKNOWN");
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        void var4_6;
        ArrayList<Object> items = new ArrayList<Object>();
        int[] nArray = this.geometryTypes;
        int n = nArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            int geometryType = nArray[var4_6];
            items.add(new ListElement(this.geometryTypeNames.getOrDefault(geometryType, "unknown (" + geometryType + ")"), (Object)geometryType));
            ++var4_6;
        }
        items.sort(new Comparator<ListElement<Integer>>(){

            @Override
            public int compare(ListElement<Integer> o1, ListElement<Integer> o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        DefaultComboBoxModel<ListElement> model1 = new DefaultComboBoxModel<ListElement>();
        for (ListElement listElement : items) {
            model1.addElement(listElement);
        }
        this.cboType.setModel(model1);
        items = new ArrayList();
        for (Object geometrySubtype : (Iterator)this.geometrySubtypes) {
            items.add(new ListElement(this.geometrySubtypeNames.getOrDefault((int)geometrySubtype, "unknown (" + (int)geometrySubtype + ")"), (Object)((int)geometrySubtype)));
        }
        items.sort(new Comparator<ListElement<Integer>>(){

            @Override
            public int compare(ListElement<Integer> o1, ListElement<Integer> o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        model1 = new DefaultComboBoxModel();
        for (ListElement listElement : items) {
            model1.addElement(listElement);
        }
        this.cboSubtype.setModel(model1);
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblSelectTargetGeometryType);
        i18nc.translate(this.lblSubtype);
        i18nc.translate(this.lblType);
    }

    public String getIdPanel() {
        return "PANEL_SELECT_GEOMETRY_TYPE";
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Select_geometry_type");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        Integer n = (Integer)ListElement.getSelected((JComboBox)this.cboType);
        if (n != null) {
            this.parameters.setTargetGeometryType(n.intValue());
        }
        if ((n = (Integer)ListElement.getSelected((JComboBox)this.cboSubtype)) != null) {
            this.parameters.setTargetGeometrySubtype(n.intValue());
        }
    }

    public void enterPanel() {
        ListElement.setSelected((JComboBox)this.cboType, (Object)this.parameters.getTargetGeometryTypeAsInt());
        ListElement.setSelected((JComboBox)this.cboSubtype, (Object)this.parameters.getTargetGeometrySubtype());
    }

    public JComponent asJComponent() {
        return this;
    }
}

