/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCCantFetchValueException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCDriverClassNotFoundException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.AbstractConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCConnectionBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCHelperBase;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.oracle.dal.OracleConnectionParameters;
import org.gvsig.oracle.dal.OracleExplorerParameters;
import org.gvsig.oracle.dal.OracleNewStoreParameters;
import org.gvsig.oracle.dal.OracleSQLBuilder;
import org.gvsig.oracle.dal.OracleSRSSolver;
import org.gvsig.oracle.dal.OracleStoreParameters;
import org.gvsig.oracle.dal.OracleStoreProvider;
import org.gvsig.oracle.dal.operations.OracleOperationsFactory;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;

public class OracleHelper
extends JDBCHelperBase {
    public static final String ORACLE_JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static Map<String, ConnectionProvider> connectionProviders = new HashMap<String, ConnectionProvider>();
    private ConnectionProvider connectionProvider = null;

    public static String getConnectionURL(OracleConnectionParameters params) {
        return OracleHelper.getConnectionURL(params.getHost(), params.getPort(), params.getDBName(), params.getMode());
    }

    public static String getConnectionURL(String host, Integer port, String db, String mode) {
        String connectionURL;
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Parameter 'host' can't be null.");
        }
        if (port == null) {
            throw new IllegalArgumentException("Parameter 'port' can't be null.");
        }
        if (StringUtils.isEmpty((CharSequence)db)) {
            throw new IllegalArgumentException("Parameter 'db' can't be null.");
        }
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "sid";
        }
        switch (mode.toLowerCase()) {
            case "service": {
                connectionURL = MessageFormat.format("jdbc:oracle:thin:@//{0}:{1,number,######}/{2}", host, port, db);
                break;
            }
            default: {
                connectionURL = MessageFormat.format("jdbc:oracle:thin:@{0}:{1,number,######}:{2}", host, port, db);
            }
        }
        return connectionURL;
    }

    public OracleHelper(JDBCConnectionParameters connectionParameters) {
        this(connectionParameters, null);
    }

    public OracleHelper(JDBCConnectionParameters connectionParameters, ConnectionProvider theConnectionProvider) {
        super(connectionParameters);
        if (this.connectionProvider == null) {
            this.connectionProvider = theConnectionProvider;
        }
        this.srssolver = new OracleSRSSolver((JDBCHelper)this);
    }

    public ConnectionProvider getConnectionProvider() {
        if (this.connectionProvider == null) {
            OracleConnectionParameters connectionParameters = this.getConnectionParameters();
            if (connectionParameters == null) {
                return null;
            }
            this.connectionProvider = connectionProviders.get(this.getConnectionProviderKey(connectionParameters));
            if (this.connectionProvider == null || this.connectionProvider.isDisposed()) {
                this.connectionProvider = new OracleConnectionProvider(this.getConnectionParameters());
                connectionProviders.put(this.getConnectionProviderKey(connectionParameters), this.connectionProvider);
            } else {
                DisposeUtils.bind((Disposable)this.connectionProvider);
            }
        }
        return this.connectionProvider;
    }

    public synchronized JDBCConnection getConnection() throws AccessResourceException {
        try {
            OracleConnectionParameters connectionParameters = this.getConnectionParameters();
            String connid = this.getConnectionProviderKey(connectionParameters);
            JDBCConnection conn = (JDBCConnection)DataTransactionServices.getConnection((DataTransactionServices)this.getTransaction(), (String)connid);
            if (conn != null) {
                return conn;
            }
            ConnectionProvider connProvider = this.getConnectionProvider();
            JDBCConnectionBase connection = new JDBCConnectionBase(this.getTransaction(), this.connectionProvider.getConnection(), connid, connProvider);
            return connection;
        }
        catch (SQLException ex) {
            throw new AccessResourceException("Oracle", (Throwable)ex);
        }
    }

    public OracleConnectionParameters getConnectionParameters() {
        return (OracleConnectionParameters)super.getConnectionParameters();
    }

    public String getConnectionURL() {
        return OracleHelper.getConnectionURL(this.getConnectionParameters());
    }

    protected String getResourceType() {
        return "Oracle";
    }

    public String getProviderName() {
        return "Oracle";
    }

    public OracleSQLBuilder createSQLBuilder() {
        return new OracleSQLBuilder((JDBCHelper)this);
    }

    public OperationsFactory getOperations() {
        if (this.operationsFactory == null) {
            this.operationsFactory = new OracleOperationsFactory((JDBCHelper)this);
        }
        return this.operationsFactory;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType getGeometrySupportType() {
        return GeometryExpressionBuilderHelper.GeometrySupportType.WKB;
    }

    public boolean hasSpatialFunctions() {
        return true;
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) {
        return true;
    }

    public String getQuoteForIdentifiers() {
        return "\"";
    }

    public boolean allowAutomaticValues() {
        return true;
    }

    public boolean supportOffsetInSelect() {
        return true;
    }

    public String getQuoteForStrings() {
        return "'";
    }

    public JDBCNewStoreParameters createNewStoreParameters() {
        return new OracleNewStoreParameters();
    }

    public JDBCStoreParameters createOpenStoreParameters() {
        return new OracleStoreParameters();
    }

    public JDBCServerExplorerParameters createServerExplorerParameters() {
        return new OracleExplorerParameters();
    }

    public Geometry getGeometryFromColumn(ResultSet rs, int index) throws DataException {
        try {
            byte[] wkb = rs.getBytes(index);
            if (wkb != null && wkb.length > 0) {
                int count;
                int rings;
                int typeword;
                int realtype;
                ByteBuffer data = ByteBuffer.wrap(wkb);
                byte endian = data.get();
                if (endian == 1) {
                    data.order(ByteOrder.LITTLE_ENDIAN);
                }
                if ((realtype = (typeword = data.getInt()) & 0x1FFFFFFF) == 3 && (rings = data.getInt()) == 1 && (count = data.getInt()) == 2) {
                    data.putInt(9, 5);
                }
                return this.getGeometryManager().createFrom(wkb);
            }
        }
        catch (Exception ex) {
            throw new JDBCCantFetchValueException((Throwable)ex);
        }
        return null;
    }

    protected void replaceExistsFunction(final SQLBuilder sqlbuilder, FeatureType type, final List<String> extra_column_names) {
        final SQLBuilder.SelectBuilder select = sqlbuilder.select();
        GeometryExpressionBuilder where = select.where();
        if (where == null || where.isEmpty() || select.has_group_by()) {
            return;
        }
        ArrayList value_replacements = new ArrayList();
        where.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value) {
                if (!(value instanceof ExpressionBuilder.Function)) {
                    return;
                }
                ExpressionBuilder.Function function = (ExpressionBuilder.Function)value;
                if (!StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"EXISTS")) {
                    return;
                }
                if (function.parameters().size() != 2) {
                    return;
                }
                ExpressionBuilder.Value arg0 = (ExpressionBuilder.Value)function.parameters().get(0);
                ExpressionBuilder.Value arg1 = (ExpressionBuilder.Value)function.parameters().get(1);
                if (arg1 == null) {
                    return;
                }
                String columnName = (String)((ExpressionBuilder.Constant)arg1).value();
                SQLBuilder.SelectColumnBuilder column = select.column();
                column.value((ExpressionBuilder.Value)sqlbuilder.expression().function("CASE", new ExpressionBuilder.Value[]{sqlbuilder.expression().function("EXISTS", new ExpressionBuilder.Value[]{arg0}), sqlbuilder.expression().constant((Object)1), sqlbuilder.expression().constant((Object)0)}));
                column.as(columnName);
                if (extra_column_names != null) {
                    extra_column_names.add(columnName);
                }
            }
        }, null);
        if (value_replacements.isEmpty()) {
            return;
        }
        for (ExpressionBuilder.Value[] replaceValue : value_replacements) {
            ExpressionBuilder.Value target = replaceValue[0];
            ExpressionBuilder.Value replacement = replaceValue[1];
            sqlbuilder.select().replace(target, replacement);
        }
    }

    public JDBCStoreParameters createOpenStoreParameters(JDBCServerExplorerParameters parameters) {
        OracleStoreParameters params = (OracleStoreParameters)super.createOpenStoreParameters(parameters);
        params.setMode(((OracleExplorerParameters)parameters).getMode());
        params.setLobPrefetchSize(((OracleExplorerParameters)parameters).getLobPrefetchSize());
        params.setUpdateSpatialIndexAndMetadata(((OracleExplorerParameters)parameters).getUpdateSpatialIndexAndMetadata());
        if (StringUtils.isBlank((CharSequence)params.getCatalog())) {
            params.setCatalog(StringUtils.upperCase((String)params.getDBName()));
        }
        return params;
    }

    public JDBCStoreProvider createProvider(JDBCStoreParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        OracleStoreProvider theStore = new OracleStoreProvider(parameters, providerServices, DBHelper.newMetadataContainer((String)"JDBC2"), (JDBCHelper)this);
        this.initialize((ResourceConsumer)theStore, (JDBCConnectionParameters)parameters, (JDBCStoreProvider)theStore);
        return theStore;
    }

    public String getConnectionProviderStatus() {
        return this.getConnectionProvider().getStatus();
    }

    public static class OracleConnectionProvider
    extends AbstractConnectionProvider
    implements ConnectionProvider {
        private static boolean needRegisterDriver = true;
        private BasicDataSource dataSource = null;
        private OracleConnectionParameters connectionParameters;

        public OracleConnectionProvider(OracleConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
        }

        public Connection getConnection() throws SQLException {
            if (this.dataSource == null) {
                this.dataSource = this.createDataSource();
                this.dataSource.setAccessToUnderlyingConnectionAllowed(true);
            }
            Connection conn = this.dataSource.getConnection();
            return conn;
        }

        private BasicDataSource createDataSource() throws SQLException {
            if (!this.isRegistered()) {
                this.registerDriver();
            }
            OracleConnectionParameters params = this.connectionParameters;
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(params.getJDBCDriverClassName());
            if (!StringUtils.isEmpty((CharSequence)params.getUser())) {
                ds.setUsername(params.getUser());
            }
            if (!StringUtils.isEmpty((CharSequence)params.getPassword())) {
                ds.setPassword(params.getPassword());
            }
            ds.setUrl(params.getUrl());
            Integer lobPrefetchSize = params.getLobPrefetchSize();
            if (lobPrefetchSize != null) {
                ds.addConnectionProperty("oracle.jdbc.defaultLobPrefetchSize", String.valueOf(lobPrefetchSize));
            }
            ds.setMaxWait(60000L);
            return ds;
        }

        private boolean isRegistered() {
            return needRegisterDriver;
        }

        public void registerDriver() throws SQLException {
            String className = this.connectionParameters.getJDBCDriverClassName();
            if (className == null) {
                return;
            }
            try {
                Class<?> theClass = Class.forName(className);
                if (theClass == null) {
                    throw new JDBCDriverClassNotFoundException("Oracle", className);
                }
            }
            catch (Exception e) {
                throw new SQLException("Can't register JDBC driver '" + className + "'.", e);
            }
            needRegisterDriver = false;
        }

        public String getStatus() {
            StringBuilder builder = new StringBuilder();
            builder.append("Pool: ");
            if (this.dataSource == null) {
                builder.append("DISPOSED (");
                builder.append(this.connectionParameters.getUrl());
                builder.append(")");
            } else {
                builder.append(JDBCUtils.getHexId((Object)this.dataSource));
                builder.append(" Actives: num(");
                builder.append(this.dataSource.getNumActive());
                builder.append(")/max(");
                builder.append(this.dataSource.getMaxActive());
                builder.append(") idle: num(");
                builder.append(this.dataSource.getNumIdle());
                builder.append(")/min(");
                builder.append(this.dataSource.getMinIdle());
                builder.append("):max(");
                builder.append(this.dataSource.getMaxIdle());
                builder.append(") (");
                builder.append(this.dataSource.getUrl());
                builder.append(")");
            }
            return builder.toString();
        }

        public void dispose() {
            if (this.dataSource != null) {
                try {
                    this.dataSource.close();
                }
                catch (SQLException ex) {
                    LOGGER.warn("Can't close BasicDataSource", (Throwable)ex);
                }
                this.dataSource = null;
            }
            this.connectionParameters = null;
        }

        public boolean isDisposed() {
            return this.dataSource == null;
        }
    }
}

