/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParametersBase;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCStoreProviderFactoryBase;
import org.gvsig.oracle.dal.OracleHelper;
import org.gvsig.oracle.dal.OracleStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleStoreProviderFactory
extends JDBCStoreProviderFactoryBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleStoreProviderFactory.class);

    public OracleStoreProviderFactory() {
        super("Oracle", "Oracle store");
    }

    public JDBCStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        OracleHelper helper = new OracleHelper((JDBCConnectionParameters)parameters);
        JDBCStoreProvider provider = null;
        try {
            provider = helper.createProvider((JDBCStoreParameters)((JDBCStoreParametersBase)parameters), providerServices);
        }
        catch (Exception exc) {
            LOGGER.trace("Can't create Oracle provider (this could be correct)", (Throwable)exc);
        }
        return provider;
    }

    public JDBCStoreParametersBase createParameters() {
        OracleStoreParameters params = new OracleStoreParameters();
        return params;
    }

    public boolean preferNotToUseNonNullRestrictions() {
        return true;
    }

    public int allowEditableFeatureType() {
        return 1;
    }
}

