/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.oracle.dal.GeometryTypeUtils;
import org.gvsig.oracle.dal.OracleConnectionParameters;
import org.gvsig.oracle.dal.OracleDimensionMetadata;
import org.gvsig.oracle.dal.operations.OracleUpdateSpatialIndexAndMetadata;
import org.gvsig.tools.dynobject.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialIndexUtils.class);

    public static String getSpatialIndexName(String table, String geomColumn) {
        return ("SDX_" + table + "_" + geomColumn).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSpatialIndex(JDBCConnection connection, String schema, String table, String geomColumnName) {
        PreparedStatement st;
        ResultSet rs;
        block7: {
            String string;
            block6: {
                rs = null;
                st = null;
                try {
                    String sql = "SELECT SDO_INDEX_NAME FROM ALL_SDO_INDEX_METADATA tmd, ALL_SDO_INDEX_INFO tinfo WHERE tmd.SDO_INDEX_OWNER = tinfo.SDO_INDEX_OWNER AND tmd.SDO_INDEX_NAME = tinfo.INDEX_NAME AND TABLE_OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?";
                    st = connection.prepareStatement(sql);
                    st.setString(1, schema);
                    st.setString(2, table);
                    st.setString(3, geomColumnName);
                    rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                    if (rs.next()) {
                        String indexName;
                        string = indexName = rs.getString(1);
                        JDBCUtils.closeQuietly((ResultSet)rs);
                        break block6;
                    }
                    JDBCUtils.closeQuietly((ResultSet)rs);
                    break block7;
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't get geometry type from column '" + geomColumnName + "'.", (Throwable)ex);
                    return null;
                }
            }
            JDBCUtils.closeQuietly((Statement)st);
            return string;
        }
        JDBCUtils.closeQuietly((Statement)st);
        return null;
        finally {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly((Statement)st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidSpatialIndex(JDBCConnection connection, String table) {
        PreparedStatement st;
        ResultSet rs;
        block7: {
            boolean bl;
            block6: {
                rs = null;
                st = null;
                try {
                    String sql = "SELECT DOMIDX_status, domidx_opstatus FROM all_indexes WHERE TABLE_NAME = ? and INDEX_TYPE = 'DOMAIN'";
                    st = connection.prepareStatement(sql);
                    st.setString(1, table);
                    rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
                    if (rs.next()) {
                        String status = rs.getString(1);
                        String opstatus = rs.getString(2);
                        bl = StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"VALID") && StringUtils.equalsIgnoreCase((CharSequence)opstatus, (CharSequence)"VALID");
                        JDBCUtils.closeQuietly((ResultSet)rs);
                        break block6;
                    }
                    JDBCUtils.closeQuietly((ResultSet)rs);
                    break block7;
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't get status from index.", (Throwable)ex);
                    return false;
                }
            }
            JDBCUtils.closeQuietly((Statement)st);
            return bl;
        }
        JDBCUtils.closeQuietly((Statement)st);
        return false;
        finally {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly((Statement)st);
        }
    }

    public static boolean updateSpatialIndexAndMetadata(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType type) {
        try {
            Tags tags;
            OracleConnectionParameters connectionParameters = (OracleConnectionParameters)helper.getConnectionParameters();
            if (connectionParameters.getUpdateSpatialIndexAndMetadata() && (tags = type.getTags()).getBoolean("UpdateSpatialIndexAndMetadata", true)) {
                OracleUpdateSpatialIndexAndMetadata updateIdxOperation = new OracleUpdateSpatialIndexAndMetadata(helper, table.getDatabase(), table.getSchema(), table.getTable().toUpperCase(), type);
                updateIdxOperation.execute();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Error creating/updating the spatial index", (Throwable)e);
            return false;
        }
    }

    public static String getSQLInsertUserMetadata(String table, Envelope bbox, String geomColumnName, int srid) {
        return SpatialIndexUtils.getSQLInsertUserMetadata(table, OracleDimensionMetadata.getDefaultDimensions(bbox), geomColumnName, srid);
    }

    public static String getSQLDeleteUserMetadata(String schema, String table, String geomColumnName) {
        String DELETE_FROM_OGIS_GEOMETRY_COLUMNS_QUERY = "DELETE FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ''{0}'' AND COLUMN_NAME = ''{1}''";
        String sql = MessageFormat.format(DELETE_FROM_OGIS_GEOMETRY_COLUMNS_QUERY, table.toUpperCase(), geomColumnName);
        return sql;
    }

    public static String getSQLInsertUserMetadata(String table, List<OracleDimensionMetadata> dimensions, String geomColumnName, int srid) {
        table = table.toUpperCase();
        StringBuilder sdoMetadataUpdateQuery = new StringBuilder();
        sdoMetadataUpdateQuery.append("INSERT INTO USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, SRID, DIMINFO)");
        sdoMetadataUpdateQuery.append(" VALUES ('");
        sdoMetadataUpdateQuery.append(table);
        sdoMetadataUpdateQuery.append("', '");
        sdoMetadataUpdateQuery.append(geomColumnName);
        sdoMetadataUpdateQuery.append("', ");
        sdoMetadataUpdateQuery.append(srid);
        sdoMetadataUpdateQuery.append(", SDO_DIM_ARRAY(");
        for (int i = 0; i < dimensions.size(); ++i) {
            if (i != 0) {
                sdoMetadataUpdateQuery.append(",");
            }
            sdoMetadataUpdateQuery.append("SDO_DIM_ELEMENT('");
            OracleDimensionMetadata dim = dimensions.get(i);
            sdoMetadataUpdateQuery.append(dim.getName());
            sdoMetadataUpdateQuery.append("', ");
            sdoMetadataUpdateQuery.append(String.format(Locale.ENGLISH, "%f", dim.getLowerBound()));
            sdoMetadataUpdateQuery.append(", ");
            sdoMetadataUpdateQuery.append(String.format(Locale.ENGLISH, "%f", dim.getUpperBound()));
            sdoMetadataUpdateQuery.append(", ");
            sdoMetadataUpdateQuery.append(String.format(Locale.ENGLISH, "%f", dim.getTolerance()));
            sdoMetadataUpdateQuery.append(")");
        }
        sdoMetadataUpdateQuery.append("))");
        String sql = sdoMetadataUpdateQuery.toString();
        return sql;
    }

    public static String getSQLCreateSpatialIndex(String table, String geomColumn, int geomType, int geomsubtype) {
        table = table.toUpperCase();
        String oracleGeomTypeName = GeometryTypeUtils.toOracleGeometryTypeName(geomType);
        int dimensions = GeometryTypeUtils.getDimensions(geomsubtype);
        String indexName = SpatialIndexUtils.getSpatialIndexName(table, geomColumn);
        String createIndexSql = "CREATE INDEX \"{0}\" ON \"{1}\" (\"{2}\") INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS (''SDO_INDX_DIMS={3},LAYER_GTYPE={4}'')";
        String sql = MessageFormat.format(createIndexSql, indexName, table, geomColumn, dimensions, oracleGeomTypeName);
        return sql;
    }

    public static String getSQLRebuildSpatialIndex(String table, String geomColumn, int geomType, int geomsubtype) {
        table = table.toUpperCase();
        String indexName = SpatialIndexUtils.getSpatialIndexName(table, geomColumn);
        String oracleGeomTypeName = GeometryTypeUtils.toOracleGeometryTypeName(geomType);
        int dimensions = GeometryTypeUtils.getDimensions(geomsubtype);
        String rebuildIndexSql = "ALTER INDEX \"{0}\" REBUILD PARAMETERS (''SDO_INDX_DIMS={1},LAYER_GTYPE={2}'')";
        String sql = MessageFormat.format(rebuildIndexSql, indexName, dimensions, oracleGeomTypeName);
        return sql;
    }

    public static String getSQLUpdateUserMetadata(List<OracleDimensionMetadata> dimensions, String geomColumnName, int srid) {
        StringBuilder sdoMetadataUpdateQuery = new StringBuilder();
        sdoMetadataUpdateQuery.append("UPDATE USER_SDO_GEOM_METADATA SET DIMINFO = SDO_DIM_ARRAY(");
        for (int i = 0; i < dimensions.size(); ++i) {
            if (i == 0) {
                sdoMetadataUpdateQuery.append("SDO_DIM_ELEMENT(?, ?, ?, ?)");
                continue;
            }
            sdoMetadataUpdateQuery.append(",SDO_DIM_ELEMENT(?, ?, ?, ?)");
        }
        sdoMetadataUpdateQuery.append("), SRID=? WHERE TABLE_NAME=? AND COLUMN_NAME=?");
        String sql = sdoMetadataUpdateQuery.toString();
        return sql;
    }

    public static void setUpdateUserMetadata(PreparedStatement st, String table, List<OracleDimensionMetadata> dimensions, String geomColumnName, int srid) throws SQLException {
        int paramCount = 1;
        for (OracleDimensionMetadata dim : dimensions) {
            st.setString(paramCount++, dim.getName());
            st.setDouble(paramCount++, dim.getLowerBound());
            st.setDouble(paramCount++, dim.getUpperBound());
            st.setDouble(paramCount++, dim.getTolerance());
        }
        st.setInt(paramCount++, srid);
        st.setString(paramCount++, table);
        st.setString(paramCount++, geomColumnName);
    }
}

