/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.oracle.dal.OracleSQLBuilder;

public class OracleGeometryParameter
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private final OracleSQLBuilder builder;
    private final GeometryExpressionBuilder expbuilder;
    public static final String ORACLE_GEOMETRY_PARAMETER = "oracleGeometryParameter";

    public OracleGeometryParameter(SQLBuilder builder, Formatter<ExpressionBuilder.Value> formatter) {
        this.builder = (OracleSQLBuilder)builder;
        this.formatter = formatter;
        this.expbuilder = builder.expression();
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        return value instanceof GeometryExpressionBuilderHelper.GeometryParameter;
    }

    public String format(ExpressionBuilder.Value param0) {
        GeometryExpressionBuilderHelper.GeometryParameter param = (GeometryExpressionBuilderHelper.GeometryParameter)param0;
        switch (param.type()) {
            case 0: {
                if (param.value() instanceof byte[]) {
                    param.setProperty(ORACLE_GEOMETRY_PARAMETER, (Object)true);
                    return MessageFormat.format("NVL2(({0}),SDO_GEOMETRY(({0}), ({1})),NULL)", "?", this.getSRS(param));
                }
            }
            default: {
                return "?";
            }
            case 2: 
        }
        param.setProperty(ORACLE_GEOMETRY_PARAMETER, (Object)true);
        if (param.srs() == null) {
            return MessageFormat.format("NVL2(({0}),SDO_GEOMETRY({0}),NULL)", "?");
        }
        return MessageFormat.format("NVL2(({0}),SDO_GEOMETRY(({0}), ({1})),NULL)", "?", this.getSRS(param));
    }

    private String getSRS(GeometryExpressionBuilderHelper.GeometryParameter param) {
        String oracle_srid = null;
        FeatureType featureType = (FeatureType)param.getProperty("FeatureType");
        if (featureType != null) {
            if (param.srs() instanceof ExpressionBuilder.Constant) {
                FeatureAttributeDescriptor attr = featureType.getDefaultGeometryAttribute();
                if (attr != null && attr.getTags().has("oracle_srid")) {
                    oracle_srid = Objects.toString(attr.getTags().get("oracle_srid"), null);
                    return oracle_srid;
                }
            } else if (param.srs() instanceof ExpressionBuilder.Parameter) {
                ExpressionBuilder.Parameter srsParam = (ExpressionBuilder.Parameter)param.srs();
                FeatureAttributeDescriptor attr = featureType.getDefaultGeometryAttribute();
                if (attr != null && attr.getTags().has("oracle_srid")) {
                    oracle_srid = Objects.toString(attr.getTags().get("oracle_srid"), null);
                    srsParam.value((Object)oracle_srid);
                }
            }
        }
        if (param.srs() != null) {
            String srid = param.srs().toString(this.formatter);
            return srid;
        }
        IProjection proj = param.geometry().getProjection();
        Object s = this.builder.srs_id(proj);
        if (s == null) {
            throw new IllegalArgumentException("A parameter of type Geometry with an invalid SRS.");
        }
        return s.toString();
    }
}

