/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.operations;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CreateTableOperation;
import org.gvsig.oracle.dal.SpatialIndexUtils;

public class OracleCreateTableOperation
extends CreateTableOperation {
    public OracleCreateTableOperation(JDBCHelper helper) {
        super(helper);
    }

    public OracleCreateTableOperation(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType type, List<Pair<String, SQLBuilder.Privilege>> userAndPrivileges, List<String> additionalSQLs) {
        super(helper, table, type, userAndPrivileges, additionalSQLs);
        EditableFeatureType editableType = this.type.getEditable();
        boolean changed = false;
        for (FeatureAttributeDescriptor attr : editableType) {
            if (attr.getType() != 66 || StringUtils.isAllUpperCase((CharSequence)attr.getName())) continue;
            ((EditableFeatureAttributeDescriptor)attr).setName(attr.getName().toUpperCase());
            changed = true;
        }
        if (changed) {
            this.type = this.type instanceof EditableFeatureType ? editableType.getCopy() : editableType.getNotEditableCopy();
        }
    }

    public boolean performCreateTable(JDBCConnection conn) throws DataException {
        List sqls = this.getSQLs();
        Statement st = null;
        String currsql = null;
        try {
            st = conn.createStatement();
            for (String sql : sqls) {
                LOGGER.info(sql);
                currsql = sql;
                JDBCUtils.execute((Statement)st, (String)sql);
            }
        }
        catch (SQLException ex) {
            throw new JDBCSQLException((Exception)ex, currsql);
        }
        finally {
            JDBCUtils.closeQuietly((Statement)st);
        }
        SpatialIndexUtils.updateSpatialIndexAndMetadata(this.helper, this.table, this.type);
        return true;
    }
}

