/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jzkit.a2j.codec.comp.AsnParser;
import org.jzkit.a2j.codec.comp.CodecBuilderInfo;
import org.jzkit.a2j.codec.comp.ParseException;

public class A2JAntTask
extends Task {
    private String base_package = null;
    private String input_asn = null;
    private String output_dir = null;

    public void setBasePackage(String base_package) {
        this.base_package = base_package;
    }

    public void setInputASNFile(String input_asn) {
        this.input_asn = input_asn;
    }

    public void setOutput(String output_dir) {
        this.output_dir = output_dir;
    }

    public void execute() throws BuildException {
        File next_asn_file;
        System.err.println("Processing asn source file : " + this.input_asn);
        System.err.println("Make sure the output package exists : " + this.output_dir);
        File base_dir = new File(this.output_dir);
        if (!base_dir.exists()) {
            base_dir.mkdirs();
        }
        if ((next_asn_file = new File(this.input_asn)).exists()) {
            try {
                AsnParser parser = new AsnParser(new FileInputStream(next_asn_file));
                parser.setPackageName(this.base_package);
                parser.setOutputDir(this.output_dir);
                parser.Input();
                System.out.println("ASN.1 file " + next_asn_file + " parsed successfully... Calling pass1");
                parser.jjtree.rootNode().pass1();
            }
            catch (ParseException e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(fnfe.toString());
                fnfe.printStackTrace();
            }
        }
        CodecBuilderInfo.getInfo().create();
    }
}

