/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.algorithm;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cresques.Messages;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.roi.ROI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCAStatisticsProcess
extends DataProcess {
    public static final String LAYER_ZONA_ESTUDIO = "LAYER_ZONA_ESTUDIO";
    public static String BANDS = "BANDS";
    public static String PATH = "PATH";
    public static String ROI_EPSG = "ROI_EPSG";
    public static String WINDOW = "WINDOW";
    public static String RASTER_STORE = "RASTER_STORE";
    public static String STATS_RESULT = "STATS_RESULT";
    private boolean[] bands = null;
    private RasterDataStore store = null;
    private Buffer buffer = null;
    private Buffer roiBuffer = null;
    private boolean roiBufferCalculated = false;
    private double[] autovalors = null;
    private Matrix coVarMatrix = null;
    private Matrix autoVectorMatrix = null;
    private double[][] coVar = null;
    private static Logger logger = LoggerFactory.getLogger((String)PCAStatisticsProcess.class.getName());
    private double[][] maxminmean = null;
    private Extent extentResult = null;
    private String path = null;
    private List<ROI> rois = null;
    private boolean[] statsByBandCalculated = null;

    public static void registerParameters() {
        PCAStatisticsProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerInputParameter((String)BANDS, Boolean[].class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerInputParameter((String)PATH, String.class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerOutputParameter((String)STATS_RESULT, PCStatsDataStructure.class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerOutputParameter((String)PATH, String.class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerOutputParameter((String)BANDS, Boolean[].class, (String)"StatsPrincipalComponentsProcess");
        PCAStatisticsProcess.registerOutputParameter((String)ROI_EPSG, String.class, (String)"StatsPrincipalComponentsProcess");
    }

    public void init() {
        this.store = (RasterDataStore)this.getParam(RASTER_STORE);
        this.bands = (boolean[])this.getParam(BANDS);
        this.path = this.getStringParam(PATH);
    }

    public double[] getAutoValors() {
        return this.autovalors;
    }

    public Matrix getAutoVectorMatrix() {
        return this.autoVectorMatrix;
    }

    public Matrix getcoVarMatrix() {
        return this.coVarMatrix;
    }

    public boolean isInsideOfROI(int x, int y, List<ROI> rois, Extent extentResult) {
        boolean a;
        if (this.roiBufferCalculated) {
            return this.roiBuffer.getElemByte(y, x, 0) == 1;
        }
        if (this.roiBuffer == null) {
            this.roiBuffer = this.createOutputBuffer(this.buffer.getWidth(), this.buffer.getHeight(), 1, 0);
        }
        this.roiBuffer.setElem(y, x, 0, (a = super.isInsideOfROI(x, y, rois, extentResult)) ? (byte)1 : 0);
        return a;
    }

    private double[][] covarianceOptimize() throws InterruptedException, ProcessInterruptedException {
        int i;
        NoData nd = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);
        double nodata = nd.getValue().doubleValue();
        double dSum = 0.0;
        int iValues = 0;
        double[][] coV = new double[this.buffer.getBandCount()][this.buffer.getBandCount()];
        double valorBandai = 0.0;
        double valorBandaj = 0.0;
        this.maxminmean = new double[this.buffer.getBandCount()][4];
        this.statsByBandCalculated = new boolean[this.buffer.getBandCount()];
        for (int i2 = 0; i2 < this.statsByBandCalculated.length; ++i2) {
            this.statsByBandCalculated[i2] = false;
        }
        this.loadDataStoreStatistics();
        int percent = 0;
        int maxCounter = 0;
        for (i = this.buffer.getBandCount(); i >= 0; --i) {
            maxCounter += i;
        }
        for (i = 0; i < this.buffer.getBandCount(); ++i) {
            double meanBufferToOperatei = this.getMeanValue(i, this.buffer);
            for (int j = i; j < this.buffer.getBandCount(); ++j) {
                iValues = 0;
                dSum = 0.0;
                double meanBufferToOperatej = this.getMeanValue(j, this.buffer);
                for (int row = 0; row < this.buffer.getHeight(); ++row) {
                    for (int col = 0; col < this.buffer.getWidth(); ++col) {
                        if (!this.isInsideOfROI(col, row, this.rois, this.extentResult)) continue;
                        valorBandai = this.getData(this.buffer, row, col, i) - meanBufferToOperatei;
                        valorBandaj = this.getData(this.buffer, row, col, j) - meanBufferToOperatej;
                        dSum += valorBandai * valorBandaj;
                        ++iValues;
                    }
                    this.updatePercent(percent, maxCounter);
                }
                this.roiBufferCalculated = true;
                coV[i][j] = iValues > 1 ? dSum / (double)iValues : nodata;
                this.updatePercent(++percent, maxCounter);
            }
        }
        for (i = 0; i < this.buffer.getBandCount(); ++i) {
            for (int j = 0; j < this.buffer.getBandCount(); ++j) {
                if (j >= i) continue;
                coV[i][j] = coV[j][i];
            }
        }
        return coV;
    }

    private double getMeanValue(int band, Buffer bufferToOperate) {
        if (this.statsByBandCalculated[band]) {
            return this.maxminmean[band][2];
        }
        double mean = 0.0;
        double variance = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int valuesCounter = 0;
        for (int j = 0; j < bufferToOperate.getHeight(); ++j) {
            for (int i = 0; i < bufferToOperate.getWidth(); ++i) {
                if (!this.isInsideOfROI(i, j, this.rois, this.extentResult)) continue;
                double value = this.getData(bufferToOperate, j, i, band);
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                mean += value;
                variance += value * value;
                ++valuesCounter;
            }
        }
        this.roiBufferCalculated = true;
        variance = variance / (double)valuesCounter - (mean /= (double)valuesCounter) * mean;
        this.maxminmean[band][0] = max;
        this.maxminmean[band][1] = min;
        this.maxminmean[band][2] = mean;
        this.maxminmean[band][3] = variance;
        this.statsByBandCalculated[band] = true;
        return mean;
    }

    private void loadDataStoreStatistics() {
        if (this.isAnalizedEntireLayer(this.getOutputWindow(), this.rois, this.store) && this.store.getStatistics().isCalculated()) {
            double[] max = this.store.getStatistics().getMax();
            double[] min = this.store.getStatistics().getMin();
            double[] mean = this.store.getStatistics().getMean();
            double[] variance = this.store.getStatistics().getVariance();
            int iBand = 0;
            for (int i = 0; i < mean.length; ++i) {
                if (!this.bands[i]) continue;
                this.maxminmean[iBand][0] = max[i];
                this.maxminmean[iBand][1] = min[i];
                this.maxminmean[iBand][2] = mean[i];
                this.maxminmean[iBand][3] = variance[i];
                this.statsByBandCalculated[iBand] = true;
                ++iBand;
            }
        }
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        this.insertLineLog(Messages.getText((String)"preparing_buffers"));
        if (this.getROIEPSG() != null) {
            try {
                this.rois = this.store.getRois(this.getROIEPSG());
            }
            catch (ROIException e2) {
                logger.error(Messages.getText((String)"error_getting_rois"), (Throwable)e2);
            }
        }
        try {
            this.store = this.store.cloneDataStore();
        }
        catch (CloneException e1) {
            throw new ProcessException("Error cloning the sources", (Throwable)e1);
        }
        this.extentResult = this.getExtentResult(this.getOutputWindow(), this.rois, this.store);
        Rectangle2D sourcePxBBox = this.getSourcePxBox(this.extentResult, this.store);
        this.buffer = this.createSourceBuffer(this.store, sourcePxBBox, this.bands);
        this.insertLineLog(Messages.getText((String)"calc_stats"));
        try {
            this.coVar = this.covarianceOptimize();
        }
        catch (InterruptedException e) {
            logger.error(Messages.getText((String)"error_covarianza_optimize"), (Throwable)e);
        }
        this.coVarMatrix = new Matrix(this.coVar);
        EigenvalueDecomposition eigenvalueDecomp = new EigenvalueDecomposition(this.coVarMatrix);
        this.autoVectorMatrix = eigenvalueDecomp.getV();
        this.autovalors = eigenvalueDecomp.getRealEigenvalues();
        PCStatsDataStructure resultStatistics = new PCStatsDataStructure(this.autoVectorMatrix, this.autovalors, this.coVarMatrix);
        resultStatistics.setMaxMinMean(this.maxminmean);
        this.roiBuffer.dispose();
        this.addOutputValue(STATS_RESULT, resultStatistics);
        this.addOutputValue(PATH, this.path);
        this.addOutputValue(BANDS, this.bands);
        this.addOutputValue(ROI_EPSG, this.getROIEPSG());
        try {
            this.store.close();
        }
        catch (CloseException e) {
            throw new ProcessException("Error closing the sources", (Throwable)e);
        }
    }

    public String getTitle() {
        return null;
    }
}

