/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.util;

import java.awt.Color;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.sldconverter.SLDConverterLocator;
import org.gvsig.sldconverter.SLDConverterManager;
import org.gvsig.sldsupport.SLDSupportLocator;
import org.gvsig.sldsupport.SLDSupportManager;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDPropertyName;
import org.gvsig.sldsupport.sld.filter.operator.SLDComparisonOperator;
import org.gvsig.sldsupport.sld.filter.operator.comparison.SLDBinaryComparisonOperator;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.layer.SLDUserLayer;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.gvsig.sldsupport.sld.symbol.SLDLineSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDPointSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDPolygonSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUtils {
    private static Logger logger = LoggerFactory.getLogger(BasicUtils.class);
    public static DecimalFormat df = null;

    public static SLDConverterManager sldMan() {
        return SLDConverterLocator.getInstance().getSLDConverterManager();
    }

    public static SLDSupportManager supMan() {
        return SLDSupportLocator.getInstance().getSLDSupportManager();
    }

    public static SymbologyManager symMan() {
        return SymbologyLocator.getSymbologyManager();
    }

    public static SymbolManager syMan() {
        return MapContextLocator.getSymbolManager();
    }

    public static MapContextManager mapMan() {
        return MapContextLocator.getMapContextManager();
    }

    public static DataTypesManager datMan() {
        return ToolsLocator.getDataTypesManager();
    }

    public static String getFirstPropertyName(List<SLDRule> rules) {
        if (rules == null || rules.size() == 0) {
            return null;
        }
        SLDRule rule = null;
        String fieldName = null;
        for (int i = 0; i < rules.size(); ++i) {
            rule = rules.get(i);
            fieldName = BasicUtils.getFirstPropertyName(rule);
            if (fieldName == null) continue;
            return fieldName;
        }
        return null;
    }

    public static DataType guessDataType(List<SLDLiteral> lits) {
        boolean isDouble = true;
        boolean isInt = true;
        Iterator<SLDLiteral> iter = lits.iterator();
        SLDLiteral lit = null;
        while (iter.hasNext()) {
            lit = iter.next();
            try {
                Double.parseDouble(lit.getValue());
            }
            catch (Exception exc) {
                isDouble = false;
                break;
            }
        }
        if (isDouble) {
            return BasicUtils.datMan().get(7);
        }
        iter = lits.iterator();
        isInt = true;
        while (iter.hasNext()) {
            lit = iter.next();
            try {
                Integer.parseInt(lit.getValue());
            }
            catch (Exception exc) {
                isInt = false;
                break;
            }
        }
        if (isInt) {
            return BasicUtils.datMan().get(4);
        }
        return BasicUtils.datMan().get(8);
    }

    public static Object getValue(SLDLiteral lit, DataType dt) {
        if (lit == null) {
            return null;
        }
        try {
            return dt.coerce((Object)lit.getValue());
        }
        catch (CoercionException e) {
            logger.info("While coercing literal: " + lit.getValue(), (Throwable)e);
            return null;
        }
    }

    public static List<SLDLiteral> getComparisonLiterals(List<SLDRule> rules) {
        ArrayList<SLDLiteral> resp = new ArrayList<SLDLiteral>();
        SLDRule rule = null;
        SLDComparisonOperator item = null;
        for (int i = 0; i < rules.size(); ++i) {
            SLDFilterOperator oper;
            rule = rules.get(i);
            SLDFilter filt = rule.getFilter();
            if (filt == null || filt.isElse() || !((oper = filt.getFilterOperator()) instanceof SLDComparisonOperator)) continue;
            item = (SLDComparisonOperator)oper;
            List list = item.getExpressions();
            for (int j = 0; j < list.size(); ++j) {
                if (!(list.get(j) instanceof SLDLiteral)) continue;
                resp.add((SLDLiteral)list.get(j));
            }
        }
        return resp;
    }

    public static boolean isElse(SLDRule rule) {
        SLDFilter filt = rule.getFilter();
        return filt != null && filt.isElse();
    }

    private static String getFirstPropertyName(SLDRule rule) {
        SLDFilter filt = rule.getFilter();
        if (filt == null) {
            return null;
        }
        SLDFilterOperator oper = filt.getFilterOperator();
        if (oper instanceof SLDComparisonOperator) {
            SLDComparisonOperator cop = (SLDComparisonOperator)oper;
            List list = cop.getExpressions();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof SLDPropertyName)) continue;
                return ((SLDPropertyName)list.get(i)).getPropertyName();
            }
            return null;
        }
        return null;
    }

    public static boolean isNumeric(SLDLiteral lit) {
        try {
            Double.parseDouble(lit.getValue());
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static SLDUserStyle getFirstUserStyle(SLDLayer layer) {
        if (layer instanceof SLDNamedLayer) {
            SLDNamedLayer nl = (SLDNamedLayer)layer;
            for (int i = 0; i < nl.getStyles().size(); ++i) {
                if (!(nl.getStyles().get(i) instanceof SLDUserStyle)) continue;
                return (SLDUserStyle)nl.getStyles().get(i);
            }
            return null;
        }
        if (layer instanceof SLDUserLayer) {
            SLDUserLayer ul = (SLDUserLayer)layer;
            if (ul.getStyles().size() == 1) {
                return (SLDUserStyle)ul.getStyles().get(0);
            }
            return null;
        }
        return null;
    }

    public static int getGeometryTypeForSymbols(List<SLDSymbol> list) {
        if (list == null || list.size() == 0) {
            return 16;
        }
        SLDSymbol ss = list.get(0);
        if (ss instanceof SLDPointSymbol) {
            if (BasicUtils.allItemsOfClass(list, SLDPointSymbol.class)) {
                return 1;
            }
        } else if (ss instanceof SLDLineSymbol) {
            if (BasicUtils.allItemsOfClass(list, SLDLineSymbol.class)) {
                return 2;
            }
        } else if (ss instanceof SLDPolygonSymbol) {
            if (BasicUtils.allItemsOfClass(list, SLDPolygonSymbol.class)) {
                return 3;
            }
        } else {
            return 16;
        }
        return 16;
    }

    private static boolean allItemsOfClass(List<SLDSymbol> list, Class clazz) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getClass() == clazz) continue;
            return false;
        }
        return true;
    }

    public static ISymbol combineSymbols(List<ISymbol> gsyms, int geotype) {
        if (gsyms.size() == 1) {
            return gsyms.get(0);
        }
        IMultiLayerSymbol resp = BasicUtils.syMan().createMultiLayerSymbol(geotype);
        for (int i = 0; i < gsyms.size(); ++i) {
            resp.addLayer(gsyms.get(i));
        }
        return resp;
    }

    public static Double toDouble(SLDExpression width) throws UnsupportedSLDObjectException {
        if (width instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)width;
            try {
                double resp = Double.parseDouble(lit.getValue());
                return new Double(resp);
            }
            catch (Exception exc) {
                logger.info("Non parseable double: " + exc.getMessage());
                return null;
            }
        }
        throw new UnsupportedSLDObjectException("SLDExpression", "Not supported as Double: " + width.getClass().getName());
    }

    private static Integer toInteger(SLDExpression width) {
        if (width instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)width;
            try {
                int resp = Integer.parseInt(lit.getValue());
                return new Integer(resp);
            }
            catch (Exception exc) {
                logger.info("Non parseable integer: " + exc.getMessage());
                return null;
            }
        }
        return null;
    }

    public static Color parseColor(String colorStr) {
        Color co = null;
        try {
            co = Color.decode(colorStr.trim());
        }
        catch (Exception exc) {
            logger.info("Non parseable color: " + exc.getMessage());
        }
        return co;
    }

    public static String toHexadecimal(Color co, int length, String prefix) {
        if (co == null) {
            return null;
        }
        int v = (co.getRed() << 16) + (co.getGreen() << 8) + co.getBlue();
        String resp = Integer.toHexString(v);
        int len = resp.length();
        for (int i = 0; i < length - len; ++i) {
            resp = "0" + resp;
        }
        resp = resp.substring(resp.length() - length);
        if (prefix != null) {
            resp = prefix + resp;
        }
        return resp;
    }

    public static Color getColor(SLDParameterValue valu) {
        List list = valu.getExpressionList();
        if (list == null || list.size() == 0) {
            return null;
        }
        SLDExpression expr = (SLDExpression)list.get(0);
        if (expr instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)expr;
            return BasicUtils.parseColor(lit.getValue());
        }
        return null;
    }

    public static Color getColor(SLDExpression valu) {
        if (valu instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)valu;
            return BasicUtils.parseColor(lit.getValue());
        }
        return null;
    }

    public static Double getDouble(SLDParameterValue valu) throws UnsupportedSLDObjectException {
        List list = valu.getExpressionList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return BasicUtils.toDouble((SLDExpression)list.get(0));
    }

    public static Integer getAlphaValue(SLDParameterValue valu) throws UnsupportedSLDObjectException {
        List list = valu.getExpressionList();
        if (list == null || list.size() == 0) {
            return null;
        }
        Double d = BasicUtils.toDouble((SLDExpression)list.get(0));
        if (d == null) {
            return null;
        }
        if (d <= 0.0) {
            return new Integer(0);
        }
        if (d >= 1.0) {
            return new Integer(255);
        }
        return new Integer((int)Math.round(255.0 * d));
    }

    public static Color toColor(SLDExpression color) throws UnsupportedSLDObjectException {
        if (color instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)color;
            Color resp = null;
            resp = BasicUtils.parseColor(lit.getValue());
            return resp;
        }
        throw new UnsupportedSLDObjectException("SLDExpression", "Not supported as Color: " + color.getClass().getName());
    }

    public static String getFormat(URL u) {
        if (u == null) {
            return "";
        }
        String str = u.toString();
        int lastp = str.lastIndexOf(".");
        if (lastp == -1) {
            return "";
        }
        str = str.substring(lastp + 1);
        return "image/" + str;
    }

    public static ISymbol getElseSymbol(List<SLDRule> rules) throws UnsupportedSLDObjectException {
        if (rules == null || rules.size() == 0) {
            return null;
        }
        SLDFilter filt = null;
        List symList = null;
        for (int i = 0; i < rules.size(); ++i) {
            filt = rules.get(i).getFilter();
            if (filt == null || !filt.isElse() || (symList = rules.get(i).getSymbols()) == null || symList.size() <= 0) continue;
            return BasicUtils.sldMan().toSymbol((SLDSymbol)symList.get(0));
        }
        return null;
    }

    private static boolean isEqualsTo(SLDFilterOperator oper) {
        if (oper instanceof SLDBinaryComparisonOperator) {
            SLDBinaryComparisonOperator binoper = (SLDBinaryComparisonOperator)oper;
            return binoper.getComparisonOperator().compareToIgnoreCase("PropertyIsEqualTo") == 0;
        }
        return false;
    }

    public static Map<Object, ISymbol> getValueToSymbol(List<SLDRule> rules, DataType dt, String pname) throws UnsupportedSLDObjectException {
        HashMap<Object, ISymbol> resp = new HashMap<Object, ISymbol>();
        if (rules == null || rules.size() == 0) {
            return resp;
        }
        SLDFilter filt = null;
        List symList = null;
        SLDFilterOperator oper = null;
        SLDBinaryComparisonOperator binoper = null;
        ISymbol sym = null;
        SLDPropertyName sldpname = null;
        SLDLiteral sldlit = null;
        Object val = null;
        for (int i = 0; i < rules.size(); ++i) {
            symList = rules.get(i).getSymbols();
            if (symList == null || symList.size() == 0 || (filt = rules.get(i).getFilter()) == null || filt.isElse() || !((oper = filt.getFilterOperator()) instanceof SLDBinaryComparisonOperator) || !BasicUtils.isEqualsTo(oper)) continue;
            binoper = (SLDBinaryComparisonOperator)oper;
            if (binoper.getFirstExpression() instanceof SLDLiteral && binoper.getSecondExpression() instanceof SLDPropertyName && (sldpname = (SLDPropertyName)binoper.getSecondExpression()).getPropertyName().compareTo(pname) == 0) {
                sldlit = (SLDLiteral)binoper.getFirstExpression();
                val = BasicUtils.getValue(sldlit, dt);
                sym = BasicUtils.sldMan().toSymbol((SLDSymbol)symList.get(0));
                if (val != null && sym != null) {
                    sym.setDescription(sldlit.getValue());
                    resp.put(val, sym);
                }
            }
            if (!(binoper.getFirstExpression() instanceof SLDPropertyName) || !(binoper.getSecondExpression() instanceof SLDLiteral) || (sldpname = (SLDPropertyName)binoper.getFirstExpression()).getPropertyName().compareTo(pname) != 0) continue;
            sldlit = (SLDLiteral)binoper.getSecondExpression();
            val = BasicUtils.getValue(sldlit, dt);
            sym = BasicUtils.sldMan().toSymbol((SLDSymbol)symList.get(0));
            if (val == null || sym == null) continue;
            resp.put(val, sym);
        }
        return resp;
    }

    public static SLDLiteral getLiteral(List<SLDExpression> exps) {
        for (int i = 0; i < exps.size(); ++i) {
            if (!(exps.get(i) instanceof SLDLiteral)) continue;
            return (SLDLiteral)exps.get(i);
        }
        return null;
    }

    public static String valueToString(Object val) {
        if (val instanceof Double) {
            return df.format((Double)val);
        }
        if (val instanceof Float) {
            return df.format(((Float)val).doubleValue());
        }
        return val == null ? "" : val.toString();
    }

    static {
        DecimalFormatSymbols dformater_rules = new DecimalFormatSymbols();
        dformater_rules.setDecimalSeparator('.');
        df = new DecimalFormat("##########.0##########", dformater_rules);
    }
}

