/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext;

import java.awt.geom.Rectangle2D;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class ExtentHistory
implements Persistent {
    private static final String FIELD_CURRENT_EXTENT = "current";
    private static final String FIELD_NUM_PREVIOUS = "num";
    private static final String FIELD_NUM_NEXT = "numnext";
    private static final String FIELD_NUM_RECORDS = "numrec";
    private static final String FIELD_PREVIOUS_EXTENTS = "extents";
    private static final String FIELD_NEXT_EXTENTS = "extentsNext";
    private int NUMREC;
    private Rectangle2D[] extentsPrev;
    private Rectangle2D[] extentsNext;
    private Rectangle2D currentExtent;
    private int numPrev = 0;
    private int numNext = 0;

    public ExtentHistory() {
        this(10);
    }

    public ExtentHistory(int numEntries) {
        this.NUMREC = numEntries;
        this.extentsPrev = new Rectangle2D[this.NUMREC];
        this.extentsNext = new Rectangle2D[this.NUMREC];
    }

    public void put(Rectangle2D ext) {
        if (this.currentExtent == null) {
            this.currentExtent = ext;
            return;
        }
        if (!ext.equals(this.getPrev()) && !ext.equals(this.getNext())) {
            this.clearNumNext();
        }
        this.pushPrevious(this.currentExtent);
        this.currentExtent = ext;
    }

    public boolean hasPrevious() {
        return this.numPrev > 0;
    }

    public boolean hasNext() {
        return this.numNext > 0;
    }

    public Rectangle2D getPrev() {
        if (this.numPrev <= 0) {
            return null;
        }
        Rectangle2D ext = this.extentsPrev[this.numPrev - 1];
        return ext;
    }

    public Rectangle2D getNext() {
        if (this.numNext <= 0) {
            return null;
        }
        Rectangle2D ext = this.extentsNext[this.numNext - 1];
        return ext;
    }

    private Rectangle2D popPrev() {
        if (this.numPrev <= 0) {
            return null;
        }
        Rectangle2D ext = this.extentsPrev[--this.numPrev];
        return ext;
    }

    private Rectangle2D popNext() {
        if (this.numNext <= 0) {
            return null;
        }
        Rectangle2D ext = this.extentsNext[--this.numNext];
        return ext;
    }

    private void clearNumPrev() {
        this.numPrev = 0;
    }

    private void clearNumNext() {
        this.numNext = 0;
    }

    public Rectangle2D setPreviousExtent() {
        if (this.currentExtent != null) {
            this.pushNext(this.currentExtent);
        }
        this.currentExtent = this.popPrev();
        return this.currentExtent;
    }

    private void pushNext(Rectangle2D ext) {
        if (this.numNext < this.NUMREC) {
            this.extentsNext[this.numNext] = ext;
            ++this.numNext;
        } else {
            for (int i = 0; i < this.NUMREC - 1; ++i) {
                this.extentsNext[i] = this.extentsNext[i + 1];
            }
            this.extentsNext[this.numNext - 1] = ext;
        }
    }

    public Rectangle2D setNextExtent() {
        if (this.currentExtent != null) {
            this.pushPrevious(this.currentExtent);
        }
        this.currentExtent = this.popNext();
        return this.currentExtent;
    }

    private void pushPrevious(Rectangle2D ext) {
        if (this.numPrev < this.NUMREC) {
            this.extentsPrev[this.numPrev] = ext;
            ++this.numPrev;
        } else {
            for (int i = 0; i < this.NUMREC - 1; ++i) {
                this.extentsPrev[i] = this.extentsPrev[i + 1];
            }
            this.extentsPrev[this.numPrev - 1] = ext;
        }
    }

    public Rectangle2D getCurrent() {
        return this.currentExtent;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        int i;
        if (state.hasValue(FIELD_NUM_PREVIOUS)) {
            this.numPrev = state.getInt(FIELD_NUM_PREVIOUS);
        } else {
            this.clearNumPrev();
        }
        if (state.hasValue(FIELD_NUM_NEXT)) {
            this.numNext = state.getInt(FIELD_NUM_NEXT);
        } else {
            this.clearNumNext();
        }
        this.NUMREC = state.hasValue(FIELD_NUM_RECORDS) ? state.getInt(FIELD_NUM_RECORDS) : 10;
        this.extentsPrev = new Rectangle2D[this.NUMREC];
        this.clearNumPrev();
        if (state.hasValue(FIELD_PREVIOUS_EXTENTS)) {
            Rectangle2D[] storedExtentPrev = (Rectangle2D[])state.getArray(FIELD_PREVIOUS_EXTENTS, Rectangle2D.class);
            if (storedExtentPrev.length >= this.NUMREC) {
                this.extentsPrev = storedExtentPrev;
                this.NUMREC = storedExtentPrev.length;
            } else {
                for (i = 0; i < storedExtentPrev.length; ++i) {
                    this.extentsPrev[i] = storedExtentPrev[i];
                }
            }
        }
        this.extentsNext = new Rectangle2D[this.NUMREC];
        this.clearNumNext();
        if (state.hasValue(FIELD_NEXT_EXTENTS)) {
            Rectangle2D[] storedExtentsNext = (Rectangle2D[])state.getArray(FIELD_NEXT_EXTENTS, Rectangle2D.class);
            if (storedExtentsNext.length >= this.NUMREC) {
                this.extentsNext = storedExtentsNext;
                this.NUMREC = storedExtentsNext.length;
            } else {
                for (i = 0; i < storedExtentsNext.length; ++i) {
                    this.extentsNext[i] = storedExtentsNext[i];
                }
            }
        }
        this.currentExtent = state.hasValue(FIELD_CURRENT_EXTENT) ? (Rectangle2D)state.get(FIELD_CURRENT_EXTENT) : null;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_NUM_PREVIOUS, this.numPrev);
        state.set(FIELD_NUM_NEXT, this.numNext);
        state.set(FIELD_NUM_RECORDS, this.NUMREC);
        state.set(FIELD_PREVIOUS_EXTENTS, (Object[])this.extentsPrev);
        state.set(FIELD_NEXT_EXTENTS, (Object[])this.extentsNext);
        state.set(FIELD_CURRENT_EXTENT, (Object)this.currentExtent);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(ExtentHistory.class, "ExtentHistory", "ExtentHistory Persistence definition", null, null);
            definition.addDynFieldInt(ExtentHistory.FIELD_NUM_PREVIOUS).setMandatory(true);
            definition.addDynFieldInt(ExtentHistory.FIELD_NUM_NEXT).setMandatory(true);
            definition.addDynFieldInt(ExtentHistory.FIELD_NUM_RECORDS).setMandatory(true);
            definition.addDynFieldArray(ExtentHistory.FIELD_PREVIOUS_EXTENTS).setClassOfItems(Rectangle2D.class).setMandatory(true);
            definition.addDynFieldArray(ExtentHistory.FIELD_NEXT_EXTENTS).setClassOfItems(Rectangle2D.class).setMandatory(true);
            definition.addDynFieldObject(ExtentHistory.FIELD_CURRENT_EXTENT).setClassOfValue(Rectangle2D.class).setMandatory(false);
            return Boolean.TRUE;
        }
    }
}

