/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.events.listeners;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.mapcontext.events.AtomicEvent;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.FMapEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListenerEx1;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.SelectionEvent;
import org.gvsig.fmap.mapcontext.layers.SelectionListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuffer
implements LegendListener,
LayerCollectionListener,
SelectionListener,
ViewPortListenerEx1,
LayerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuffer.class);
    private final List<FMapEvent> events = new ArrayList<FMapEvent>();
    private final List<AtomicEventListener> listeners = new ArrayList<AtomicEventListener>();
    private boolean dispatching = true;

    public void beginAtomicEvent() {
        this.dispatching = false;
    }

    public void endAtomicEvent() {
        this.fireAtomicEventListener();
        this.events.clear();
        this.dispatching = true;
    }

    @Override
    public void legendChanged(LegendChangedEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerAdded(LayerCollectionEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerMoved(LayerPositionEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerRemoved(LayerCollectionEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerAdding(LayerCollectionEvent e) throws CancelationException {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerMoving(LayerPositionEvent e) throws CancelationException {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void extentChanged(ExtentEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    public boolean addAtomicEventListener(AtomicEventListener listener) {
        boolean bFound = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            bFound = true;
        }
        if (!bFound) {
            this.listeners.add(listener);
        }
        return true;
    }

    public List<AtomicEventListener> getAtomicEventListeners() {
        return this.listeners;
    }

    public boolean removeAtomicEventListener(AtomicEventListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireAtomicEventListener() {
        if (this.events.isEmpty()) {
            return;
        }
        for (AtomicEventListener listener : this.listeners) {
            if (listener == null) continue;
            AtomicEvent e = new AtomicEvent(this.events);
            try {
                listener.atomicEvent(e);
            }
            catch (Exception ex) {
                LOGGER.warn("Problems calling listener (" + listener.getClass().getName() + ").", (Throwable)ex);
            }
        }
        this.events.clear();
    }

    @Override
    public void visibilityChanged(LayerEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void activationChanged(LayerEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void nameChanged(LayerEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void backColorChanged(ColorEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void selectionColorChanged(ColorEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void editionChanged(LayerEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }

    @Override
    public void drawValueChanged(LayerEvent e) {
        this.events.add(e);
        if (this.dispatching) {
            this.fireAtomicEventListener();
        }
    }
}

